/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static boolean isSerializable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable");
    }

    public static boolean isExternalizable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Externalizable");
    }

    public static boolean isDirectlySerializable(@NotNull PsiClass aClass) {
        PsiJavaCodeReferenceElement[] interfaces;
        PsiReferenceList implementsList;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(0);
        }
        if ((implementsList = aClass.getImplementsList()) == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement aInterfaces : interfaces = implementsList.getReferenceElements()) {
            String name;
            PsiClass implemented = (PsiClass)aInterfaces.resolve();
            if (implemented == null || !"java.io.Serializable".equals(name = implemented.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(1);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("readObject", false)) {
            if (!SerializationUtils.isReadObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadResolve(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(2);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("readResolve", true)) {
            if (!SerializationUtils.isReadResolve(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(3);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            if (!SerializationUtils.isWriteObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteReplace(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(4);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeReplace", true)) {
            if (!SerializationUtils.isWriteReplace(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadObject(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(5);
        }
        PsiClassType type2 = TypeUtils.getType("java.io.ObjectInputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "readObject", new PsiType[]{type2});
    }

    public static boolean isWriteObject(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(6);
        }
        PsiClassType type2 = TypeUtils.getType("java.io.ObjectOutputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "writeObject", new PsiType[]{type2});
    }

    public static boolean isReadResolve(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(7);
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "readResolve", new String[0]);
    }

    public static boolean isWriteReplace(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(8);
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "writeReplace", new String[0]);
    }

    public static boolean isProbablySerializable(PsiType type2) {
        if (type2 instanceof PsiWildcardType) {
            return true;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (type2 instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type2;
            PsiType componentType = arrayType.getComponentType();
            return SerializationUtils.isProbablySerializable(componentType);
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null || psiClass.hasModifierProperty("abstract")) {
                return true;
            }
            if (SerializationUtils.isSerializable(psiClass)) {
                return true;
            }
            if (SerializationUtils.isExternalizable(psiClass)) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Map")) {
                PsiType[] parameters2;
                for (PsiType parameter2 : parameters2 = classType.getParameters()) {
                    if (SerializationUtils.isProbablySerializable(parameter2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/SerializationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlySerializable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReadObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReadResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteReplace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

