/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantOperationOnEmptyContainerInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher ARRAY_METHODS = CallMatcher.staticCall("java.util.Arrays", "binarySearch", "fill", "parallelPrefix", "parallelSort", "setAll", "sort", "spliterator", "stream");
    private static final CallMatcher COLLECTION_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.Iterable", "iterator", "spliterator").parameterCount(0), CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer"), CallMatcher.instanceCall("java.util.Collection", "remove").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Collection", "removeAll", "retainAll").parameterTypes("java.util.Collection"), CallMatcher.instanceCall("java.util.Collection", "stream", "parallelStream", "clear").parameterCount(0), CallMatcher.instanceCall("java.util.Collection", "removeIf").parameterTypes("java.util.function.Predicate"), CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int"), CallMatcher.instanceCall("java.util.List", "replaceAll").parameterTypes("java.util.function.UnaryOperator"), CallMatcher.instanceCall("java.util.List", "sort").parameterTypes("java.util.Comparator"));
    private static final CallMatcher MAP_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Map", "forEach").parameterTypes("java.util.function.BiConsumer"), CallMatcher.instanceCall("java.util.Map", "get", "remove").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Map", "remove", "replace").parameterCount(2), CallMatcher.instanceCall("java.util.Map", "replace").parameterCount(3), CallMatcher.instanceCall("java.util.Map", "replaceAll").parameterTypes("java.util.function.BiFunction"), CallMatcher.instanceCall("java.util.Map", "clear").parameterCount(0));
    private static final CallMatcher COLLECTIONS_EMPTY = CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantOperationOnEmptyContainerInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression container = null;
                if (ARRAY_METHODS.test(call)) {
                    container = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                } else if (COLLECTION_METHODS.test(call) || MAP_METHODS.test(call)) {
                    container = call.getMethodExpression().getQualifierExpression();
                    if ("iterator".equals(call.getMethodExpression().getReferenceName()) && COLLECTIONS_EMPTY.matches(container)) {
                        return;
                    }
                }
                container = PsiUtil.skipParenthesizedExprDown((PsiExpression)container);
                if (container != null) {
                    String msg = this.getProblemMessage(container);
                    if (msg == null) {
                        return;
                    }
                    DeleteElementFix fix2 = null;
                    if (ExpressionUtils.isVoidContext((PsiExpression)call)) {
                        fix2 = new DeleteElementFix((PsiElement)call, "Remove call");
                    }
                    holder.registerProblem((PsiElement)container, msg, new LocalQuickFix[]{fix2});
                }
            }

            public void visitForeachStatement(PsiForeachStatement statement) {
                PsiExpression value2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getIteratedValue());
                if (value2 == null) {
                    return;
                }
                String msg = this.getProblemMessage(value2);
                if (msg == null) {
                    return;
                }
                holder.registerProblem((PsiElement)value2, msg, new LocalQuickFix[]{new DeleteElementFix((PsiElement)statement, "Remove loop")});
            }

            @Nullable
            public String getProblemMessage(PsiExpression value2) {
                String message2;
                SpecialField lengthField;
                PsiType type2 = value2.getType();
                if (type2 instanceof PsiArrayType) {
                    lengthField = SpecialField.ARRAY_LENGTH;
                    message2 = InspectionsBundle.message((String)"inspection.redundant.operation.on.empty.array.message", (Object[])new Object[0]);
                } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection")) {
                    lengthField = SpecialField.COLLECTION_SIZE;
                    message2 = InspectionsBundle.message((String)"inspection.redundant.operation.on.empty.collection.message", (Object[])new Object[0]);
                } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                    lengthField = SpecialField.COLLECTION_SIZE;
                    message2 = InspectionsBundle.message((String)"inspection.redundant.operation.on.empty.map.message", (Object[])new Object[0]);
                } else {
                    return null;
                }
                SpecialFieldValue fact = CommonDataflow.getExpressionFact(value2, DfaFactType.SPECIAL_FIELD_VALUE);
                DfaValue length = lengthField.extract(fact);
                if (length instanceof DfaConstValue && Long.valueOf(0L).equals(((DfaConstValue)length).getValue())) {
                    return message2;
                }
                return null;
            }
        };
        if (javaElementVisitor == null) {
            RedundantOperationOnEmptyContainerInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/redundancy/RedundantOperationOnEmptyContainerInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/redundancy/RedundantOperationOnEmptyContainerInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

