/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ReadObjectInitializationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("InstanceVariableMayNotBeInitializedByReadObject" == null) {
            ReadObjectInitializationInspection.$$$reportNull$$$0(0);
        }
        return "InstanceVariableMayNotBeInitializedByReadObject";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("readobject.initialization.display.name", new Object[0]);
        if (string == null) {
            ReadObjectInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("readobject.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            ReadObjectInitializationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/ReadObjectInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass;
            if (method == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = method.getContainingClass()) == null) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (!SerializationUtils.isReadObject(method)) {
                return;
            }
            boolean defaultReadObjectCalled = ControlFlowUtils.elementContainsCallToMethod((PsiElement)method, "java.io.ObjectInputStream", (PsiType)PsiType.VOID, "defaultReadObject", new PsiType[0]);
            PsiField[] fields = aClass.getFields();
            if (defaultReadObjectCalled) {
                for (PsiField field : fields) {
                    if (!field.hasModifierProperty("transient") || ReadObjectInitializationVisitor.isFieldInitialized(field, method)) continue;
                    this.registerFieldError(field, new Object[0]);
                }
            } else {
                for (PsiField field : fields) {
                    if (ReadObjectInitializationVisitor.isFieldInitialized(field, method)) continue;
                    this.registerFieldError(field, new Object[0]);
                }
            }
        }

        public static boolean isFieldInitialized(@NotNull PsiField field, @NotNull PsiMethod method) {
            if (field == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(1);
            }
            if (method == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(2);
            }
            if (field.hasModifierProperty("static")) {
                return true;
            }
            if (field.hasModifierProperty("final") && field.getInitializer() != null) {
                return true;
            }
            return InitializationUtils.methodAssignsVariableOrFails(method, (PsiVariable)field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/ReadObjectInitializationInspection$ReadObjectInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFieldInitialized";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

