/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethodParametersHidingInstanceFields = true;
    public boolean m_ignoreForConstructors = false;
    public boolean m_ignoreForPropertySetters = false;
    public boolean m_ignoreForAbstractMethods = false;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        if ("ParameterHidesMemberVariable" == null) {
            ParameterHidingMemberVariableInspection.$$$reportNull$$$0(0);
        }
        return "ParameterHidesMemberVariable";
    }

    @Nullable
    public String getAlternativeID() {
        return "hiding";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            ParameterHidingMemberVariableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            ParameterHidingMemberVariableInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.setters.option", new Object[0]), "m_ignoreForPropertySetters");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.superclass.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.constructors.option", new Object[0]), "m_ignoreForConstructors");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.abstract.methods.option", new Object[0]), "m_ignoreForAbstractMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.static.parameters.option", new Object[0]), "m_ignoreStaticMethodParametersHidingInstanceFields");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private ParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiClass aClass;
            if (variable == null) {
                ParameterHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)declarationScope;
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForConstructors && method.isConstructor()) {
                return;
            }
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForAbstractMethods) {
                if (method.hasModifierProperty("abstract")) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && containingClass.isInterface()) {
                    return;
                }
            }
            if (ParameterHidingMemberVariableInspection.this.m_ignoreForPropertySetters) {
                String methodName = method.getName();
                if (methodName.startsWith("set") && PsiType.VOID.equals((Object)method.getReturnType())) {
                    return;
                }
                if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                    return;
                }
            }
            if ((aClass = this.checkFieldName((PsiVariable)variable, method)) == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable, PsiMethod method) {
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)method);
            while (aClass != null) {
                PsiField field = aClass.findFieldByName(variableName, true);
                if (!(field == null || ParameterHidingMemberVariableInspection.this.m_ignoreStaticMethodParametersHidingInstanceFields && !field.hasModifierProperty("static") && method.hasModifierProperty("static") || ParameterHidingMemberVariableInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass))) {
                    return aClass;
                }
                if (aClass.hasModifierProperty("static") && ParameterHidingMemberVariableInspection.this.m_ignoreStaticMethodParametersHidingInstanceFields) {
                    return null;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/ParameterHidingMemberVariableInspection$ParameterHidingMemberVariableVisitor", "visitParameter"));
        }
    }
}

