/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class FlipCommutativeMethodCallPredicate
implements PsiElementPredicate {
    FlipCommutativeMethodCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod[] methods;
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length != 1) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        PsiType callerType = qualifier.getType();
        PsiType argumentType = args[0].getType();
        if (!(argumentType instanceof PsiClassType)) {
            return false;
        }
        if (!(callerType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)argumentType).resolveGenerics();
        PsiClass argumentClass = resolveResult.getElement();
        if (argumentClass == null) {
            return false;
        }
        for (PsiMethod testMethod : methods = argumentClass.findMethodsByName(methodName, true)) {
            PsiType type2;
            PsiSubstitutor substitutor;
            PsiParameterList parameterList;
            PsiParameter[] parameters2;
            String testMethodName = testMethod.getName();
            if (!testMethodName.equals(methodName) || (parameters2 = (parameterList = testMethod.getParameterList()).getParameters()).length != 1) continue;
            PsiParameter parameter2 = parameters2[0];
            PsiClass containingClass = testMethod.getContainingClass();
            if (containingClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)argumentClass, (PsiSubstitutor)resolveResult.getSubstitutor())) == null || (type2 = substitutor.substitute(parameter2.getType())) == null || !type2.isAssignableFrom(callerType)) continue;
            return true;
        }
        return false;
    }
}

