/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class CallMaker {
    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions) {
        return CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode2, calleeExpression, argumentExpressions, Call.CallType.DEFAULT, false);
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType) {
        return CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode2, calleeExpression, argumentExpressions, callType, false);
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
        List arguments2;
        if (argumentExpressions.isEmpty()) {
            arguments2 = Collections.emptyList();
        } else {
            arguments2 = new ArrayList(argumentExpressions.size());
            for (KtExpression argumentExpression : argumentExpressions) {
                arguments2.add(CallMaker.makeValueArgument(argumentExpression, calleeExpression));
            }
        }
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode2, calleeExpression, arguments2, callType, isSemanticallyEquivalentToSafeCall);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, KtExpression calleeExpression, List<? extends ValueArgument> arguments2) {
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode2, calleeExpression, arguments2, Call.CallType.DEFAULT);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType) {
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode2, calleeExpression, arguments2, callType, false);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
        return new CallImpl(callElement, explicitReceiver, callOperationNode2, calleeExpression, arguments2, callType, isSemanticallyEquivalentToSafeCall);
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue leftAsReceiver, KtBinaryExpression expression2) {
        return CallMaker.makeCallWithExpressions(expression2, leftAsReceiver, null, expression2.getOperationReference(), Collections.singletonList(expression2.getRight()));
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue baseAsReceiver, KtUnaryExpression expression2) {
        return CallMaker.makeCall(expression2, baseAsReceiver, null, expression2.getOperationReference(), Collections.emptyList());
    }

    @NotNull
    public static Call makeArraySetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull Call.CallType callType) {
        ArrayList<KtExpression> arguments2 = Lists.newArrayList(arrayAccessExpression.getIndexExpressions());
        arguments2.add(rightHandSide);
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arguments2, callType);
    }

    @NotNull
    public static Call makeArrayGetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull Call.CallType callType) {
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arrayAccessExpression.getIndexExpressions(), callType);
    }

    public static Call makeCallForCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression) {
        return CallMaker.makeCallWithExpressions(collectionLiteralExpression, null, null, collectionLiteralExpression, collectionLiteralExpression.getInnerExpressions(), Call.CallType.DEFAULT);
    }

    @NotNull
    public static ValueArgument makeValueArgument(@NotNull KtExpression expression2) {
        return CallMaker.makeValueArgument(expression2, expression2);
    }

    @NotNull
    public static ValueArgument makeValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn) {
        return new ExpressionValueArgument(expression2, reportErrorsOn, false);
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression2) {
        return new ExpressionValueArgument(expression2, expression2, true);
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression2, @NotNull KtElement reportErrorsOn) {
        return new ExpressionValueArgument(expression2, reportErrorsOn, true);
    }

    @NotNull
    public static Call makePropertyCall(@Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @NotNull KtSimpleNameExpression nameExpression) {
        return CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode2, nameExpression, Collections.emptyList());
    }

    @NotNull
    public static Call makeConstructorCallWithoutTypeArguments(@NotNull KtCallElement callElement) {
        return new DelegatingCall(CallMaker.makeCall(null, null, callElement)){

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }
        };
    }

    @NotNull
    public static Call makeConstructorCallForEnumEntryWithoutInitializer(final @NotNull KtSuperTypeCallEntry callElement) {
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                return callElement.getValueArguments();
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                return callElement;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                return Call.CallType.DEFAULT;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }
        };
    }

    @NotNull
    public static Call makeCall(final @Nullable Receiver explicitReceiver, final @Nullable ASTNode callOperationNode2, final @NotNull KtCallElement callElement) {
        return new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode2;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return explicitReceiver;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                return callElement.getValueArguments();
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                return callElement.getLambdaArguments();
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                return callElement.getTypeArguments();
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                return callElement;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                return Call.CallType.DEFAULT;
            }
        };
    }

    @NotNull
    public static Call makeCall(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver) {
        return new CallImpl(callElement, explicitReceiver, null, null, Collections.emptyList());
    }

    private static class CallImpl
    implements Call {
        private final KtElement callElement;
        private final Receiver explicitReceiver;
        private final ASTNode callOperationNode;
        private final KtExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;
        private final Call.CallType callType;
        private final boolean isSemanticallyEquivalentToSafeCall;

        protected CallImpl(@NotNull KtElement callElement, @NotNull Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments) {
            this(callElement, explicitReceiver, callOperationNode2, calleeExpression, valueArguments, Call.CallType.DEFAULT, false);
        }

        protected CallImpl(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode2, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments, @NotNull Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode2;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments;
            this.callType = callType;
            this.isSemanticallyEquivalentToSafeCall = isSemanticallyEquivalentToSafeCall;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        public boolean isSemanticallyEquivalentToSafeCall() {
            return this.isSemanticallyEquivalentToSafeCall || Call.super.isSemanticallyEquivalentToSafeCall();
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitReceiver;
        }

        @Override
        @Nullable
        public ReceiverValue getDispatchReceiver() {
            return null;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            return this.valueArguments;
        }

        @Override
        @NotNull
        public KtElement getCallElement() {
            return this.callElement;
        }

        @Override
        public KtValueArgumentList getValueArgumentList() {
            return null;
        }

        @NotNull
        public List<LambdaArgument> getFunctionLiteralArguments() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<KtTypeProjection> getTypeArguments() {
            return Collections.emptyList();
        }

        @Override
        public KtTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            return this.callType;
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final KtExpression expression;
        private final KtElement reportErrorsOn;
        private final boolean isExternal;

        private ExpressionValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn, boolean isExternal) {
            this.expression = expression2;
            this.reportErrorsOn = expression2 == null ? reportErrorsOn : expression2;
            this.isExternal = isExternal;
        }

        @Override
        public boolean isExternal() {
            return this.isExternal;
        }

        @Override
        public KtExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public ValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public KtElement asElement() {
            return this.reportErrorsOn;
        }

        @Override
        public LeafPsiElement getSpreadElement() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionValueArgument argument = (ExpressionValueArgument)o;
            return !(this.expression != null ? !this.expression.equals(argument.expression) : argument.expression != null);
        }

        public int hashCode() {
            return this.expression != null ? this.expression.hashCode() : 0;
        }
    }
}

