/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.core.DefaultParserCallback;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigNavigationActionsFactory
extends DefaultParserCallback {
    private static final Key<EditorConfigNavigationActionsFactory> NAVIGATION_FACTORY_KEY = Key.create((String)"editor.config.navigation.factory");
    private final List<String> myEditorConfigFilePaths = ContainerUtil.newArrayList();

    private EditorConfigNavigationActionsFactory() {
    }

    @NotNull
    public List<AnAction> getNavigationActions(@NotNull Project project) {
        if (project == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(0);
        }
        ArrayList actions = ContainerUtil.newArrayList();
        List<VirtualFile> editorConfigFiles = this.getEditorConfigFiles();
        for (VirtualFile editorConfigFile : this.getEditorConfigFiles()) {
            actions.add(DumbAwareAction.create((String)EditorConfigNavigationActionsFactory.getActionName(editorConfigFile, editorConfigFiles.size() > 1), event -> OpenFileAction.openFile((VirtualFile)editorConfigFile, (Project)project)));
        }
        List<Object> list = actions.size() <= 1 ? actions : Collections.singletonList(new NavigationActionGroup(actions.toArray(AnAction.EMPTY_ARRAY)));
        if (list == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean processEditorConfig(File configFile) {
        this.myEditorConfigFilePaths.add(configFile.getPath());
        return true;
    }

    public boolean processFile(File file) {
        this.myEditorConfigFilePaths.clear();
        return true;
    }

    @NotNull
    private static String getActionName(@NotNull VirtualFile file, boolean withFolder) {
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(2);
        }
        String fileName = EditorConfigPresentationUtil.getFileName(file, withFolder);
        String string = !withFolder ? EditorConfigBundle.message("action.open.file", fileName) : fileName;
        if (string == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<VirtualFile> getEditorConfigFiles() {
        ArrayList files = ContainerUtil.newArrayList();
        for (String path : this.myEditorConfigFilePaths) {
            VirtualFile file = VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)true);
            if (file == null) continue;
            files.add(file);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static EditorConfigNavigationActionsFactory getInstance(@NotNull VirtualFile file) {
        EditorConfigNavigationActionsFactory instance;
        if (file == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(5);
        }
        if ((instance = (EditorConfigNavigationActionsFactory)((Object)file.getUserData(NAVIGATION_FACTORY_KEY))) == null) {
            instance = new EditorConfigNavigationActionsFactory();
            file.putUserData(NAVIGATION_FACTORY_KEY, (Object)instance);
        }
        EditorConfigNavigationActionsFactory editorConfigNavigationActionsFactory = instance;
        if (editorConfigNavigationActionsFactory == null) {
            EditorConfigNavigationActionsFactory.$$$reportNull$$$0(6);
        }
        return editorConfigNavigationActionsFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorConfigFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationActions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigationActionGroup
    extends ActionGroup {
        private final AnAction[] myChildActions;

        private NavigationActionGroup(AnAction[] actions) {
            super("Open EditorConfig File", true);
            this.myChildActions = actions;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildActions == null) {
                NavigationActionGroup.$$$reportNull$$$0(0);
            }
            return this.myChildActions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/configmanagement/EditorConfigNavigationActionsFactory$NavigationActionGroup", "getChildren"));
        }
    }
}

