/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.List;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.EditorConfigStatusUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        if (settings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(1);
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                List<EditorConfig.OutPair> outPairs = EditorConfigCodeStyleSettingsModifier.getEditorConfigOptions(project, psiFile, (ParserCallback)EditorConfigNavigationActionsFactory.getInstance(file));
                if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(outPairs, psiFile, (CodeStyleSettings)settings)) {
                    settings.addDependencies(EditorConfigNavigationActionsFactory.getInstance(file).getEditorConfigFiles());
                    return true;
                }
            }
            catch (EditorConfigException editorConfigException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(2);
        }
        return new EditorConfigStatusUIContributor(transientSettings){

            @NotNull
            public String getStatusText(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("EditorConfig" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "EditorConfig";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStatusText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getStatusText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean applyCodeStyleSettings(@NotNull List<EditorConfig.OutPair> editorConfigOptions, @NotNull PsiFile file, @NotNull CodeStyleSettings settings) {
        LanguageCodeStyleSettingsProvider provider;
        if (editorConfigOptions == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(3);
        }
        if (file == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(5);
        }
        if ((provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)file.getLanguage())) != null) {
            AbstractCodeStylePropertyMapper mapper = provider.getPropertyMapper(settings);
            boolean isModified = EditorConfigCodeStyleSettingsModifier.processOptions(editorConfigOptions, mapper, false);
            isModified = EditorConfigCodeStyleSettingsModifier.processOptions(editorConfigOptions, mapper, true) || isModified;
            return isModified;
        }
        return false;
    }

    private static boolean processOptions(@NotNull List<EditorConfig.OutPair> editorConfigOptions, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific) {
        if (editorConfigOptions == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(6);
        }
        if (mapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(7);
        }
        String ideLangPrefix = EditorConfigIntellijNameUtil.getIdeLangPrefix(mapper);
        boolean isModified = false;
        for (EditorConfig.OutPair option : editorConfigOptions) {
            CodeStylePropertyAccessor accessor;
            String intellijName;
            if (languageSpecific && !option.getKey().startsWith(ideLangPrefix) || (intellijName = EditorConfigIntellijNameUtil.toIntellijName(mapper, option.getKey())) == null || (accessor = mapper.getAccessor(intellijName)) == null) continue;
            isModified |= accessor.setFromString(option.getVal());
        }
        return isModified;
    }

    private static List<EditorConfig.OutPair> getEditorConfigOptions(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ParserCallback callback) throws EditorConfigException {
        if (project == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(10);
        }
        String filePath = Utils.getFilePath(project, psiFile.getVirtualFile());
        Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
        return new EditorConfig().getProperties(filePath, rootDirs, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatusBarUiContributor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCodeStyleSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processOptions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorConfigOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

