/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/editorconfig/core/EditorConfigAutomatonBuilder;", "", "()V", "KEY_EDITORCONFIG_ELEMENT_AUTOMATON", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Ldk/brics/automaton/Automaton;", "KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON", "Ldk/brics/automaton/RunAutomaton;", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "getCachedHeaderAutomaton", "header", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "getCachedHeaderRunAutomaton", "getCachedPatternAutomaton", "pattern", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "sanitizeGlob", "", "text", "path", "intellij.editorconfig"})
public final class EditorConfigAutomatonBuilder {
    private static final Key<CachedValue<RunAutomaton>> KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON;
    private static final Key<CachedValue<Automaton>> KEY_EDITORCONFIG_ELEMENT_AUTOMATON;
    private static final Logger Log;
    public static final EditorConfigAutomatonBuilder INSTANCE;

    @NotNull
    public final RunAutomaton getCachedHeaderRunAutomaton(@NotNull EditorConfigHeader header) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        Object object = CachedValuesManager.getCachedValue((PsiElement)header, KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON, (CachedValueProvider)new CachedValueProvider<T>(header){
            final /* synthetic */ EditorConfigHeader $header;

            @NotNull
            public final CachedValueProvider.Result<RunAutomaton> compute() {
                RunAutomaton runAutomaton = new RunAutomaton(EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(this.$header));
                return CachedValueProvider.Result.create((Object)runAutomaton, (Object[])new Object[]{this.$header});
            }
            {
                this.$header = editorConfigHeader;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getC\u2026nAutomaton, header)\n    }");
        return (RunAutomaton)object;
    }

    @NotNull
    public final Automaton getCachedHeaderAutomaton(@NotNull EditorConfigHeader header) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        Object object = CachedValuesManager.getCachedValue((PsiElement)header, KEY_EDITORCONFIG_ELEMENT_AUTOMATON, (CachedValueProvider)new CachedValueProvider<T>(header){
            final /* synthetic */ EditorConfigHeader $header;

            @NotNull
            public final CachedValueProvider.Result<Automaton> compute() {
                String text = this.$header.getText();
                EditorConfigAutomatonBuilder.access$getLog$p(EditorConfigAutomatonBuilder.INSTANCE).assertTrue(this.$header.isValidGlob(), (Object)("builder was given invalid header: " + this.$header.getText()));
                EditorConfigAutomatonBuilder.access$getLog$p(EditorConfigAutomatonBuilder.INSTANCE).assertTrue(text.length() >= 3, (Object)("builder was given a header of insufficient length: " + this.$header.getText()));
                String string = text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                String string2 = string;
                int n = 1;
                int n2 = text.length() - 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String internalText = string4;
                String path = EditorConfigPresentationUtil.path(this.$header);
                Automaton automaton = new RegExp(EditorConfigAutomatonBuilder.INSTANCE.sanitizeGlob(internalText, path)).toAutomaton();
                return CachedValueProvider.Result.create((Object)automaton, (Object[])new Object[]{this.$header});
            }
            {
                this.$header = editorConfigHeader;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getC\u2026(automaton, header)\n    }");
        return (Automaton)object;
    }

    @NotNull
    public final Automaton getCachedPatternAutomaton(@NotNull EditorConfigPattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Object object = CachedValuesManager.getCachedValue((PsiElement)pattern, KEY_EDITORCONFIG_ELEMENT_AUTOMATON, (CachedValueProvider)new CachedValueProvider<T>(pattern){
            final /* synthetic */ EditorConfigPattern $pattern;

            @NotNull
            public final CachedValueProvider.Result<Automaton> compute() {
                String text = this.$pattern.getText();
                EditorConfigHeader header = this.$pattern.getHeader();
                EditorConfigAutomatonBuilder.access$getLog$p(EditorConfigAutomatonBuilder.INSTANCE).assertTrue(header.isValidGlob(), (Object)("builder was given a pattern in invalid header: " + text + " in " + header.getText()));
                EditorConfigAutomatonBuilder.access$getLog$p(EditorConfigAutomatonBuilder.INSTANCE).assertTrue(header.getTextLength() >= 3, (Object)("builder was given a pattern in header of insufficient length: " + text + " in " + header.getText()));
                String path = EditorConfigPresentationUtil.path(this.$pattern);
                String string = text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                String glob = EditorConfigAutomatonBuilder.INSTANCE.sanitizeGlob(string, path);
                Automaton automaton = new RegExp(glob).toAutomaton();
                return CachedValueProvider.Result.create((Object)automaton, (Object[])new Object[]{this.$pattern});
            }
            {
                this.$pattern = editorConfigPattern;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getC\u2026automaton, pattern)\n    }");
        return (Automaton)object;
    }

    @NotNull
    public final String sanitizeGlob(@NotNull String text, @NotNull String path) {
        Object object;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String source = StringsKt.replace$default((String)text, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        source = StringsKt.replace$default((String)source, (String)"\\\\#", (String)"#", (boolean)false, (int)4, null);
        source = StringsKt.replace$default((String)source, (String)"\\\\;", (String)";", (boolean)false, (int)4, null);
        int separator = StringsKt.indexOf$default((CharSequence)source, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separator >= 0) {
            Object object2;
            CharSequence charSequence2 = new StringBuilder().append(StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)).append("/");
            if (separator == 0) {
                String string = source;
                int n = 1;
                charSequence = charSequence2;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                object = string3;
                charSequence2 = charSequence;
                object2 = object;
            } else {
                object2 = source;
            }
            source = charSequence2.append((String)object2).toString();
        } else {
            source = "**/" + source;
        }
        charSequence = source;
        object = new ArrayList();
        String string = EditorConfig.convertGlobToRegEx((String)charSequence, object);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EditorConfig.convertGlob\u2026Ex(source, arrayListOf())");
        source = string;
        return StringsKt.replace$default((String)source, (String)"(?:", (String)"(", (boolean)false, (int)4, null);
    }

    private EditorConfigAutomatonBuilder() {
    }

    static {
        EditorConfigAutomatonBuilder editorConfigAutomatonBuilder;
        INSTANCE = editorConfigAutomatonBuilder = new EditorConfigAutomatonBuilder();
        KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON");
        KEY_EDITORCONFIG_ELEMENT_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_AUTOMATON");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigAutomatonBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Log = logger;
    }

    public static final /* synthetic */ Logger access$getLog$p(EditorConfigAutomatonBuilder $this) {
        EditorConfigAutomatonBuilder editorConfigAutomatonBuilder = $this;
        return Log;
    }
}

