/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.language.codeinsight.quickfixes.EditorConfigSanitizeCharClassQuickFix;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigCharClass;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigSanitizeCharClassQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "distinctLetters", "", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "letters", "getFamilyName", "", "intellij.editorconfig"})
public final class EditorConfigSanitizeCharClassQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.charclass.sanitize.description");
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void $receiver$iv;
        StringBuilder initial$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (!(psiElement instanceof EditorConfigCharClass)) {
            psiElement = null;
        }
        EditorConfigCharClass editorConfigCharClass = (EditorConfigCharClass)psiElement;
        if (editorConfigCharClass == null) {
            return;
        }
        EditorConfigCharClass charClass = editorConfigCharClass;
        List<EditorConfigCharClassLetter> list = charClass.getCharClassLetterList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"charClass.charClassLetterList");
        EditorConfigCharClassLetter first = (EditorConfigCharClassLetter)CollectionsKt.first(list);
        List<EditorConfigCharClassLetter> list2 = charClass.getCharClassLetterList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"charClass.charClassLetterList");
        EditorConfigCharClassLetter last = (EditorConfigCharClassLetter)CollectionsKt.last(list2);
        String string = charClass.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"charClass.text");
        String string2 = string;
        int n = 0;
        EditorConfigCharClassLetter editorConfigCharClassLetter = first;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigCharClassLetter, (String)"first");
        int n2 = editorConfigCharClassLetter.getStartOffsetInParent();
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String prefix = string4;
        String string5 = charClass.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"charClass.text");
        String string6 = string5;
        EditorConfigCharClassLetter editorConfigCharClassLetter2 = last;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigCharClassLetter2, (String)"last");
        n2 = editorConfigCharClassLetter2.getStartOffsetInParent() + last.getTextLength();
        String string7 = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        String postfix = string8;
        List<EditorConfigCharClassLetter> list3 = charClass.getCharClassLetterList();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"charClass.charClassLetterList");
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.distinctLetters(list3)), (Function1)applyFix.newSource.1.INSTANCE);
        StringBuilder accumulator$iv = initial$iv = new StringBuilder(prefix);
        for (Object element$iv : $receiver$iv) {
            void p2;
            String string9 = (String)element$iv;
            StringBuilder p1 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1.append((String)p2);
        }
        String string10 = accumulator$iv.append(postfix).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"distinctLetters(charClas\u2026ostfix)\n      .toString()");
        String newSource2 = string10;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigCharClass newCharClass = factory.createCharClass(newSource2);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(charClass, newCharClass){
            final /* synthetic */ EditorConfigCharClass $charClass;
            final /* synthetic */ EditorConfigCharClass $newCharClass;

            public final void run() {
                this.$charClass.replace(this.$newCharClass);
            }
            {
                this.$charClass = editorConfigCharClass;
                this.$newCharClass = editorConfigCharClass2;
            }
        });
    }

    private final List<EditorConfigCharClassLetter> distinctLetters(List<? extends EditorConfigCharClassLetter> letters) {
        List result2 = new ArrayList();
        Iterable $receiver$iv = letters;
        for (Object element$iv : $receiver$iv) {
            boolean bl;
            EditorConfigCharClassLetter it;
            block4: {
                it = (EditorConfigCharClassLetter)element$iv;
                boolean bl2 = false;
                Iterable $receiver$iv2 = result2;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $receiver$iv2) {
                        PsiElement p1 = (PsiElement)element$iv2;
                        boolean bl3 = false;
                        if (!it.textMatches(p1)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            result2.add(it);
        }
        return result2;
    }
}

