/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "className", "", "smartPsiElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getClassName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "idea-maven"})
public final class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    @NotNull
    private final String className;
    private final SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer;

    @NotNull
    public String getText() {
        return "Add Maven dependency...";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement = this.smartPsiElementPointer.getElement();
        KtSimpleNameExpression it = (KtSimpleNameExpression)psiElement;
        return it != null && it.isValid() && file != null && MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file)) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        PsiFile psiFile = file.getOriginalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file.originalFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file));
        if (mavenProject == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProject, (String)"MavenDomUtil.findContainingProject(file) ?: return");
        MavenProject mavenProject2 = mavenProject;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(mavenProject2.getFile());
        if (!(psiFile2 instanceof XmlFile)) {
            psiFile2 = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile2;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        List list = MavenArtifactSearchDialog.searchForClass((Project)project, (String)this.className);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"MavenArtifactSearchDialo\u2026Class(project, className)");
        List ids = list;
        if (ids.isEmpty()) {
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(project, virtualFile2, xmlFile2, ids){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ XmlFile $xmlFile;
            final /* synthetic */ List $ids;

            @Nullable
            public final Unit invoke() {
                Unit unit;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                boolean isTestSource = FileIndexUtilsKt.isInTestSourceContentKotlinAware((FileIndex)((FileIndex)projectFileIndex), (VirtualFile)this.$virtualFile);
                MavenArtifactScope scope = isTestSource ? MavenArtifactScope.TEST : null;
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.$xmlFile);
                if (pomFile != null) {
                    PomFile pomFile2;
                    PomFile pom = pomFile2 = pomFile;
                    Iterable $receiver$iv = this.$ids;
                    for (T element$iv : $receiver$iv) {
                        MavenId it;
                        MavenId mavenId = it = (MavenId)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mavenId, (String)"it");
                        PomFile.addDependency$default(pom, mavenId, scope, null, false, null, 28, null);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.$project = project;
                this.$virtualFile = virtualFile;
                this.$xmlFile = xmlFile;
                this.$ids = list;
                super(0);
            }
        }));
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public AddMavenDependencyQuickFix(@NotNull String className, @NotNull SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull(smartPsiElementPointer, (String)"smartPsiElementPointer");
        this.className = className;
        this.smartPsiElementPointer = smartPsiElementPointer;
    }
}

