/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.application.options.GeneralCodeStyleOptionsProviderEP;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesList;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private static final String SYSTEM_DEPENDANT_STRING = ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    private static final String UNIX_STRING = ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    private static final String WINDOWS_STRING = ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    private static final String MACINTOSH_STRING = ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    private final List<GeneralCodeStyleOptionsProvider> myAdditionalOptions;
    private IntegerField myRightMarginField;
    private JComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private JBCheckBox myCbWrapWhenTypingReachesRightMargin;
    private JCheckBox myEnableFormatterTags;
    private JTextField myFormatterOnTagField;
    private JTextField myFormatterOffTagField;
    private JCheckBox myAcceptRegularExpressionsCheckBox;
    private JBLabel myFormatterOffLabel;
    private JBLabel myFormatterOnLabel;
    private JPanel myMarkerOptionsPanel;
    private JPanel myAdditionalSettingsPanel;
    private JCheckBox myAutodetectIndentsBox;
    private JPanel myIndentsDetectionPanel;
    private CommaSeparatedIntegersField myVisualGuides;
    private JBLabel myVisualGuidesHint;
    private JBLabel myLineSeparatorHint;
    private JBLabel myVisualGuidesLabel;
    private ExcludedFilesList myExcludedFilesList;
    private JPanel myExcludedFilesPanel;
    private JPanel myToolbarPanel;
    private JBTabbedPane myTabbedPane;
    private final JScrollPane myScrollPane;
    private static int ourSelectedTabIndex = -1;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.myLineSeparatorCombo.addItem(SYSTEM_DEPENDANT_STRING);
        this.myLineSeparatorCombo.addItem(UNIX_STRING);
        this.myLineSeparatorCombo.addItem(WINDOWS_STRING);
        this.myLineSeparatorCombo.addItem(MACINTOSH_STRING);
        this.addPanelToWatch(this.myPanel);
        this.myRightMarginField.setDefaultValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myEnableFormatterTags.addActionListener(__ -> {
            boolean tagsEnabled = this.myEnableFormatterTags.isSelected();
            this.setFormatterTagControlsEnabled(tagsEnabled);
        });
        this.myIndentsDetectionPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.indents.detection", (Object[])new Object[0])));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myScrollPane = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScrollPane.setViewport((JViewport)((Object)new GradientViewport(this.myPanel, (Insets)JBUI.insetsTop((int)5), true)));
        this.myAdditionalSettingsPanel.setLayout((LayoutManager)new VerticalFlowLayout(true, true));
        this.myAdditionalSettingsPanel.removeAll();
        this.myAdditionalOptions = ConfigurableWrapper.createConfigurables(GeneralCodeStyleOptionsProviderEP.EP_NAME);
        for (GeneralCodeStyleOptionsProvider provider : this.myAdditionalOptions) {
            JComponent generalSettingsComponent = provider.createComponent();
            if (generalSettingsComponent == null) continue;
            this.myAdditionalSettingsPanel.add(generalSettingsComponent);
        }
        this.myVisualGuidesLabel.setText(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]) + ":");
        this.myVisualGuidesHint.setForeground((Color)JBColor.GRAY);
        this.myVisualGuidesHint.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myLineSeparatorHint.setForeground((Color)JBColor.GRAY);
        this.myLineSeparatorHint.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myExcludedFilesList.initModel();
        this.myToolbarPanel.add(this.myExcludedFilesList.getDecorator().createPanel());
        this.myExcludedFilesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.excluded.files", (Object[])new Object[0])));
        if (ourSelectedTabIndex >= 0) {
            this.myTabbedPane.setSelectedIndex(ourSelectedTabIndex);
        }
        this.myTabbedPane.addChangeListener(__ -> {
            ourSelectedTabIndex = this.myTabbedPane.getSelectedIndex();
        });
    }

    @Override
    protected int getRightMargin() {
        return this.myRightMarginField.getValue();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        if (languageFileType == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        this.myVisualGuides.validateContent();
        this.myRightMarginField.validateContent();
        settings.setDefaultSoftMargins(this.myVisualGuides.getValue());
        this.myExcludedFilesList.apply(settings);
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.setDefaultRightMargin(this.getRightMargin());
        settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myCbWrapWhenTypingReachesRightMargin.isSelected();
        settings.FORMATTER_TAGS_ENABLED = this.myEnableFormatterTags.isSelected();
        settings.FORMATTER_TAGS_ACCEPT_REGEXP = this.myAcceptRegularExpressionsCheckBox.isSelected();
        settings.FORMATTER_OFF_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG);
        settings.setFormatterOffPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG));
        settings.FORMATTER_ON_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOnTagField, settings.FORMATTER_ON_TAG);
        settings.setFormatterOnPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOnTagField, settings.FORMATTER_ON_TAG));
        settings.AUTODETECT_INDENTS = this.myAutodetectIndentsBox.isSelected();
        for (GeneralCodeStyleOptionsProvider option2 : this.myAdditionalOptions) {
            option2.apply(settings);
        }
    }

    private void createUIComponents() {
        this.myRightMarginField = new IntegerField(ApplicationBundle.message((String)"editbox.right.margin.columns", (Object[])new Object[0]), 0, 1000);
        this.myVisualGuides = new CommaSeparatedIntegersField(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]), 0, 1000, "Optional");
        this.myExcludedFilesList = new ExcludedFilesList();
    }

    @Nullable
    private static Pattern compilePattern(CodeStyleSettings settings, JTextField field, String patternText) {
        try {
            return Pattern.compile(patternText);
        }
        catch (PatternSyntaxException pse) {
            settings.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            GeneralCodeStylePanel.showError(field, ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.invalid.regexp", (Object[])new Object[0]));
            return null;
        }
    }

    private static String getTagText(JTextField field, String defaultValue) {
        String fieldText = field.getText();
        if (StringUtil.isEmpty((String)field.getText())) {
            return defaultValue;
        }
        return fieldText;
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (UNIX_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (MACINTOSH_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (WINDOWS_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!this.myVisualGuides.getValue().equals(settings.getDefaultSoftMargins())) {
            return true;
        }
        if (this.myExcludedFilesList.isModified(settings)) {
            return true;
        }
        if (!Comparing.equal((String)this.getSelectedLineSeparator(), (String)settings.LINE_SEPARATOR)) {
            return true;
        }
        if (settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ^ this.myCbWrapWhenTypingReachesRightMargin.isSelected()) {
            return true;
        }
        if (this.getRightMargin() != settings.getDefaultRightMargin()) {
            return true;
        }
        if (this.myEnableFormatterTags.isSelected() ? !settings.FORMATTER_TAGS_ENABLED || settings.FORMATTER_TAGS_ACCEPT_REGEXP != this.myAcceptRegularExpressionsCheckBox.isSelected() || !StringUtil.equals((CharSequence)this.myFormatterOffTagField.getText(), (CharSequence)settings.FORMATTER_OFF_TAG) || !StringUtil.equals((CharSequence)this.myFormatterOnTagField.getText(), (CharSequence)settings.FORMATTER_ON_TAG) : settings.FORMATTER_TAGS_ENABLED) {
            return true;
        }
        for (GeneralCodeStyleOptionsProvider option2 : this.myAdditionalOptions) {
            if (!option2.isModified(settings)) continue;
            return true;
        }
        return settings.AUTODETECT_INDENTS != this.myAutodetectIndentsBox.isSelected();
    }

    @Override
    public JComponent getPanel() {
        return this.myScrollPane;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myVisualGuides.setValue(settings.getDefaultSoftMargins());
        this.myExcludedFilesList.reset(settings);
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(UNIX_STRING);
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(WINDOWS_STRING);
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(MACINTOSH_STRING);
        } else {
            this.myLineSeparatorCombo.setSelectedItem(SYSTEM_DEPENDANT_STRING);
        }
        this.myRightMarginField.setValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myCbWrapWhenTypingReachesRightMargin.setSelected(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myAcceptRegularExpressionsCheckBox.setSelected(settings.FORMATTER_TAGS_ACCEPT_REGEXP);
        this.myEnableFormatterTags.setSelected(settings.FORMATTER_TAGS_ENABLED);
        this.myFormatterOnTagField.setText(settings.FORMATTER_ON_TAG);
        this.myFormatterOffTagField.setText(settings.FORMATTER_OFF_TAG);
        this.setFormatterTagControlsEnabled(settings.FORMATTER_TAGS_ENABLED);
        this.myAutodetectIndentsBox.setSelected(settings.AUTODETECT_INDENTS);
        for (GeneralCodeStyleOptionsProvider option2 : this.myAdditionalOptions) {
            option2.reset(settings);
        }
    }

    private void setFormatterTagControlsEnabled(boolean isEnabled) {
        this.myFormatterOffTagField.setEnabled(isEnabled);
        this.myFormatterOnTagField.setEnabled(isEnabled);
        this.myAcceptRegularExpressionsCheckBox.setEnabled(isEnabled);
        this.myFormatterOffLabel.setEnabled(isEnabled);
        this.myFormatterOnLabel.setEnabled(isEnabled);
        this.myMarkerOptionsPanel.setEnabled(isEnabled);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme2, null);
    }

    @Override
    public Language getDefaultLanguage() {
        return null;
    }

    private static void showError(JTextField field, String message) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null);
        balloonBuilder.setFadeoutTime(1500L);
        Balloon balloon = balloonBuilder.createBalloon();
        Rectangle rect = field.getBounds();
        Point p = new Point(0, rect.height);
        RelativePoint point = new RelativePoint((Component)field, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    @Override
    public void setModel(@NotNull CodeStyleSchemesModel model) {
        if (model == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(1);
        }
        super.setModel(model);
        this.myExcludedFilesList.setSchemesModel(model);
    }

    @Override
    public void dispose() {
        for (GeneralCodeStyleOptionsProvider option2 : this.myAdditionalOptions) {
            option2.disposeUIResources();
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/GeneralCodeStylePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/GeneralCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JBLabel jBLabel;
        JTextField jTextField2;
        JBLabel jBLabel2;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JPanel jPanel4;
        JCheckBox jCheckBox3;
        JPanel jPanel5;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel5;
        JComboBox jComboBox;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel6;
        this.createUIComponents();
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, "West");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel8.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 7, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("General", null, jPanel9, null);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.line.separator.for.new.files"));
        jPanel9.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLineSeparatorCombo = jComboBox = new JComboBox();
        jPanel9.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myLineSeparatorHint = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.lineseparator.for.new.files.hint"));
        jPanel9.add((Component)jBLabel5, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel9.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        IntegerField integerField = this.myRightMarginField;
        jPanel9.add((Component)integerField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCbWrapWhenTypingReachesRightMargin = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHideActionText(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("wrapping.wrap.on.typing"));
        jPanel9.add((Component)jBCheckBox, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        CommaSeparatedIntegersField commaSeparatedIntegersField = this.myVisualGuides;
        jPanel9.add((Component)commaSeparatedIntegersField, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myVisualGuidesLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.visual.guides"));
        jPanel9.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVisualGuidesHint = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.visual.guides.hint"));
        jPanel9.add((Component)jBLabel3, new GridConstraints(4, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("margin.columns"));
        jPanel9.add((Component)jBLabel6, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("margin.columns"));
        jPanel9.add((Component)jBLabel7, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIndentsDetectionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel5, new GridConstraints(5, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.indents.detection"), (int)0, (int)0, null, null));
        this.myAutodetectIndentsBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.autodetect.indents"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel4, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Formatter Control", null, jPanel10, null);
        this.myEnableFormatterTags = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.enable.formatter.tags"));
        jPanel10.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMarkerOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFormatterOffLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.off.tag"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myFormatterOffTagField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFormatterOnLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.on.tag"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myFormatterOnTagField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAcceptRegularExpressionsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.marker.regexp"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myExcludedFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Do not format:", (int)0, (int)0, null, null));
        ExcludedFilesList excludedFilesList = this.myExcludedFilesList;
        DefaultListModel defaultListModel = new DefaultListModel();
        ((JList)((Object)excludedFilesList)).setModel(defaultListModel);
        jPanel2.add((Component)((Object)excludedFilesList), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, "Center");
        jLabel.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

