/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Locale;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinTrayUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.SwitchBootJdkAction");
    @NotNull
    private static final String productJdkConfigFileName = BinTrayUtil.getExecutable() + (SystemInfo.isWindows ? (SystemInfo.is64Bit ? "64.exe.jdk" : ".exe.jdk") : ".jdk");
    @Nullable
    private static final String pathsSelector = PathManager.getPathsSelector();
    @NotNull
    private static final File productJdkConfigDir = new File(pathsSelector != null ? PathManager.getDefaultConfigPathFor((String)pathsSelector) : PathManager.getConfigPath());
    @NotNull
    private static final File productJdkConfigFile = new File(productJdkConfigDir, productJdkConfigFileName);

    private static String getExecutable() {
        String executable = System.getProperty("idea.executable");
        return executable != null ? executable : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
    }

    @NotNull
    public static File getJdkConfigFilePath() {
        if (!productJdkConfigDir.exists()) {
            block6: {
                File file2;
                block7: {
                    if (productJdkConfigDir.mkdirs()) break block6;
                    LOG.error("Could not create " + productJdkConfigDir + " productJdkConfigDir");
                    file2 = null;
                    if (null != null) break block7;
                    BinTrayUtil.$$$reportNull$$$0(0);
                }
                return file2;
            }
            try {
                if (!productJdkConfigFile.exists() && !productJdkConfigFile.createNewFile()) {
                    LOG.error("Could not create " + productJdkConfigFileName + " productJdkConfigFile");
                }
            }
            catch (IOException var1) {
                LOG.error((Throwable)var1);
            }
        }
        File file3 = productJdkConfigFile;
        if (file3 == null) {
            BinTrayUtil.$$$reportNull$$$0(1);
        }
        return file3;
    }

    @NotNull
    public static String archveToDirectoryName(String archiveFileName) {
        String string = archiveFileName.substring(0, archiveFileName.lastIndexOf(".tar.gz"));
        if (string == null) {
            BinTrayUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static File downloadPath() {
        File file2 = new File(PathManager.getPluginTempPath(), "jdk_archives");
        if (file2 == null) {
            BinTrayUtil.$$$reportNull$$$0(3);
        }
        return file2;
    }

    public static void updateJdkConfigFileAndRestart(File directoryToExtractFile) {
        File jdkConfigFilePath = BinTrayUtil.getJdkConfigFilePath();
        if (jdkConfigFilePath != null) {
            try (FileWriter fooWriter = new FileWriter(jdkConfigFilePath, false);){
                File jdkPath = SystemInfo.isMac ? new File(directoryToExtractFile, "jdk") : directoryToExtractFile;
                String jdk = jdkPath.getPath();
                fooWriter.write(jdk);
            }
            catch (IOException var17) {
                var17.printStackTrace();
            }
            ApplicationManagerEx.getApplicationEx().restart();
        }
    }

    public static File getJdkStoragePathFile() {
        return new File(PathManager.getConfigPath() + File.separator + "jdks" + File.separator);
    }

    public static boolean isInstalled(String selectedItem) {
        File jdkBundleDirFile = new File(BinTrayUtil.getJdkStoragePathFile(), BinTrayUtil.archveToDirectoryName(selectedItem));
        File bundlePathFromItem = SystemInfo.isMac ? new File(jdkBundleDirFile, "jdk") : jdkBundleDirFile;
        return bundlePathFromItem.exists() && BinTrayUtil.isActiveBundle(selectedItem);
    }

    public static boolean isActiveBundle(String selectedItem) {
        File bundlePathFromItem;
        File jdkConfigFilePath = BinTrayUtil.getJdkConfigFilePath();
        File jdkBundleDirFile = new File(BinTrayUtil.getJdkStoragePathFile(), BinTrayUtil.archveToDirectoryName(selectedItem));
        File file2 = bundlePathFromItem = SystemInfo.isMac ? new File(jdkBundleDirFile, "jdk") : jdkBundleDirFile;
        if (jdkConfigFilePath != null && jdkConfigFilePath.exists()) {
            try {
                boolean var6;
                try (Stream<String> lines2 = Files.lines(jdkConfigFilePath.toPath(), Charset.defaultCharset());){
                    var6 = lines2 != null && lines2.anyMatch(pathToBundle -> FileUtil.filesEqual((File)bundlePathFromItem, (File)new File((String)pathToBundle)));
                }
                return var6;
            }
            catch (IOException ioe) {
                LOG.warn((Throwable)ioe);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/bootRuntime/BinTrayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkConfigFilePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "archveToDirectoryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

