/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int FRAMES_COUNT = 8;
    private static final int MOVIE_TIME = 1200;
    private static final int FRAME_TIME = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long myLastInvocationTime = -1L;
    private Alarm myAlarm;
    private final List<ExecutionNode> myNodes = new SmartList();
    private BuildTreeConsoleView myTreeView;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView treeConsoleView) {
        Disposer.register((Disposable)treeConsoleView, (Disposable)this);
        this.myAlarm = new Alarm();
        this.myTreeView = treeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long time;
        if (!this.myNodes.isEmpty() && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 150L) {
            this.repaintTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void addNode(@Nullable ExecutionNode currentNode) {
        this.myNodes.add(currentNode);
    }

    public void startMovie() {
        this.scheduleRepaint();
    }

    public void stopMovie() {
        this.repaintTree();
        for (ExecutionNode node : this.myNodes) {
            node.setIconProvider(() -> AllIcons.RunConfigurations.TestIgnored);
            node.setEndTime(System.currentTimeMillis());
        }
        this.myNodes.clear();
        this.cancelAlarm();
    }

    public void dispose() {
        this.myTreeView = null;
        this.myNodes.clear();
        this.cancelAlarm();
    }

    private void cancelAlarm() {
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm = null;
        }
    }

    private void repaintTree() {
        if (this.myTreeView == null || this.myTreeView.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.myNodes.iterator();
        while (iterator.hasNext()) {
            ExecutionNode node = iterator.next();
            this.myTreeView.scheduleUpdate(node);
            if (node.isRunning()) continue;
            iterator.remove();
        }
    }

    private void scheduleRepaint() {
        if (this.myAlarm == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.Step_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.Step_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.Step_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.Step_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.Step_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.Step_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.Step_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.Step_8;
    }
}

