/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionInitializationUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCompletionHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CodeCompletionHandlerBase");
    private static final Key<Boolean> CARET_PROCESSED = Key.create((String)"CodeCompletionHandlerBase.caretProcessed");
    public static final Key<Boolean> DIRECT_INSERTION = Key.create((String)"CodeCompletionHandlerBase.directInsertion");
    @NotNull
    final CompletionType completionType;
    final boolean invokedExplicitly;
    final boolean synchronous;
    final boolean autopopup;
    private static int ourAutoInsertItemTimeout = 2000;

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(0);
        }
        return CodeCompletionHandlerBase.createHandler(completionType, true, false, true);
    }

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        AnAction codeCompletionAction;
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(1);
        }
        if ((codeCompletionAction = ActionManager.getInstance().getAction("CodeCompletion")) instanceof OverridingAction) {
            codeCompletionAction = ((ActionManagerImpl)ActionManager.getInstance()).getBaseAction((OverridingAction)codeCompletionAction);
        }
        assert (codeCompletionAction instanceof BaseCodeCompletionAction);
        BaseCodeCompletionAction baseCodeCompletionAction = (BaseCodeCompletionAction)codeCompletionAction;
        return baseCodeCompletionAction.createHandler(completionType, invokedExplicitly, autopopup, synchronous);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(2);
        }
        this(completionType, true, false, true);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(3);
        }
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
        if (invokedExplicitly) assert (synchronous);
        if (autopopup) assert (!invokedExplicitly);
    }

    public final void invokeCompletion(Project project, Editor editor) {
        this.invokeCompletion(project, editor, 1);
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(5);
        }
        this.invokeCompletion(project, editor, time, false);
    }

    @Deprecated
    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, boolean restarted) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(7);
        }
        this.invokeCompletion(project, editor, time, hasModifiers);
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(9);
        }
        CodeCompletionHandlerBase.clearCaretMarkers(editor);
        this.invokeCompletion(project, editor, time, hasModifiers, editor.getCaretModel().getPrimaryCaret());
    }

    private void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, @NotNull Caret caret) {
        block13: {
            if (project == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(10);
            }
            if (editor == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(11);
            }
            if (caret == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(12);
            }
            CodeCompletionHandlerBase.markCaretAsProcessed(caret);
            if (this.invokedExplicitly) {
                StatisticsUpdate.applyLastCompletionStatisticsUpdate();
            }
            CodeCompletionHandlerBase.checkNoWriteAccess();
            CompletionAssertions.checkEditorValid(editor);
            int offset = editor.getCaretModel().getOffset();
            if (editor.isViewer() || editor.getDocument().getRangeGuard(offset, offset) != null) {
                editor.getDocument().fireReadOnlyModificationAttempt();
                EditorModificationUtil.checkModificationAllowed((Editor)editor);
                return;
            }
            if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                return;
            }
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            boolean repeated = phase.indicator != null && phase.indicator.isRepeatedInvocation(this.completionType, editor);
            int newTime = phase.newCompletionStarted(time, repeated);
            if (this.invokedExplicitly) {
                time = newTime;
            }
            int invocationCount = time;
            if (CompletionServiceImpl.isPhase(CompletionPhase.InsertedSingleItem.class)) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class);
            if (invocationCount > 1 && this.completionType == CompletionType.BASIC) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
            }
            long startingTime = System.currentTimeMillis();
            Runnable initCmd = () -> {
                boolean hasValidContext;
                CompletionInitializationContextImpl context = (CompletionInitializationContextImpl)((Object)((Object)CodeCompletionHandlerBase.withTimeout(CodeCompletionHandlerBase.calcSyncTimeOut(startingTime), () -> CompletionInitializationUtil.createCompletionInitializationContext(project, editor, caret, invocationCount, this.completionType))));
                boolean bl = hasValidContext = context != null;
                if (!hasValidContext) {
                    PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project);
                    context = new CompletionInitializationContextImpl(editor, caret, psiFile, this.completionType, invocationCount);
                }
                this.doComplete(context, hasModifiers, hasValidContext, startingTime);
            };
            try {
                if (this.autopopup) {
                    CommandProcessor.getInstance().runUndoTransparentAction(initCmd);
                } else {
                    CommandProcessor.getInstance().executeCommand(project, initCmd, null, null, editor.getDocument());
                }
            }
            catch (IndexNotReadyException e) {
                if (!this.invokedExplicitly) break block13;
                DumbService.getInstance((Project)project).showDumbModeNotification("Code completion is not available here while indices are being built");
            }
        }
    }

    private static void checkNoWriteAccess() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Completion should not be invoked inside write action");
        }
    }

    private static boolean shouldSkipAutoPopup(Editor editor, PsiFile psiFile) {
        int offset = editor.getCaretModel().getOffset();
        int psiOffset = Math.max(0, offset - 1);
        PsiElement elementAt = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).findInjectedElementAt(psiFile, psiOffset);
        if (elementAt == null) {
            elementAt = psiFile.findElementAt(psiOffset);
        }
        if (elementAt == null) {
            return true;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)elementAt);
        for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage((Language)language)) {
            ThreeState result2 = confidence.shouldSkipAutopopup(elementAt, psiFile, offset);
            if (result2 == ThreeState.UNSURE) continue;
            LOG.debug(confidence + " has returned shouldSkipAutopopup=" + result2);
            return result2 == ThreeState.YES;
        }
        return false;
    }

    @NotNull
    private LookupImpl obtainLookup(Editor editor, Project project) {
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl existing = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (existing != null && existing.isCompletion()) {
            existing.markReused();
            if (!this.autopopup) {
                existing.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            }
            LookupImpl lookupImpl = existing;
            if (lookupImpl == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(13);
            }
            return lookupImpl;
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        if (editor.isOneLineMode()) {
            lookup.setCancelOnClickOutside(true);
            lookup.setCancelOnOtherWindowOpen(true);
        }
        lookup.setFocusDegree(this.autopopup ? LookupImpl.FocusDegree.UNFOCUSED : LookupImpl.FocusDegree.FOCUSED);
        LookupImpl lookupImpl = lookup;
        if (lookupImpl == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(14);
        }
        return lookupImpl;
    }

    private void doComplete(CompletionInitializationContextImpl initContext, boolean hasModifiers, boolean isValidContext, long startingTime) {
        Editor editor = initContext.getEditor();
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl lookup = this.obtainLookup(editor, initContext.getProject());
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (phase instanceof CompletionPhase.CommittingDocuments) {
            if (phase.indicator != null) {
                phase.indicator.closeAndFinish(false);
            }
            ((CompletionPhase.CommittingDocuments)phase).replaced = true;
        } else {
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        }
        CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor, initContext.getCaret(), initContext.getInvocationCount(), this, initContext.getOffsetMap(), initContext.getHostOffsets(), hasModifiers, lookup);
        CompletionServiceImpl.setCompletionPhase(this.synchronous && isValidContext ? new CompletionPhase.Synchronous(indicator) : new CompletionPhase.BgCalculation(indicator));
        if (!isValidContext) {
            indicator.makeSureLookupIsShown(0);
            return;
        }
        Future<?> future2 = indicator.getCompletionThreading().startThread(indicator, () -> AsyncCompletion.tryReadOrCancel(indicator, () -> {
            CompletionParameters parameters = this.prepareCompletionParameters(initContext, indicator);
            if (parameters != null) {
                indicator.runContributors(initContext);
            }
        }));
        if (!this.synchronous) {
            return;
        }
        int timeout = CodeCompletionHandlerBase.calcSyncTimeOut(startingTime);
        indicator.makeSureLookupIsShown(timeout);
        if (indicator.blockingWaitForFinish(timeout)) {
            CodeCompletionHandlerBase.checkForExceptions(future2);
            try {
                indicator.getLookup().refreshUi(true, false);
                this.completionFinished(indicator, hasModifiers);
            }
            catch (Throwable e) {
                indicator.closeAndFinish(true);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                LOG.error(e);
            }
            return;
        }
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
        indicator.showLookup();
    }

    private static void checkForExceptions(Future<?> future2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                future2.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private CompletionParameters prepareCompletionParameters(CompletionInitializationContext initContext, CompletionProgressIndicator indicator) {
        if (this.autopopup && CodeCompletionHandlerBase.shouldSkipAutoPopup(initContext.getEditor(), initContext.getFile())) {
            return null;
        }
        return CompletionInitializationUtil.prepareCompletionParameters(initContext, indicator);
    }

    private static void checkNotSync(CompletionProgressIndicator indicator, List<LookupElement> allItems) {
        if (CompletionServiceImpl.isPhase(CompletionPhase.Synchronous.class)) {
            LOG.error("sync phase survived: " + allItems + "; indicator=" + CompletionServiceImpl.getCompletionPhase().indicator + "; myIndicator=" + indicator);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
    }

    private AutoCompletionDecision shouldAutoComplete(CompletionProgressIndicator indicator, List<LookupElement> items, CompletionParameters parameters) {
        if (!this.invokedExplicitly) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        LookupElement item = items.get(0);
        if (items.size() == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
            if (!indicator.getLookup().itemMatcher(item).isStartMatch(item)) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(indicator.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.size() == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem((LookupElement)item);
        }
        AutoCompletionContext context = new AutoCompletionContext(parameters, items.toArray(LookupElement.EMPTY_ARRAY), indicator.getOffsetMap(), (Lookup)indicator.getLookup());
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(context);
            if (decision == null) continue;
            return decision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element) {
        return element.getAutoCompletionPolicy();
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
        List<LookupElement> items = indicator.getLookup().getItems();
        CompletionParameters parameters = Objects.requireNonNull(indicator.getParameters());
        if (items.isEmpty()) {
            LookupManager.hideActiveLookup(indicator.getProject());
            Caret nextCaret = CodeCompletionHandlerBase.getNextCaretToProcess(indicator.getEditor());
            if (nextCaret != null) {
                this.invokeCompletion(indicator.getProject(), indicator.getEditor(), parameters.getInvocationCount(), hasModifiers, nextCaret);
            } else {
                indicator.handleEmptyLookup(true);
                CodeCompletionHandlerBase.checkNotSync(indicator, items);
            }
            return;
        }
        LOG.assertTrue(!indicator.isRunning(), (Object)"running");
        LOG.assertTrue(!indicator.isCanceled(), (Object)"canceled");
        try {
            AutoCompletionDecision decision = this.shouldAutoComplete(indicator, items, parameters);
            if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
                indicator.getLookup().setCalculating(false);
                indicator.showLookup();
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(indicator));
            } else if (decision instanceof AutoCompletionDecision.InsertItem) {
                Runnable restorePrefix = CodeCompletionHandlerBase.rememberDocumentState(indicator.getEditor());
                LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
                CommandProcessor.getInstance().executeCommand(indicator.getProject(), () -> {
                    indicator.setMergeCommand();
                    indicator.getLookup().finishLookup('\u0000', item);
                }, "Autocompletion", null);
                if (CompletionService.getCompletionService().getCurrentCompletion() == null && !CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class)) {
                    CompletionServiceImpl.setCompletionPhase(hasModifiers ? new CompletionPhase.InsertedSingleItem(indicator, restorePrefix) : CompletionPhase.NoCompletion);
                }
            } else if (decision == AutoCompletionDecision.CLOSE_LOOKUP) {
                LookupManager.hideActiveLookup(indicator.getProject());
            }
        }
        catch (Throwable e) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            LOG.error(e);
        }
        finally {
            CodeCompletionHandlerBase.checkNotSync(indicator, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
        Runnable runnable2;
        if (item == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(15);
        }
        if (indicator.isAutopopupCompletion()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.basic");
        }
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update = StatisticsUpdate.collectStatisticChanges(item);
            context = item.getUserData(DIRECT_INSERTION) != null ? this.callHandleInsert(indicator, item, completionChar) : CodeCompletionHandlerBase.insertItemHonorBlockSelection(indicator, item, completionChar, update);
            update.trackStatistics(context);
            runnable2 = context == null ? null : context.getLaterRunnable();
        }
        catch (Throwable throwable) {
            CodeCompletionHandlerBase.afterItemInsertion(indicator, context == null ? null : context.getLaterRunnable());
            throw throwable;
        }
        CodeCompletionHandlerBase.afterItemInsertion(indicator, runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompletionElementSelected(CompletionParameters parameters, @NotNull LookupElement item, char completionChar) {
        if (item == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(16);
        }
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update = StatisticsUpdate.collectStatisticChanges(item);
            context = CodeCompletionHandlerBase.insertItemHonorBlockSelection((CompletionProcessEx)parameters.getProcess(), item, completionChar, update);
            update.trackStatistics(context);
        }
        finally {
            if (context != null && context.getLaterRunnable() != null) {
                context.getLaterRunnable().run();
            }
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(CompletionProcessEx indicator, LookupElement item, char completionChar, StatisticsUpdate update) {
        CompletionAssertions.WatchingInsertionContext context;
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = CodeCompletionHandlerBase.calcIdEndOffset(indicator);
        int idEndOffsetDelta = idEndOffset - caretOffset;
        if (editor.getCaretModel().supportsMultipleCarets()) {
            Ref lastContext = Ref.create();
            Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
            boolean wasInjected = hostEditor != editor;
            OffsetsInFile topLevelOffsets = indicator.getHostOffsets();
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                OffsetsInFile targetOffsets = CodeCompletionHandlerBase.findInjectedOffsetsIfAny(caret, wasInjected, topLevelOffsets, hostEditor);
                PsiFile targetFile = targetOffsets.getFile();
                Editor targetEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, targetFile);
                int targetCaretOffset = targetEditor.getCaretModel().getOffset();
                int idEnd = targetCaretOffset + idEndOffsetDelta;
                if (idEnd > targetEditor.getDocument().getTextLength()) {
                    idEnd = targetCaretOffset;
                }
                CompletionAssertions.WatchingInsertionContext currentContext = CodeCompletionHandlerBase.insertItem(indicator.getLookup(), item, completionChar, update, targetEditor, targetFile, targetCaretOffset, idEnd, targetOffsets.getOffsets());
                lastContext.set((Object)currentContext);
            });
            context = (CompletionAssertions.WatchingInsertionContext)((Object)lastContext.get());
        } else {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)indicator.getProject());
            context = CodeCompletionHandlerBase.insertItem(indicator.getLookup(), item, completionChar, update, editor, psiFile, caretOffset, idEndOffset, indicator.getOffsetMap());
        }
        if (context.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context, item));
        }
        CodeCompletionHandlerBase.checkPsiTextConcistency(indicator);
        return context;
    }

    private static OffsetsInFile findInjectedOffsetsIfAny(@NotNull Caret caret, boolean wasInjected, @NotNull OffsetsInFile topLevelOffsets, @NotNull Editor hostEditor) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(17);
        }
        if (topLevelOffsets == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(18);
        }
        if (hostEditor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(19);
        }
        if (!wasInjected) {
            return topLevelOffsets;
        }
        PsiDocumentManager.getInstance((Project)topLevelOffsets.getFile().getProject()).commitDocument(hostEditor.getDocument());
        return topLevelOffsets.toInjectedIfAny(caret.getOffset());
    }

    private static int calcIdEndOffset(CompletionProcessEx indicator) {
        return indicator.getOffsetMap().containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? indicator.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) : CompletionInitializationContext.calcDefaultIdentifierEnd((Editor)indicator.getEditor(), (int)indicator.getCaret().getOffset());
    }

    private static void checkPsiTextConcistency(CompletionProcessEx indicator) {
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)InjectedLanguageUtil.getTopLevelEditor(indicator.getEditor()), (Project)indicator.getProject());
        if (psiFile != null && (Registry.is((String)"ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest())) {
            StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            if (PsiDocumentManager.getInstance((Project)psiFile.getProject()).hasUncommitedDocuments()) {
                PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            }
        }
    }

    public static void afterItemInsertion(CompletionProgressIndicator indicator, Runnable laterRunnable) {
        if (laterRunnable != null) {
            ActionTracker tracker = new ActionTracker(indicator.getEditor(), indicator);
            Runnable wrapper2 = () -> {
                if (!indicator.getProject().isDisposed() && !tracker.hasAnythingHappened()) {
                    laterRunnable.run();
                }
                indicator.disposeIndicator();
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                wrapper2.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)indicator, wrapper2);
            }
        } else {
            indicator.disposeIndicator();
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItem(@Nullable Lookup lookup, LookupElement item, char completionChar, StatisticsUpdate update, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        editor.getCaretModel().moveToOffset(caretOffset);
        CompletionAssertions.WatchingInsertionContext context = CodeCompletionHandlerBase.createInsertionContext(lookup, item, completionChar, editor, psiFile, caretOffset, idEndOffset, offsetMap);
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document document;
                if (caretOffset < idEndOffset && completionChar == '\t' && (document = editor.getDocument()).getRangeGuard(caretOffset, idEndOffset) == null) {
                    document.deleteString(caretOffset, idEndOffset);
                }
                assert (context.getStartOffset() >= 0) : "stale startOffset: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                assert (context.getTailOffset() >= 0) : "stale tail: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                Project project = psiFile.getProject();
                if (item.requiresCommittedDocuments()) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
                item.handleInsert((InsertionContext)context);
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
            finally {
                context.stopWatching();
            }
            EditorModificationUtil.scrollToCaret((Editor)editor);
        });
        if (lookup != null) {
            update.addSparedChars(lookup, item, context);
        }
        return context;
    }

    @NotNull
    private static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable Lookup lookup, LookupElement item, char completionChar, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        CompletionAssertions.WatchingInsertionContext context;
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, initialStartOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        CompletionAssertions.WatchingInsertionContext watchingInsertionContext = context = new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, lookup != null ? lookup.getItems() : Collections.emptyList(), editor);
        if (watchingInsertionContext == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(20);
        }
        return watchingInsertionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionAssertions.WatchingInsertionContext callHandleInsert(CompletionProgressIndicator indicator, LookupElement item, char completionChar) {
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = CodeCompletionHandlerBase.calcIdEndOffset(indicator);
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)indicator.getProject());
        CompletionAssertions.WatchingInsertionContext context = CodeCompletionHandlerBase.createInsertionContext(indicator.getLookup(), item, completionChar, editor, psiFile, caretOffset, idEndOffset, indicator.getOffsetMap());
        try {
            item.handleInsert((InsertionContext)context);
        }
        finally {
            context.stopWatching();
        }
        return context;
    }

    public static void addCompletionChar(InsertionContext context, LookupElement item) {
        if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            String message = "tailOffset<0 after inserting " + item + " of " + item.getClass();
            if (context instanceof CompletionAssertions.WatchingInsertionContext) {
                message = message + "; invalidated at: " + ((CompletionAssertions.WatchingInsertionContext)context).invalidateTrace + "\n--------";
            }
            LOG.info(message);
        } else if (!CompletionAssertions.isEditorValid(context.getEditor())) {
            LOG.info("Injected editor invalidated " + context.getEditor());
        } else {
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (context.getCompletionChar() == '\r') {
            Language language = PsiUtilBase.getLanguageInEditor((Editor)context.getEditor(), (Project)context.getFile().getProject());
            if (language != null) {
                SmartEnterProcessor processor2;
                Iterator iterator = SmartEnterProcessors.INSTANCE.allForLanguage(language).iterator();
                while (iterator.hasNext() && !(processor2 = (SmartEnterProcessor)iterator.next()).processAfterCompletion(context.getEditor(), context.getFile())) {
                }
            }
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)context.getEditor().getContentComponent());
            EditorActionManager.getInstance().getTypedAction().getHandler().execute(context.getEditor(), context.getCompletionChar(), dataContext);
        }
    }

    private static boolean isAutocompleteOnInvocation(CompletionType type) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (type == CompletionType.SMART) {
            return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }

    private static Runnable rememberDocumentState(Editor _editor) {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor(_editor);
        String documentText = editor.getDocument().getText();
        int caret = editor.getCaretModel().getOffset();
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        int vOffset = editor.getScrollingModel().getVerticalScrollOffset();
        int hOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        return () -> {
            DocumentEx document = (DocumentEx)editor.getDocument();
            document.replaceString(0, document.getTextLength(), documentText);
            editor.getCaretModel().moveToOffset(caret);
            editor.getSelectionModel().setSelection(selStart, selEnd);
            editor.getScrollingModel().scrollHorizontally(hOffset);
            editor.getScrollingModel().scrollVertically(vOffset);
        };
    }

    private static void clearCaretMarkers(@NotNull Editor editor) {
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(21);
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            caret.putUserData(CARET_PROCESSED, null);
        }
    }

    private static void markCaretAsProcessed(@NotNull Caret caret) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(22);
        }
        caret.putUserData(CARET_PROCESSED, (Object)Boolean.TRUE);
    }

    private static Caret getNextCaretToProcess(@NotNull Editor editor) {
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(23);
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.getUserData(CARET_PROCESSED) != null) continue;
            return caret;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static <T> T withTimeout(long maxDurationMillis, @NotNull Computable<T> computable) {
        void task2;
        if (computable == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(24);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (T)task2.compute();
        }
        return ProgressIndicatorUtils.withTimeout(maxDurationMillis, task2);
    }

    private static int calcSyncTimeOut(long startTime) {
        return (int)Math.max(300L, (long)ourAutoInsertItemTimeout - (System.currentTimeMillis() - startTime));
    }

    public static void setAutoInsertTimeout(int timeout) {
        ourAutoInsertItemTimeout = timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelOffsets";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainLookup";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeCompletion";
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemSelected";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleCompletionElementSelected";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedOffsetsIfAny";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearCaretMarkers";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markCaretAsProcessed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNextCaretToProcess";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

