/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TextToCDataIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TextToCDataIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Convert text to CData" == null) {
            TextToCDataIntention.$$$reportNull$$$0(1);
        }
        return "Convert text to CData";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TextToCDataIntention.$$$reportNull$$$0(2);
        }
        return file2.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && TextToCDataIntention.getText(editor, file2) != null && !file2.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        int pos;
        PsiElement textElement;
        if (project == null) {
            TextToCDataIntention.$$$reportNull$$$0(3);
        }
        if ((textElement = TextToCDataIntention.getText(editor, file2)) == null) {
            return;
        }
        ArrayList<PsiElement> texts = new ArrayList<PsiElement>();
        PsiElement curr = textElement.getPrevSibling();
        while (TextToCDataIntention.isText(curr)) {
            texts.add(0, curr);
            curr = curr.getPrevSibling();
        }
        texts.add(textElement);
        curr = textElement.getNextSibling();
        while (TextToCDataIntention.isText(curr)) {
            texts.add(curr);
            curr = curr.getNextSibling();
        }
        StringBuilder text = new StringBuilder();
        for (PsiElement element : texts) {
            text.append(StringUtil.unescapeXmlEntities((String)element.getText()));
        }
        int start2 = 0;
        while ((pos = text.indexOf("]]>", start2)) >= 0) {
            text.insert(pos + 1, "]]><![CDATA[");
            start2 = pos + 2;
        }
        int begin = ((PsiElement)texts.get(0)).getTextRange().getStartOffset();
        String replacement = "<![CDATA[" + text.toString() + "]]>";
        editor.getDocument().replaceString(begin, ((PsiElement)texts.get(texts.size() - 1)).getTextRange().getEndOffset(), (CharSequence)replacement);
        editor.getCaretModel().moveToOffset(begin + replacement.length());
    }

    private static PsiElement getText(Editor editor, PsiFile file2) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (TextToCDataIntention.isText(parent)) {
            return parent;
        }
        element = file2.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (TextToCDataIntention.isText(parent)) {
            return parent;
        }
        return null;
    }

    private static boolean isText(PsiElement element) {
        if (element instanceof XmlText) {
            return true;
        }
        return element instanceof XmlEntityRef && element.getParent() instanceof XmlText;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/TextToCDataIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/TextToCDataIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

