/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/navigation/PsiElementTargetPresentation;", "Lcom/intellij/navigation/TargetPresentation;", "myElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "myItemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "myModule", "Lcom/intellij/openapi/module/Module;", "getMyModule", "()Lcom/intellij/openapi/module/Module;", "myModule$delegate", "Lkotlin/Lazy;", "myProject", "Lcom/intellij/openapi/project/Project;", "myVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getColoredAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFileBackgroundColor", "Ljava/awt/Color;", "getIcon", "Ljavax/swing/Icon;", "getLocationAttributes", "getLocationText", "", "getPresentableAttributes", "getPresentableText", "getRightIcon", "getRightText", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class PsiElementTargetPresentation
implements TargetPresentation {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final Lazy myModule$delegate;
    private final ItemPresentation myItemPresentation;
    private final PsiElement myElement;
    private static final Pattern CONTAINER_PATTERN;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PsiElementTargetPresentation.class), "myModule", "getMyModule()Lcom/intellij/openapi/module/Module;"))};
        Companion = new Companion(null);
        CONTAINER_PATTERN = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
    }

    private final Module getMyModule() {
        Lazy lazy = this.myModule$delegate;
        PsiElementTargetPresentation psiElementTargetPresentation = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Module)lazy.getValue();
    }

    @Nullable
    public Icon getIcon() {
        return this.myElement.getIcon(3);
    }

    @NotNull
    public String getPresentableText() {
        Object object;
        Object object2 = this.myItemPresentation;
        if (object2 == null || (object2 = object2.getPresentableText()) == null) {
            PsiElement psiElement = this.myElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
            object2 = object = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        if (object2 == null) {
            String string = this.myElement.getText();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myElement.text");
        }
        return object;
    }

    private final TextAttributes getColoredAttributes() {
        ColoredItemPresentation coloredPresentation;
        ColoredItemPresentation coloredItemPresentation;
        ItemPresentation itemPresentation = this.myItemPresentation;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((coloredItemPresentation = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (coloredItemPresentation = coloredItemPresentation.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)coloredItemPresentation, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        ColoredItemPresentation textAttributesKey = coloredItemPresentation;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    private final Color getFileBackgroundColor() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return EditorTabPresentationUtil.getFileBackgroundColor(this.myProject, virtualFile2);
    }

    @Nullable
    public TextAttributes getPresentableAttributes() {
        TextAttributes textAttributes;
        TextAttributes textAttributes2 = textAttributes = this.getColoredAttributes();
        if ((textAttributes2 != null ? textAttributes2.getBackgroundColor() : null) != null) {
            return textAttributes;
        }
        Color fileColor = this.getFileBackgroundColor();
        if (fileColor == null) {
            return textAttributes;
        }
        TextAttributes textAttributes3 = textAttributes;
        if (textAttributes3 == null || (textAttributes3 = textAttributes3.clone()) == null) {
            textAttributes3 = new TextAttributes();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes3, (String)"textAttributes?.clone() ?: TextAttributes()");
        TextAttributes result2 = textAttributes3;
        result2.setBackgroundColor(fileColor);
        return result2;
    }

    @Nullable
    public String getLocationText() {
        Object object = this.myItemPresentation;
        if (object == null || (object = object.getLocationString()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"myItemPresentation?.locationString ?: return null");
        Object locationString = object;
        Matcher matcher = CONTAINER_PATTERN.matcher((CharSequence)locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @Nullable
    public TextAttributes getLocationAttributes() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile2);
        Color locationColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(virtualFile2);
        return hasProblem ? new TextAttributes(locationColor, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (locationColor != null ? new TextAttributes(locationColor, null, null, null, 0) : null);
    }

    @Nullable
    public String getRightText() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(myProject)");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (fileIndex.isInLibrarySource(virtualFile2) || fileIndex.isInLibraryClasses(virtualFile2)) {
            VirtualFile virtualFile3 = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile2);
            if (virtualFile3 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"JarFileSystem.getInstanc\u2026rtualFile) ?: return null");
            VirtualFile jar = virtualFile3;
            String string = jar.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jar.name");
            String name = string;
            String string2 = UtilKt.orderEntryText(fileIndex, virtualFile2);
            if (string2 == null) {
                string2 = UtilKt.sdkText(virtualFile2);
            }
            if (string2 == null) {
                return '(' + name + ')';
            }
            String text = string2;
            return Intrinsics.areEqual((Object)text, (Object)name) ? text : text + " (" + name + ')';
        }
        Module module = this.getMyModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (Registry.is((String)"ide.show.folder.name.instead.of.module.name")) {
            String string = ModuleUtilCore.getModuleDirPath((Module)module2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ModuleUtilCore.getModuleDirPath(module)");
            String path = string;
            CharSequence charSequence = path;
            return charSequence.length() == 0 ? module2.getName() : new File(path).getName();
        }
        return module2.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Icon getRightIcon() {
        Icon icon;
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) return null;
        VirtualFile virtualFile2 = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(myProject)");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (fileIndex.isInLibrarySource(virtualFile2) || fileIndex.isInLibraryClasses(virtualFile2)) {
            icon = AllIcons.Nodes.PpLibFolder;
            return icon;
        } else if (fileIndex.isInTestSourceContent(virtualFile2)) {
            icon = AllIcons.Nodes.TestSourceFolder;
            return icon;
        } else {
            Module module;
            Module module2 = this.getMyModule();
            Module module3 = module2;
            if (module2 == null) return null;
            Module it = module = module3;
            boolean bl = false;
            ModuleType moduleType = ModuleType.get((Module)it);
            module3 = moduleType;
            if (moduleType == null) return null;
            icon = module3.getIcon();
        }
        return icon;
    }

    public PsiElementTargetPresentation(@NotNull PsiElement myElement) {
        Intrinsics.checkParameterIsNotNull((Object)myElement, (String)"myElement");
        this.myElement = myElement;
        Project project = this.myElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        this.myProject = project;
        PsiFile psiFile = this.myElement.getContainingFile();
        this.myVirtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        this.myModule$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Module>(this){
            final /* synthetic */ PsiElementTargetPresentation this$0;

            @Nullable
            public final Module invoke() {
                Module module;
                VirtualFile virtualFile = PsiElementTargetPresentation.access$getMyVirtualFile$p(this.this$0);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it = virtualFile2 = virtualFile;
                    boolean bl = false;
                    module = ModuleUtil.findModuleForFile((VirtualFile)it, (Project)PsiElementTargetPresentation.access$getMyProject$p(this.this$0));
                } else {
                    module = null;
                }
                return module;
            }
            {
                this.this$0 = psiElementTargetPresentation;
                super(0);
            }
        }));
        PsiElement psiElement = this.myElement;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)psiElement;
        this.myItemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
    }

    public static final /* synthetic */ VirtualFile access$getMyVirtualFile$p(PsiElementTargetPresentation $this) {
        return $this.myVirtualFile;
    }

    public static final /* synthetic */ Project access$getMyProject$p(PsiElementTargetPresentation $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/navigation/PsiElementTargetPresentation$Companion;", "", "()V", "CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

