/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorageKt$deleteFile$;
import com.intellij.configurationStore.FileBasedStorageKt$doWrite$;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0000\u001a0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a(\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a<\u0010\u001a\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"XML_PROLOG", "", "getXML_PROLOG", "()[B", "deleteFile", "", "file", "Ljava/nio/file/Path;", "requestor", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectLineSeparators", "Lcom/intellij/util/LineSeparator;", "chars", "", "defaultSeparator", "doWrite", "dataWriterOrByteArray", "lineSeparator", "prependXmlProlog", "", "isEqualContent", "result", "content", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "writeFile", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "intellij.platform.configurationStore.impl"})
public final class FileBasedStorageKt {
    @NotNull
    private static final byte[] XML_PROLOG;

    @NotNull
    public static final VirtualFile writeFile(@Nullable Path file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull DataWriter dataWriter, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile result2;
        block12: {
            block11: {
                VirtualFile virtualFile2;
                Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
                Intrinsics.checkParameterIsNotNull((Object)dataWriter, (String)"dataWriter");
                Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
                if (!(file2 == null || virtualFile != null && virtualFile.isValid())) {
                    virtualFile2 = StorageUtilKt.getOrCreateVirtualFile(file2, requestor);
                } else {
                    virtualFile2 = virtualFile;
                    if (virtualFile2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                result2 = virtualFile2;
                if (ComponentStoreImplKt.getLOG().isDebugEnabled()) break block11;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block12;
            }
            if (!FileUtilRt.isTooLarge((long)result2.getLength())) {
                BufferExposingByteArrayOutputStream content = XmlElementStorageKt.toBufferExposingByteArray(dataWriter, lineSeparator);
                if (FileBasedStorageKt.isEqualContent(result2, lineSeparator, content, prependXmlProlog)) {
                    byte[] byArray = content.toByteArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"content.toByteArray()");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                    Charset charset2 = charset;
                    String contentString = new String(byArray2, charset2);
                    ComponentStoreImplKt.getLOG().warn("Content equals, but it must be handled not on this level: file " + result2.getName() + ", content:\n" + contentString);
                } else if (StorageUtilKt.getDEBUG_LOG() != null) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        StorageUtilKt.setDEBUG_LOG(result2.getPath() + ":\n" + content + "\nOld Content:\n" + LoadTextUtil.loadText(result2));
                    }
                }
            }
        }
        FileBasedStorageKt.doWrite(requestor, result2, dataWriter, lineSeparator, prependXmlProlog);
        return result2;
    }

    @NotNull
    public static final byte[] getXML_PROLOG() {
        return XML_PROLOG;
    }

    private static final boolean isEqualContent(VirtualFile result2, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        boolean bl;
        block5: {
            int headerLength;
            int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
            if ((int)result2.getLength() != headerLength + content.size()) {
                return false;
            }
            byte[] byArray = result2.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"result.contentsToByteArray()");
            byte[] oldContent = byArray;
            if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
                return false;
            }
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)headerLength, (int)oldContent.length);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (oldContent[it] == content.getInternalBuffer()[it - headerLength]) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void doWrite(Object requestor, VirtualFile file2, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
        boolean bl;
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        Object e$iv = null;
        boolean $i$f$debugOrInfoIfTestMode2 = false;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            Logger logger = $receiver$iv;
            bl = false;
            String string = "Save " + file2.getPresentableUrl();
            logger.info(string);
        } else {
            Logger $receiver$iv$iv = $receiver$iv;
            boolean $i$f$debug = false;
            if ($receiver$iv$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv$iv;
                bl = false;
                String string = "Save " + file2.getPresentableUrl();
                logger.debug(string, (Throwable)e$iv);
            }
        }
        if (file2.isWritable()) {
            void resultRef$iv$iv;
            boolean $i$f$runUndoTransparentWriteAction = false;
            boolean $i$f$computeDelegated = false;
            Ref.ObjectRef $i$f$debugOrInfoIfTestMode2 = new Ref.ObjectRef();
            $i$f$debugOrInfoIfTestMode2.element = null;
            Function1 it$iv = (Function1)new Function1<Unit, Unit>((Ref.ObjectRef)resultRef$iv$iv){
                final /* synthetic */ Ref.ObjectRef $resultRef;
                {
                    this.$resultRef = objectRef;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(Object it) {
                    this.$resultRef.element = it;
                }
            };
            boolean bl2 = false;
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(it$iv, file2, requestor, prependXmlProlog, lineSeparator, dataWriterOrByteArray){
                final /* synthetic */ Function1 $it;
                final /* synthetic */ VirtualFile $file$inlined;
                final /* synthetic */ Object $requestor$inlined;
                final /* synthetic */ boolean $prependXmlProlog$inlined;
                final /* synthetic */ LineSeparator $lineSeparator$inlined;
                final /* synthetic */ Object $dataWriterOrByteArray$inlined;
                {
                    this.$it = function1;
                    this.$file$inlined = virtualFile;
                    this.$requestor$inlined = object;
                    this.$prependXmlProlog$inlined = bl;
                    this.$lineSeparator$inlined = lineSeparator;
                    this.$dataWriterOrByteArray$inlined = object2;
                }

                public final void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                        final /* synthetic */ doWrite$$inlined$runUndoTransparentWriteAction$2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Function1 function1 = this.this$0.$it;
                            boolean bl = false;
                            Closeable closeable = this.this$0.$file$inlined.getOutputStream(this.this$0.$requestor$inlined);
                            Throwable throwable = null;
                            try {
                                OutputStream output = (OutputStream)closeable;
                                boolean bl2 = false;
                                if (this.this$0.$prependXmlProlog$inlined) {
                                    output.write(FileBasedStorageKt.getXML_PROLOG());
                                    output.write(this.this$0.$lineSeparator$inlined.getSeparatorBytes());
                                }
                                if (this.this$0.$dataWriterOrByteArray$inlined instanceof DataWriter) {
                                    DataWriter dataWriter = (DataWriter)this.this$0.$dataWriterOrByteArray$inlined;
                                    OutputStream outputStream = output;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"output");
                                    String string = this.this$0.$lineSeparator$inlined.getSeparatorString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                                    DataWriter.DefaultImpls.write$default(dataWriter, outputStream, string, null, 4, null);
                                } else {
                                    Object object = this.this$0.$dataWriterOrByteArray$inlined;
                                    if (object == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                                    }
                                    ((BufferExposingByteArrayOutputStream)object).writeTo(output);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            Unit unit = Unit.INSTANCE;
                            function1.invoke((Object)unit);
                        }
                    });
                }
            });
            Object cfr_ignored_0 = resultRef$iv$iv.element;
            return;
        }
        e$iv = dataWriterOrByteArray;
        if (e$iv instanceof DataWriter) {
            bufferExposingByteArrayOutputStream = XmlElementStorageKt.toBufferExposingByteArray((DataWriter)dataWriterOrByteArray, lineSeparator);
        } else {
            Object object = dataWriterOrByteArray;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
            }
            bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
        }
        BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
        throw (Throwable)new ReadOnlyModificationException(file2, new SaveSession(requestor, file2, byteArray, lineSeparator, prependXmlProlog){
            final /* synthetic */ Object $requestor;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
            final /* synthetic */ LineSeparator $lineSeparator;
            final /* synthetic */ boolean $prependXmlProlog;

            public void save() {
                FileBasedStorageKt.access$doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
            }
            {
                this.$requestor = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
                this.$byteArray = $captured_local_variable$2;
                this.$lineSeparator = $captured_local_variable$3;
                this.$prependXmlProlog = $captured_local_variable$4;
            }
        });
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharSequence charSequence = chars;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    @NotNull
    public static /* synthetic */ LineSeparator detectLineSeparators$default(CharSequence charSequence, LineSeparator lineSeparator, int n, Object object) {
        if ((n & 2) != 0) {
            lineSeparator = null;
        }
        return FileBasedStorageKt.detectLineSeparators(charSequence, lineSeparator);
    }

    private static final void deleteFile(Path file2, Object requestor, VirtualFile virtualFile) {
        if (virtualFile == null) {
            try {
                Files.delete(file2);
            }
            catch (NoSuchFileException noSuchFileException) {}
        } else if (virtualFile.exists()) {
            if (virtualFile.isWritable()) {
                FileBasedStorageKt.deleteFile(requestor, virtualFile);
            } else {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, new SaveSession(virtualFile, requestor){
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ Object $requestor;

                    public void save() {
                        this.$virtualFile.delete(this.$requestor);
                    }
                    {
                        this.$virtualFile = $captured_local_variable$0;
                        this.$requestor = $captured_local_variable$1;
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) {
        void resultRef$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        boolean $i$f$runUndoTransparentWriteAction = false;
        boolean $i$f$computeDelegated = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1 it$iv = (Function1)new Function1<Unit, Unit>((Ref.ObjectRef)resultRef$iv$iv){
            final /* synthetic */ Ref.ObjectRef $resultRef;
            {
                this.$resultRef = objectRef;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(Object it) {
                this.$resultRef.element = it;
            }
        };
        boolean bl = false;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(it$iv, virtualFile, requestor){
            final /* synthetic */ Function1 $it;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ Object $requestor$inlined;
            {
                this.$it = function1;
                this.$virtualFile$inlined = virtualFile;
                this.$requestor$inlined = object;
            }

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ deleteFile$$inlined$runUndoTransparentWriteAction$2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        Function1 function1 = this.this$0.$it;
                        boolean bl = false;
                        this.this$0.$virtualFile$inlined.delete(this.this$0.$requestor$inlined);
                        Unit unit = Unit.INSTANCE;
                        function1.invoke((Object)unit);
                    }
                });
            }
        });
        Object cfr_ignored_0 = resultRef$iv$iv.element;
    }

    static {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        XML_PROLOG = byArray;
    }

    public static final /* synthetic */ void access$deleteFile(Path file2, Object requestor, VirtualFile virtualFile) {
        FileBasedStorageKt.deleteFile(file2, requestor, virtualFile);
    }

    public static final /* synthetic */ void access$doWrite(Object requestor, VirtualFile file2, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.doWrite(requestor, file2, dataWriterOrByteArray, lineSeparator, prependXmlProlog);
    }
}

