/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.ImportSettingsActionKt;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0015J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0010\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00120\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationStore/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doImport", "saveFile", "Ljava/io/File;", "Ljava/nio/file/Path;", "getExportableComponents", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "relativePaths", "", "", "getMarkedComponents", "components", "getRelativeNamesToExtract", "chosenComponents", "promptLocationMessage", "kotlin.jvm.PlatformType", "update", "intellij.platform.configurationStore.impl"})
public class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(ExportSettingsActionKt.isImportExportActionApplicable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
        String string = PathManager.getConfigPath();
        String string2 = IdeBundle.message((String)"title.import.file.location", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"title.import.file.location\")");
        String string3 = IdeBundle.message((String)"prompt.choose.import.file.path", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"promp\u2026choose.import.file.path\")");
        ChooseComponentsToExportDialogKt.chooseSettingsFile(string, component, string2, string3).onSuccess((Consumer)new Consumer<String>(this){
            final /* synthetic */ ImportSettingsAction this$0;

            public final void accept(String it) {
                Path saveFile = Paths.get(it, new String[0]);
                try {
                    Path path = saveFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"saveFile");
                    this.this$0.doImport(path);
                }
                catch (ZipException e1) {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file", (Object[])new Object[]{saveFile, e1.getMessage(), ImportSettingsAction.access$promptLocationMessage(this.this$0)}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
                }
                catch (IOException e1) {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file.2", (Object[])new Object[]{saveFile, e1.getMessage()}), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
                }
            }
            {
                this.this$0 = importSettingsAction;
            }
        });
    }

    @NotNull
    protected Map<Path, List<ExportableItem>> getExportableComponents(@NotNull Set<String> relativePaths) {
        Intrinsics.checkParameterIsNotNull(relativePaths, (String)"relativePaths");
        return ExportSettingsActionKt.getExportableComponentsMap$default(false, true, null, relativePaths, 4, null);
    }

    @NotNull
    protected Set<ExportableItem> getMarkedComponents(@NotNull Set<ExportableItem> components) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        return components;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="doImport(saveFile.toPath())"))
    protected void doImport(@NotNull File saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        Path path = saveFile.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"saveFile.toPath()");
        this.doImport(path);
    }

    protected void doImport(@NotNull Path saveFile) {
        Path tempFile;
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        if (!PathKt.exists((Path)saveFile)) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.find.file", (Object[])new Object[]{saveFile}), (String)IdeBundle.message((String)"title.file.not.found", (Object[])new Object[0]));
            return;
        }
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(PathKt.inputStream((Path)saveFile));
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{saveFile, this.promptLocationMessage()}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
            return;
        }
        String string = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026hManager.getConfigPath())");
        String configPath = string;
        Map<Path, List<ExportableItem>> map2 = this.getExportableComponents(relativePaths);
        String string2 = IdeBundle.message((String)"title.select.components.to.import", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"title\u2026ct.components.to.import\")");
        String string3 = IdeBundle.message((String)"prompt.check.components.to.import", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"promp\u2026ck.components.to.import\")");
        ChooseComponentsToExportDialog dialog2 = new ChooseComponentsToExportDialog(map2, false, string2, string3);
        if (!dialog2.showAndGet()) {
            return;
        }
        Path path = tempFile = Paths.get(PathManager.getPluginTempPath(), new String[0]).resolve(saveFile.getFileName());
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempFile");
        PathKt.copy((Path)saveFile, (Path)path);
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(this.getMarkedComponents(dialog2.getExportableComponents$intellij_platform_configurationStore_impl())));
        StartupActionScriptManager.addActionCommands((List)CollectionsKt.listOf((Object[])new StartupActionScriptManager.ActionCommand[]{(StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.UnzipCommand(tempFile.toFile(), new File(configPath), (FilenameFilter)filenameFilter), (StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(tempFile.toFile())}));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        String action = IdeBundle.message((String)(application.isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        String string4 = IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"IdeBundle.message(\"title.restart.needed\")");
        Object[] objectArray = new Object[2];
        objectArray[0] = action;
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[1] = applicationNamesInfo.getFullProductName();
        String string5 = IdeBundle.message((String)"message.settings.imported.successfully", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"IdeBundle.message(\"messa\u2026stance().fullProductName)");
        String string6 = IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"IdeBundle.message(\"ide.restart.action\")");
        if (MessageUtil.showOkCancelDialog$default((String)string4, (String)string5, (String)string6, null, (Icon)Messages.getQuestionIcon(), null, null, (int)104, null) == 0) {
            Application application2 = ApplicationManager.getApplication();
            if (application2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
            }
            ((ApplicationEx)application2).restart(true);
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<ExportableItem> chosenComponents) {
        THashSet result2 = new THashSet();
        Path root = Paths.get(PathManager.getConfigPath(), new String[0]);
        for (ExportableItem item : chosenComponents) {
            Path path = root.relativize(item.getFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"root.relativize(item.file)");
            result2.add((Object)PathKt.getSystemIndependentPath((Path)path));
        }
        result2.add((Object)"installed.txt");
        return (Set)result2;
    }

    private final String promptLocationMessage() {
        return IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0]);
    }

    public static final /* synthetic */ String access$promptLocationMessage(ImportSettingsAction $this) {
        return $this.promptLocationMessage();
    }
}

