/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardTreeCellRenderer;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsServiceViewContributor
implements ServiceViewContributor<RunConfigurationNode, RunDashboardGroup, RunDashboardRunConfigurationStatus> {
    @NotNull
    public List<RunConfigurationNode> getNodes(@NotNull Project project) {
        if (project == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(0);
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        List list2 = ContainerUtil.map((Collection)runDashboardManager.getRunConfigurations(), value -> new RunConfigurationNode(project, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)value, runDashboardManager.getContributor(((RunnerAndConfigurationSettings)value.first).getType())));
        if (list2 == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getNodeDescriptor(final @NotNull RunConfigurationNode node) {
        if (node == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(2);
        }
        ServiceViewContributor.ViewDescriptor viewDescriptor = new ServiceViewContributor.ViewDescriptor(){
            private boolean selected;

            public JComponent getContentComponent() {
                Content content = node.getContent();
                return content == null ? RunConfigurationsServiceViewContributor.createEmptyContent() : content.getManager().getComponent();
            }

            public ActionGroup getToolbarActions() {
                return RunConfigurationsServiceViewContributor.getToolbarActions(node.getDescriptor());
            }

            public ActionGroup getPopupActions() {
                return RunConfigurationsServiceViewContributor.getPopupActions();
            }

            public ItemPresentation getPresentation() {
                return node.getPresentation();
            }

            public DataProvider getDataProvider() {
                Content content = node.getContent();
                if (content == null) {
                    return null;
                }
                DataContext context = DataManager.getInstance().getDataContext((Component)content.getComponent());
                return arg_0 -> ((DataContext)context).getData(arg_0);
            }

            public void onNodeSelected() {
                ContentManager contentManager;
                this.selected = true;
                Content content = node.getContent();
                ContentManager contentManager2 = contentManager = content == null ? null : content.getManager();
                if (contentManager == null || content == contentManager.getSelectedContent()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (contentManager.isDisposed() || contentManager.getIndexOfContent(content) == -1 || !this.selected) {
                        return;
                    }
                    contentManager.setSelectedContent(content);
                });
            }

            public void onNodeUnselected() {
                ContentManager contentManager;
                this.selected = false;
                Content content = node.getContent();
                ContentManager contentManager2 = contentManager = content == null ? null : content.getManager();
                if (contentManager == null || content != contentManager.getSelectedContent()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (contentManager.isDisposed() || !contentManager.isSelected(content) || this.selected) {
                        return;
                    }
                    contentManager.removeFromSelection(content);
                });
            }

            public boolean handleDoubleClick(@NotNull MouseEvent event) {
                RunDashboardContributor contributor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (contributor = node.getContributor()) != null && contributor.handleDoubleClick(node.getConfigurationSettings().getConfiguration());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$1", "handleDoubleClick"));
            }
        };
        if (viewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(3);
        }
        return viewDescriptor;
    }

    @Nullable
    public ServiceViewContributor.ViewDescriptorRenderer getViewDescriptorRenderer() {
        return new ServiceViewContributor.ViewDescriptorRenderer(){
            final RunDashboardTreeCellRenderer renderer = new RunDashboardTreeCellRenderer();

            @NotNull
            public Component getRendererComponent(JComponent parent, Object value, ServiceViewContributor.ViewDescriptor viewDescriptor, boolean selected, boolean hasFocus) {
                Component component = this.renderer.getTreeCellRendererComponent((JTree)parent, value, selected, true, true, 0, hasFocus);
                if (component == null) {
                    2.$$$reportNull$$$0(0);
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$2", "getRendererComponent"));
            }
        };
    }

    @NotNull
    public List<RunDashboardGroup> getGroups(@NotNull RunConfigurationNode node) {
        if (node == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(4);
        }
        ArrayList<RunDashboardGroup> result2 = new ArrayList<RunDashboardGroup>();
        for (RunDashboardGroupingRule rule : RunDashboardGroupingRule.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)rule.getGroup((AbstractTreeNode)node));
        }
        ArrayList<RunDashboardGroup> arrayList = result2;
        if (arrayList == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getGroupDescriptor(@NotNull RunDashboardGroup group) {
        if (group == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(6);
        }
        final PresentationData presentationData = new PresentationData();
        presentationData.setPresentableText(group.getName());
        presentationData.setIcon(group.getIcon());
        ServiceViewContributor.ViewDescriptor viewDescriptor = new ServiceViewContributor.ViewDescriptor(){

            public JComponent getContentComponent() {
                return null;
            }

            public ActionGroup getToolbarActions() {
                return RunConfigurationsServiceViewContributor.getToolbarActions(null);
            }

            public ActionGroup getPopupActions() {
                return RunConfigurationsServiceViewContributor.getPopupActions();
            }

            public ItemPresentation getPresentation() {
                return presentationData;
            }

            public DataProvider getDataProvider() {
                return null;
            }
        };
        if (viewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(7);
        }
        return viewDescriptor;
    }

    @NotNull
    public RunDashboardRunConfigurationStatus getState(@NotNull RunConfigurationNode node) {
        if (node == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(8);
        }
        RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = node.getStatus();
        if (runDashboardRunConfigurationStatus == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(9);
        }
        return runDashboardRunConfigurationStatus;
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getStateDescriptor(@NotNull RunDashboardRunConfigurationStatus status) {
        if (status == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(10);
        }
        final PresentationData presentationData = new PresentationData();
        presentationData.setPresentableText(status.getName());
        presentationData.setIcon(status.getIcon());
        ServiceViewContributor.ViewDescriptor viewDescriptor = new ServiceViewContributor.ViewDescriptor(){

            public JComponent getContentComponent() {
                return null;
            }

            public ActionGroup getToolbarActions() {
                return null;
            }

            public ItemPresentation getPresentation() {
                return presentationData;
            }

            public DataProvider getDataProvider() {
                return null;
            }
        };
        if (viewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(11);
        }
        return viewDescriptor;
    }

    @NotNull
    private static JComponent createEmptyContent() {
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
        if (jBPanelWithEmptyText == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(12);
        }
        return jBPanelWithEmptyText;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("RunDashboardContentToolbar"));
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor);
        if (ui == null) {
            return actionGroup;
        }
        List<AnAction> leftToolbarActions = ui.getActions();
        for (AnAction action : leftToolbarActions) {
            if (action instanceof StopAction || action instanceof FakeRerunAction) continue;
            actionGroup.add(action);
        }
        return actionGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("RunDashboardContentToolbar"));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardTreeToolbar"));
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStateDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

