/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.util.Key;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\"\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"getEffectiveBeforeRunTaskList", "", "Lcom/intellij/execution/BeforeRunTask;", "ownTasks", "templateTasks", "ownIsOnlyEnabled", "", "isDisableTemplateTasks", "getHardcodedBeforeRunTasks", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "intellij.platform.lang.impl"})
public final class BeforeRunTaskHelperKt {
    @NotNull
    public static final List<BeforeRunTask<?>> getEffectiveBeforeRunTaskList(@NotNull List<? extends BeforeRunTask<?>> ownTasks, @NotNull List<? extends BeforeRunTask<?>> templateTasks, boolean ownIsOnlyEnabled, boolean isDisableTemplateTasks) {
        Iterable $receiver$iv$iv;
        Set set2;
        Intrinsics.checkParameterIsNotNull(ownTasks, (String)"ownTasks");
        Intrinsics.checkParameterIsNotNull(templateTasks, (String)"templateTasks");
        Collection $receiver$iv = ownTasks;
        boolean $i$f$mapSmartSet = false;
        int n = $receiver$iv.size();
        switch (n) {
            case 1: {
                BeforeRunTask it;
                Iterable result$iv = new SmartHashSet();
                BeforeRunTask beforeRunTask = (BeforeRunTask)CollectionsKt.first((Iterable)$receiver$iv);
                Iterable iterable = result$iv;
                boolean bl = false;
                Key key = it.getProviderId();
                iterable.add(key);
                set2 = (Set)result$iv;
                break;
            }
            case 0: {
                set2 = SetsKt.emptySet();
                break;
            }
            default: {
                Key key;
                BeforeRunTask it;
                Iterable iterable;
                Iterable result$iv = $receiver$iv;
                Collection destination$iv$iv = (Collection)new THashSet(n);
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (BeforeRunTask)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl = false;
                    key = it.getProviderId();
                    iterable.add(key);
                }
                set2 = (Set)destination$iv$iv;
            }
        }
        Set idToSet = set2;
        Collection $receiver$iv2 = ownTasks;
        boolean bl = false;
        $receiver$iv$iv = $receiver$iv2;
        Collection destination$iv$iv = $receiver$iv2.size() <= 1 ? (List)new SmartList() : (List)new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BeforeRunTask it = (BeforeRunTask)element$iv$iv;
            boolean bl2 = false;
            if (!(!ownIsOnlyEnabled || it.isEnabled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        int i = 0;
        for (BeforeRunTask beforeRunTask : templateTasks) {
            BeforeRunTask beforeRunTask2;
            if (!beforeRunTask.isEnabled() || idToSet.contains(beforeRunTask.getProviderId())) continue;
            if (isDisableTemplateTasks) {
                BeforeRunTask clone;
                Intrinsics.checkExpressionValueIsNotNull((Object)beforeRunTask.clone(), (String)"templateTask.clone()");
                clone.setEnabled(false);
                beforeRunTask2 = clone;
            } else {
                beforeRunTask2 = beforeRunTask;
            }
            BeforeRunTask effectiveTemplateTask = beforeRunTask2;
            result2.add(i, effectiveTemplateTask);
            ++i;
        }
        return result2;
    }

    @NotNull
    public static final List<BeforeRunTask<?>> getHardcodedBeforeRunTasks(@NotNull RunConfiguration configuration, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        List result2 = null;
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)configuration.getProject())) {
            BeforeRunTask task2;
            if (provider.createTask(configuration) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"provider.createTask(configuration) ?: continue");
            if (!task2.isEnabled()) continue;
            BeforeRunTaskProvider beforeRunTaskProvider = provider;
            Intrinsics.checkExpressionValueIsNotNull((Object)beforeRunTaskProvider, (String)"provider");
            factory.configureBeforeRunTaskDefaults(beforeRunTaskProvider.getId(), task2);
            if (!task2.isEnabled()) continue;
            if (result2 == null) {
                result2 = (List)new SmartList();
            }
            result2.add(task2);
        }
        List list2 = result2;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }
}

