/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.xmlb.annotations.Property;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="ServiceViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ServiceViewManagerImpl
implements ServiceViewManager,
PersistentStateComponent<State> {
    @NonNls
    private static final String HELP_ID = "run-dashboard.reference";
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;
    private ServiceView myServiceView;

    public ServiceViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ServiceViewContributor.TOPIC, this::updateToolWindow);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(1);
        }
        this.myServiceView = new ServiceView(this.myProject, this.myState.viewState);
        Content toolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myServiceView, null, false);
        toolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        toolWindowContent.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        toolWindowContent.setCloseable(false);
        Disposer.register((Disposable)toolWindowContent, (Disposable)this.myServiceView);
        Disposer.register((Disposable)toolWindowContent, () -> {
            this.myServiceView = null;
        });
        toolWindow.getContentManager().addContent(toolWindowContent);
    }

    public void selectNode(Object node) {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            ServiceView content = this.myServiceView;
            if (content != null) {
                content.selectNode(node);
            }
        });
    }

    private void updateToolWindow(ServiceViewContributor.ServiceEvent event) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            boolean available = true;
            ToolWindow toolWindow = toolWindowManager.getToolWindow(ToolWindowId.SERVICES);
            if (toolWindow == null) {
                toolWindow = this.createToolWindow(toolWindowManager, available);
                if (available) {
                    toolWindow.show(null);
                }
                return;
            }
            boolean doShow = !toolWindow.isAvailable() && available;
            toolWindow.setAvailable(available, null);
            if (doShow) {
                toolWindow.show(null);
            }
        });
    }

    private ToolWindow createToolWindow(ToolWindowManager toolWindowManager, boolean available) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(ServiceViewManagerImpl.getToolWindowId(), true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(ServiceViewManagerImpl.getToolWindowIcon());
        toolWindow.setAvailable(available, null);
        this.createToolWindowContent(toolWindow);
        return toolWindow;
    }

    @NotNull
    public State getState() {
        ServiceView serviceView = this.myServiceView;
        if (serviceView != null) {
            this.myState.viewState = serviceView.getState();
            this.myState.viewState.treeStateElement = new Element("root");
            this.myState.viewState.treeState.writeExternal(this.myState.viewState.treeStateElement);
        }
        State state = this.myState;
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(2);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(3);
        }
        this.myState = state;
        this.myState.viewState.treeState = TreeState.createFrom((Element)this.myState.viewState.treeStateElement);
    }

    static ServiceView getServiceView(@NotNull Project project) {
        if (project == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(4);
        }
        return ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).myServiceView;
    }

    private static String getToolWindowId() {
        return ToolWindowId.SERVICES;
    }

    private static Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    static String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServiceView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        @Property(surroundWithTag=false)
        public ServiceViewState viewState = new ServiceViewState();

        State() {
        }
    }
}

