/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ChangeLAFAnimator;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(1);
        }
        final LafManager lafMan = LafManager.getInstance();
        UIManager.LookAndFeelInfo[] lfs = lafMan.getInstalledLookAndFeels();
        UIManager.LookAndFeelInfo current = lafMan.getCurrentLookAndFeel();
        for (final UIManager.LookAndFeelInfo lf : lfs) {
            group.add((AnAction)new DumbAwareAction(lf.getName(), "", lf == current ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    QuickChangeLookAndFeel.switchLafAndUpdateUI(lafMan, lf, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeLookAndFeel$1", "actionPerformed"));
                }
            });
        }
    }

    public static void switchLafAndUpdateUI(@NotNull LafManager lafMan, @NotNull UIManager.LookAndFeelInfo lf, boolean async) {
        UIManager.LookAndFeelInfo cur;
        if (lafMan == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(2);
        }
        if (lf == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(3);
        }
        if ((cur = lafMan.getCurrentLookAndFeel()) == lf) {
            return;
        }
        ChangeLAFAnimator animator = Registry.is((String)"ide.intellij.laf.enable.animation") ? ChangeLAFAnimator.showSnapshot() : null;
        boolean wasDarcula = UIUtil.isUnderDarcula();
        lafMan.setCurrentLookAndFeel(lf);
        Runnable updater = () -> {
            Ref updated = Ref.create((Object)false);
            LafManagerListener listener2 = s -> updated.set((Object)true);
            lafMan.addLafManagerListener(listener2);
            try {
                if (UIUtil.isUnderDarcula()) {
                    DarculaInstaller.install();
                } else if (wasDarcula) {
                    DarculaInstaller.uninstall();
                }
            }
            finally {
                lafMan.removeLafManagerListener(listener2);
                if (!((Boolean)updated.get()).booleanValue()) {
                    lafMan.updateUI();
                }
                if (animator != null) {
                    animator.hideSnapshotWithAnimation();
                }
            }
        };
        if (async) {
            SwingUtilities.invokeLater(updater);
        } else {
            updater.run();
        }
    }

    protected boolean isEnabled() {
        return LafManager.getInstance().getInstalledLookAndFeels().length > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lafMan";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/QuickChangeLookAndFeel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "switchLafAndUpdateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

