/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SEListSelectionTracker
implements ListSelectionListener {
    private final JBList<?> myList;
    private final SearchEverywhereUI.SearchListModel myListModel;
    private int lockCounter;
    private final List<Object> selectedItems = new ArrayList<Object>();
    private boolean moreSelected = false;

    SEListSelectionTracker(JBList<?> list2, SearchEverywhereUI.SearchListModel model) {
        this.myList = list2;
        this.myListModel = model;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.isLocked()) {
            return;
        }
        this.saveSelection();
    }

    void saveSelection() {
        List<Object> selectedItemsList;
        this.selectedItems.clear();
        int[] indices = this.myList.getSelectedIndices();
        if (indices.length == 1 && this.myListModel.isMoreElement(indices[0])) {
            this.moreSelected = true;
            selectedItemsList = Collections.singletonList(this.myListModel.getElementAt(indices[0] - 1));
        } else {
            this.moreSelected = false;
            selectedItemsList = Arrays.stream(indices).filter(i -> !this.myListModel.isMoreElement(i)).mapToObj(i -> this.myListModel.getElementAt(i)).collect(Collectors.toList());
        }
        this.selectedItems.addAll(selectedItemsList);
    }

    void restoreSelection() {
        if (this.isLocked()) {
            return;
        }
        this.lock();
        try {
            int[] indicesToSelect = this.calcIndicesToSelect();
            if (this.moreSelected && indicesToSelect.length == 1) {
                indicesToSelect[0] = indicesToSelect[0] + 1;
            }
            if (indicesToSelect.length == 0) {
                indicesToSelect = new int[]{0};
            }
            this.myList.setSelectedIndices(indicesToSelect);
            ScrollingUtil.ensureRangeIsVisible(this.myList, (int)indicesToSelect[0], (int)indicesToSelect[indicesToSelect.length - 1]);
        }
        finally {
            this.unlock();
        }
    }

    void resetSelectionIfNeeded() {
        int[] indices = this.calcIndicesToSelect();
        if (indices.length == 0) {
            this.selectedItems.clear();
        }
    }

    void lock() {
        ++this.lockCounter;
    }

    void unlock() {
        if (this.lockCounter > 0) {
            --this.lockCounter;
        }
    }

    private boolean isLocked() {
        return this.lockCounter > 0;
    }

    private int[] calcIndicesToSelect() {
        List<Object> items = this.myListModel.getItems();
        if (items.isEmpty()) {
            return new int[0];
        }
        return IntStream.range(0, items.size()).filter(i -> this.selectedItems.contains(items.get(i))).toArray();
    }
}

