/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.Changeable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.OnOffButton;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopHitSEContributor
implements SearchEverywhereContributor<Void> {
    private final Collection<SearchTopHitProvider> myTopHitProviders = Arrays.asList(SearchTopHitProvider.EP_NAME.getExtensions());
    private final Project myProject;
    private final Component myContextComponent;
    private final Consumer<? super String> mySearchStringSetter;

    public TopHitSEContributor(Project project, Component component, Consumer<? super String> setter) {
        this.myProject = project;
        this.myContextComponent = component;
        this.mySearchStringSetter = setter;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = TopHitSEContributor.class.getSimpleName();
        if (string == null) {
            TopHitSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        if ("Top Hit" == null) {
            TopHitSEContributor.$$$reportNull$$$0(1);
        }
        return "Top Hit";
    }

    public String includeNonProjectItemsText() {
        return null;
    }

    public int getSortWeight() {
        return 50;
    }

    public boolean showInFindResults() {
        return false;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Void> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (pattern == null) {
            TopHitSEContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            TopHitSEContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            TopHitSEContributor.$$$reportNull$$$0(4);
        }
        this.fill(pattern, consumer);
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        ArrayList<SearchEverywhereCommandInfo> res2 = new ArrayList<SearchEverywhereCommandInfo>();
        HashSet<String> found = new HashSet<String>();
        for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            String providerId;
            if (!(provider instanceof OptionsTopHitProvider) || found.contains(providerId = ((OptionsTopHitProvider)provider).getId())) continue;
            found.add(providerId);
            res2.add(new SearchEverywhereCommandInfo(providerId, "", (SearchEverywhereContributor)this));
        }
        ArrayList<SearchEverywhereCommandInfo> arrayList = res2;
        if (arrayList == null) {
            TopHitSEContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            TopHitSEContributor.$$$reportNull$$$0(6);
        }
        if (dataId == null) {
            TopHitSEContributor.$$$reportNull$$$0(7);
        }
        return null;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String text) {
        if (selected == null) {
            TopHitSEContributor.$$$reportNull$$$0(8);
        }
        if (text == null) {
            TopHitSEContributor.$$$reportNull$$$0(9);
        }
        if (selected instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2;
            option2.setOptionState(!(option2 = (BooleanOptionDescription)selected).isOptionEnabled());
            return false;
        }
        if (selected instanceof OptionsTopHitProvider) {
            this.setSearchString(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)selected).getId() + " ");
            return false;
        }
        if (TopHitSEContributor.isActionValue(selected) || TopHitSEContributor.isSetting(selected)) {
            GotoActionAction.openOptionOrPerformAction(selected, "", this.myProject, this.myContextComponent);
            return true;
        }
        return false;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        if (list2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(10);
        }
        TopHitRenderer topHitRenderer = new TopHitRenderer(this.myProject);
        if (topHitRenderer == null) {
            TopHitSEContributor.$$$reportNull$$$0(11);
        }
        return topHitRenderer;
    }

    private void fill(String pattern, Function<Object, Boolean> consumer) {
        if (pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
            return;
        }
        if (this.fillActions(pattern, consumer)) {
            return;
        }
        this.fillFromExtensions(pattern, consumer);
    }

    private void fillFromExtensions(String pattern, Function<Object, Boolean> consumer) {
        for (SearchTopHitProvider provider : this.myTopHitProviders) {
            if (provider instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider).isEnabled(this.myProject)) continue;
            boolean[] interrupted = new boolean[]{false};
            provider.consumeTopHits(pattern, o -> {
                interrupted[0] = (Boolean)consumer.apply(o);
            }, this.myProject);
            if (!interrupted[0]) continue;
            return;
        }
    }

    private boolean fillActions(String pattern, Function<Object, Boolean> consumer) {
        ActionManager actionManager = ActionManager.getInstance();
        List actions = AbbreviationManager.getInstance().findActions(pattern);
        for (String actionId : actions) {
            AnAction action = actionManager.getAction(actionId);
            if (action == null || !this.isEnabled(action) || consumer.apply(action).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabled(AnAction action) {
        Presentation presentation = action.getTemplatePresentation();
        if (ActionUtil.isDumbMode((Project)this.myProject) && !action.isDumbAware()) {
            return false;
        }
        return presentation.isEnabled() && presentation.isVisible() && !StringUtil.isEmpty((String)presentation.getText());
    }

    private void setSearchString(String str) {
        this.mySearchStringSetter.accept(str);
    }

    private static boolean isActionValue(Object o) {
        return o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    private static String getSettingText(OptionDescription value) {
        String hit = value.getHit();
        if (hit == null) {
            hit = value.getOption();
        }
        if ((hit = StringUtil.unescapeXmlEntities((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        hit = hit.replace("  ", " ");
        String text = hit.trim();
        text = StringUtil.trimEnd((String)text, (String)":");
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementsRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TopHitRenderer
    extends ColoredListCellRenderer<Object> {
        private final Project myProject;
        private final MyAccessiblePanel myRendererPanel = new MyAccessiblePanel();

        private TopHitRenderer(Project project) {
            this.myProject = project;
        }

        public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
            Color bg;
            Component cmp = super.getListCellRendererComponent(list2, value, index, selected, hasFocus);
            if (value instanceof BooleanOptionDescription) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBackground(UIUtil.getListBackground((boolean)selected));
                panel2.add(cmp, "Center");
                OnOffButton button2 = new OnOffButton();
                button2.setSelected(((BooleanOptionDescription)value).isOptionEnabled());
                OnOffButton rightComponent = button2;
                panel2.add((Component)rightComponent, "East");
                cmp = panel2;
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)selected));
                bg = cmp.getBackground();
            }
            this.myRendererPanel.removeAll();
            JPanel wrapped = new JPanel(new BorderLayout());
            wrapped.setBackground(bg);
            wrapped.add(cmp, "Center");
            this.myRendererPanel.add((Component)wrapped, "Center");
            if (cmp instanceof Accessible) {
                this.myRendererPanel.setAccessible((Accessible)((Object)cmp));
            }
            return this.myRendererPanel;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                TopHitRenderer.$$$reportNull$$$0(0);
            }
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (TopHitSEContributor.isActionValue(value)) {
                    AnAction anAction = (AnAction)value;
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id);
                        if (toolWindow != null) {
                            icon = toolWindow.getIcon();
                        }
                    }
                    this.append(String.valueOf(templatePresentation.getText()));
                    if (icon != null && icon.getIconWidth() <= 16 && icon.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon, (int)16, (int)16));
                    }
                } else if (TopHitSEContributor.isSetting(value)) {
                    String text = TopHitSEContributor.getSettingText((OptionDescription)value);
                    SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (value instanceof Changeable && ((Changeable)value).hasChanged()) {
                        if (selected) {
                            attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        } else {
                            SimpleTextAttributes base = SimpleTextAttributes.LINK_BOLD_ATTRIBUTES;
                            attrs = base.derive(1, base.getFgColor(), null, null);
                        }
                    }
                    this.append(text, attrs);
                } else if (value instanceof OptionsTopHitProvider) {
                    this.append(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)value).getId());
                } else {
                    ItemPresentation presentation = null;
                    if (value instanceof ItemPresentation) {
                        presentation = (ItemPresentation)value;
                    } else if (value instanceof NavigationItem) {
                        presentation = ((NavigationItem)value).getPresentation();
                    }
                    if (presentation != null) {
                        String text = presentation.getPresentableText();
                        this.append(text == null ? value.toString() : text);
                        Icon icon = presentation.getIcon(false);
                        if (icon != null) {
                            this.setIcon(icon);
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor$TopHitRenderer", "customizeCellRenderer"));
        }

        private static class MyAccessiblePanel
        extends JPanel {
            private Accessible myAccessible;

            MyAccessiblePanel() {
                super(new BorderLayout());
                this.setOpaque(false);
            }

            void setAccessible(Accessible comp) {
                this.myAccessible = comp;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                this.accessibleContext = this.myAccessible != null ? this.myAccessible.getAccessibleContext() : super.getAccessibleContext();
                return this.accessibleContext;
            }
        }
    }
}

