/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.FixedHotfixGroupElement;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.HotfixGroupElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorViewStructure
extends AbstractTreeStructure {
    private final ErrorTreeElement myRoot = new MyRootElement();
    private final List<String> myGroupNames = new ArrayList<String>();
    private final Map<String, GroupingElement> myGroupNameToElementMap = new HashMap<String, GroupingElement>();
    private final Map<String, List<NavigatableMessageElement>> myGroupNameToMessagesMap = new HashMap<String, List<NavigatableMessageElement>>();
    private final Map<ErrorTreeElementKind, List<ErrorTreeElement>> mySimpleMessages = new EnumMap<ErrorTreeElementKind, List<ErrorTreeElement>>(ErrorTreeElementKind.class);
    private final Object myLock = new Object();
    private static final ErrorTreeElementKind[] ourMessagesOrder = new ErrorTreeElementKind[]{ErrorTreeElementKind.INFO, ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE, ErrorTreeElementKind.GENERIC};
    private final Project myProject;
    private final boolean myCanHideWarnings;

    public ErrorViewStructure(Project project, boolean canHideWarnings) {
        this.myProject = project;
        this.myCanHideWarnings = canHideWarnings;
    }

    @NotNull
    public Object getRootElement() {
        ErrorTreeElement errorTreeElement = this.myRoot;
        if (errorTreeElement == null) {
            ErrorViewStructure.$$$reportNull$$$0(0);
        }
        return errorTreeElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages(@NotNull Set<ErrorTreeElementKind> kinds) {
        if (kinds == null) {
            ErrorViewStructure.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> messages;
            for (Map.Entry<ErrorTreeElementKind, List<ErrorTreeElement>> entry : this.mySimpleMessages.entrySet()) {
                if (!kinds.contains(entry.getKey()) || (messages = entry.getValue()) == null || messages.isEmpty()) continue;
                return true;
            }
            for (Map.Entry<Object, List<ErrorTreeElement>> entry : this.myGroupNameToMessagesMap.entrySet()) {
                messages = entry.getValue();
                if (messages == null || messages.isEmpty()) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kinds.contains(navigatableMessageElement.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public ErrorTreeElement[] getChildElements(@NotNull Object element) {
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(2);
        }
        if (element == this.myRoot) {
            children = new ArrayList<ErrorTreeElement>();
            var3_4 = this.myLock;
            synchronized (var3_4) {
                for (ErrorTreeElementKind kind : ErrorViewStructure.ourMessagesOrder) {
                    if (this.myCanHideWarnings && (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings() || (elems = this.mySimpleMessages.get(kind)) == null) continue;
                    children.addAll(elems);
                }
                for (String myGroupName : this.myGroupNames) {
                    groupingElement = this.myGroupNameToElementMap.get(myGroupName);
                    if (!this.shouldShowFileElement(groupingElement)) continue;
                    children.add(groupingElement);
                }
            }
            v0 = children.toArray(ErrorTreeElement.EMPTY_ARRAY);
            if (v0 == null) {
                ErrorViewStructure.$$$reportNull$$$0(3);
            }
            return v0;
        }
        if (element instanceof GroupingElement) {
            var2_3 = this.myLock;
            synchronized (var2_3) {
                children = this.myGroupNameToMessagesMap.get(((GroupingElement)element).getName());
                if (children == null || children.isEmpty()) ** break block18
                if (!this.myCanHideWarnings || !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) ** break block19
                filtered = new ArrayList<NavigatableMessageElement>(children.size());
                for (NavigatableMessageElement navigatableMessageElement : children) {
                    kind = navigatableMessageElement.getKind();
                    if (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) continue;
                    filtered.add(navigatableMessageElement);
                }
                v1 = filtered.toArray(ErrorTreeElement.EMPTY_ARRAY);
                ** if (v1 != null) goto lbl43
            }
lbl-1000:
            // 1 sources

            {
                ErrorViewStructure.$$$reportNull$$$0(4);
            }
lbl43:
            // 2 sources

            return v1;
            {
                v2 = children.toArray(new NavigatableMessageElement[0]);
                ** if (v2 != null) goto lbl49
            }
lbl-1000:
            // 1 sources

            {
                ErrorViewStructure.$$$reportNull$$$0(5);
            }
lbl49:
            // 2 sources

            return v2;
            {
            }
        }
        if (ErrorTreeElement.EMPTY_ARRAY == null) {
            ErrorViewStructure.$$$reportNull$$$0(6);
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShowFileElement(GroupingElement groupingElement) {
        if (!this.myCanHideWarnings || !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return this.getChildCount(groupingElement) > 0;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            if (children2 != null) {
                for (NavigatableMessageElement child2 : children2) {
                    ErrorTreeElementKind kind = child2.getKind();
                    if (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(7);
        }
        if (element instanceof GroupingElement || element instanceof SimpleMessageElement) {
            return this.myRoot;
        }
        if (element instanceof NavigatableMessageElement) {
            GroupingElement result2 = ((NavigatableMessageElement)element).getParent();
            return result2 == null ? this.myRoot : result2;
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            ErrorViewStructure.$$$reportNull$$$0(8);
        }
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = new ErrorTreeNodeDescriptor(this.myProject, parentDescriptor, (ErrorTreeElement)element);
        if (errorTreeNodeDescriptor == null) {
            ErrorViewStructure.$$$reportNull$$$0(9);
        }
        return errorTreeNodeDescriptor;
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(10);
        }
        if (text == null) {
            ErrorViewStructure.$$$reportNull$$$0(11);
        }
        if (underFileGroup != null || file2 != null) {
            if (file2 == null) {
                column = -1;
                line = -1;
            }
            int guiline = line < 0 ? -1 : line + 1;
            int guicolumn = column < 0 ? -1 : column + 1;
            VirtualFile group = underFileGroup != null ? underFileGroup : file2;
            VirtualFile nav = file2 != null ? file2 : underFileGroup;
            this.addNavigatableMessage(group.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text, data, NewErrorTreeViewPanel.createExportPrefix(guiline), NewErrorTreeViewPanel.createRendererPrefix(guiline, guicolumn), group);
        } else {
            this.addSimpleMessage(kind, text, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getGroupChildrenData(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupName);
            if (children2 == null || children2.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (NavigatableMessageElement child2 : children2) {
                Object data = child2.getData();
                if (data == null) continue;
                result2.add(data);
            }
            return result2;
        }
    }

    public void addFixedHotfixGroup(String text, List<? extends SimpleErrorData> children2) {
        FixedHotfixGroupElement group = new FixedHotfixGroupElement(text, null, null);
        this.addGroupPlusElements(text, group, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<? extends SimpleErrorData> children2, MutableErrorTreeView view) {
        String text = hotfixData.getErrorText();
        HotfixGroupElement group = new HotfixGroupElement(text, null, null, (Consumer<? super HotfixGate>)hotfixData.getFix(), hotfixData.getFixComment(), view);
        this.addGroupPlusElements(text, group, children2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupPlusElements(String text, GroupingElement group, List<? extends SimpleErrorData> children2) {
        ArrayList<MyNavigatableWithDataElement> elements = new ArrayList<MyNavigatableWithDataElement>();
        for (SimpleErrorData simpleErrorData : children2) {
            elements.add(new MyNavigatableWithDataElement(this.myProject, simpleErrorData.getKind(), group, simpleErrorData.getMessages(), simpleErrorData.getVf(), NewErrorTreeViewPanel.createExportPrefix(-1), NewErrorTreeViewPanel.createRendererPrefix(-1, -1)));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.add(text);
            this.myGroupNameToElementMap.put(text, group);
            this.myGroupNameToMessagesMap.put(text, elements);
        }
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(12);
        }
        this.addSimpleMessage(kind, text, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@Nullable String groupName, Navigatable navigatable, @NotNull ErrorTreeElementKind kind, String[] message, Object data, String exportText, String rendererTextPrefix, VirtualFile file2) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(13);
        }
        if (groupName == null) {
            this.addSimpleMessageElement(new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
                if (elements == null) {
                    elements = new ArrayList<NavigatableMessageElement>();
                    this.myGroupNameToMessagesMap.put(groupName, elements);
                }
                elements.add(new NavigatableMessageElement(kind, this.getGroupingElement(groupName, data, file2), message, navigatable, exportText, rendererTextPrefix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(@NotNull String groupName, @NotNull NavigatableMessageElement navigatableMessageElement) {
        if (groupName == null) {
            ErrorViewStructure.$$$reportNull$$$0(14);
        }
        if (navigatableMessageElement == null) {
            ErrorViewStructure.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
            if (elements == null) {
                elements = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements);
            }
            if (!this.myGroupNameToElementMap.containsKey(groupName)) {
                this.myGroupNames.add(groupName);
                this.myGroupNameToElementMap.put(groupName, navigatableMessageElement.getParent());
            }
            elements.add(navigatableMessageElement);
        }
    }

    private void addSimpleMessage(@NotNull ErrorTreeElementKind kind, String[] text, Object data) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(16);
        }
        this.addSimpleMessageElement(new SimpleMessageElement(kind, text, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSimpleMessageElement(ErrorTreeElement element) {
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> elements = this.mySimpleMessages.get(element.getKind());
            if (elements == null) {
                elements = new ArrayList<ErrorTreeElement>();
                this.mySimpleMessages.put(element.getKind(), elements);
            }
            elements.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GroupingElement lookupGroupingElement(String groupName) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGroupNameToElementMap.get(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupingElement getGroupingElement(String groupName, Object data, VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            GroupingElement element = this.myGroupNameToElementMap.get(groupName);
            if (element != null) {
                return element;
            }
            element = this.createGroupingElement(groupName, data, file2);
            this.myGroupNames.add(groupName);
            this.myGroupNameToElementMap.put(groupName, element);
            return element;
        }
    }

    @NotNull
    protected GroupingElement createGroupingElement(String groupName, Object data, VirtualFile file2) {
        GroupingElement groupingElement = new GroupingElement(groupName, data, file2);
        if (groupingElement == null) {
            ErrorViewStructure.$$$reportNull$$$0(17);
        }
        return groupingElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(GroupingElement groupingElement) {
        Object object = this.myLock;
        synchronized (object) {
            List<NavigatableMessageElement> children2 = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            return children2 == null ? 0 : children2.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.clear();
            this.myGroupNameToElementMap.clear();
            this.myGroupNameToMessagesMap.clear();
            this.mySimpleMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            ErrorViewStructure.$$$reportNull$$$0(18);
        }
        if (this.myCanHideWarnings && (ErrorTreeElementKind.WARNING.equals((Object)kind) || ErrorTreeElementKind.NOTE.equals((Object)kind)) && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<ErrorTreeElement> simpleMessages = this.mySimpleMessages.get(kind);
            if (simpleMessages != null && !simpleMessages.isEmpty()) {
                return simpleMessages.get(0);
            }
            for (String path : this.myGroupNames) {
                List<NavigatableMessageElement> messages = this.myGroupNameToMessagesMap.get(path);
                if (messages == null) continue;
                for (NavigatableMessageElement navigatableMessageElement : messages) {
                    if (!kind.equals((Object)navigatableMessageElement.getKind())) continue;
                    return navigatableMessageElement;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGroupNames.remove(name);
            this.myGroupNameToElementMap.remove(name);
            this.myGroupNameToMessagesMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ErrorTreeElement element) {
        if (element == this.myRoot) {
            return;
        }
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            this.removeGroup(groupingElement.getName());
            VirtualFile virtualFile = groupingElement.getFile();
            if (virtualFile != null) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiFile psiFile;
                    PsiFile psiFile2 = psiFile = virtualFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(virtualFile) : null;
                    if (psiFile != null) {
                        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
                    }
                });
            }
        } else if (element instanceof NavigatableMessageElement) {
            NavigatableMessageElement navElement = (NavigatableMessageElement)element;
            GroupingElement parent = navElement.getParent();
            if (parent != null) {
                Object object = this.myLock;
                synchronized (object) {
                    List<NavigatableMessageElement> groupMessages = this.myGroupNameToMessagesMap.get(parent.getName());
                    if (groupMessages != null) {
                        groupMessages.remove(navElement);
                    }
                }
            }
        } else {
            Object object = this.myLock;
            synchronized (object) {
                List<ErrorTreeElement> simples = this.mySimpleMessages.get(element.getKind());
                if (simples != null) {
                    simples.remove(element);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/errorTreeView/ErrorViewStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatableMessageElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/errorTreeView/ErrorViewStructure";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasMessages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNavigatableMessage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavigatableWithDataElement
    extends NavigatableMessageElement {
        private final VirtualFile myVf;
        private final CustomizeColoredTreeCellRenderer myCustomizeColoredTreeCellRenderer;

        private MyNavigatableWithDataElement(Project project, @NotNull ErrorTreeElementKind kind, GroupingElement parent, String[] message, final @NotNull VirtualFile vf, String exportText, String rendererTextPrefix) {
            if (kind == null) {
                MyNavigatableWithDataElement.$$$reportNull$$$0(0);
            }
            if (vf == null) {
                MyNavigatableWithDataElement.$$$reportNull$$$0(1);
            }
            super(kind, parent, message, (Navigatable)new OpenFileDescriptor(project, vf, -1, -1), exportText, rendererTextPrefix);
            this.myVf = vf;
            this.myCustomizeColoredTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer2, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                    Icon icon = myVf.getFileType().getIcon();
                    renderer2.setIcon(icon);
                    String[] messages = this.getText();
                    String text = messages == null || messages.length == 0 ? vf.getPath() : messages[0];
                    renderer2.append(text);
                }
            };
        }

        @Override
        public Object getData() {
            return this.myVf;
        }

        @Override
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myCustomizeColoredTreeCellRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vf";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/errorTreeView/ErrorViewStructure$MyNavigatableWithDataElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRootElement
    extends ErrorTreeElement {
        private MyRootElement() {
        }

        @Override
        public String[] getText() {
            return null;
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public String getExportTextPrefix() {
            return "";
        }
    }
}

