/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchPopupController {
    private final PluginSearchTextField myTextField;
    protected SearchPopup myPopup;
    private final JBPopupListener mySearchPopupListener;

    public SearchPopupController(@NotNull PluginSearchTextField searchTextField) {
        if (searchTextField == null) {
            SearchPopupController.$$$reportNull$$$0(0);
        }
        this.mySearchPopupListener = new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchPopupController.this.myPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/SearchPopupController$1", "onClosed"));
            }
        };
        this.myTextField = searchTextField;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleShowPopup() {
        String query = this.myTextField.getText();
        int length = query.length();
        int position = this.getCaretPosition();
        if (position < length) {
            if (query.charAt(position) != ' ') {
                this.hidePopup();
                this.handleAppendToQuery();
                return;
            }
            if (position == 0 || query.charAt(position - 1) == ' ') {
                this.showAttributesPopup(null, position);
                return;
            }
        } else if (query.charAt(position - 1) == ' ') {
            this.showAttributesPopup(null, position);
            return;
        }
        Ref startPosition = new Ref();
        Pair<String, String> attribute = SearchPopupController.parseAttributeInQuery(query, position, (Ref<Integer>)startPosition);
        if (attribute.second == null) {
            this.showAttributesPopup((String)attribute.first, (Integer)startPosition.get());
            return;
        }
        this.handleShowAttributeValuesPopup((String)attribute.first, (String)attribute.second, (Integer)startPosition.get());
    }

    private int getCaretPosition() {
        return this.myTextField.getTextEditor().getCaretPosition();
    }

    @NotNull
    private static Pair<String, String> parseAttributeInQuery(@NotNull String query, int end, @NotNull Ref<Integer> startPosition) {
        int index;
        if (query == null) {
            SearchPopupController.$$$reportNull$$$0(1);
        }
        if (startPosition == null) {
            SearchPopupController.$$$reportNull$$$0(2);
        }
        String value = null;
        for (index = end - 1; index >= 0; --index) {
            char ch = query.charAt(index);
            if (ch == ':') {
                value = query.substring(index + 1, end);
                startPosition.set((Object)(index + 1));
                end = index + 1;
                --index;
                while (index >= 0 && query.charAt(index) != ' ') {
                    --index;
                }
                break;
            }
            if (ch == ' ') break;
        }
        String name = StringUtil.trimStart((String)query.substring(index + 1, end), (String)"-");
        if (startPosition.isNull()) {
            startPosition.set((Object)(index + (query.charAt(index + 1) == '-' ? 2 : 1)));
        }
        Pair pair = Pair.create((Object)name, (Object)value);
        if (pair == null) {
            SearchPopupController.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async;
        CollectionListModel model = new CollectionListModel(this.getAttributes());
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model, namePrefix)) {
            return;
        }
        boolean bl = async = this.myPopup != null;
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeName, (CollectionListModel<Object>)model, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async, new SearchPopupCallback(namePrefix){

            public void consume(String value) {
                SearchPopupController.this.appendSearchText(value, this.prefix);
                SearchPopupController.this.handleShowAttributeValuesPopup(value, null, SearchPopupController.this.getCaretPosition());
            }
        });
    }

    private void handleShowAttributeValuesPopup(@NotNull String name, @Nullable String valuePrefix, int caretPosition) {
        List<String> values;
        if (name == null) {
            SearchPopupController.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty(values = this.getValues(name))) {
            this.showPopupForQuery();
            return;
        }
        CollectionListModel model = new CollectionListModel(values);
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model, valuePrefix)) {
            return;
        }
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeValue, (CollectionListModel<Object>)model, valuePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(true, new SearchPopupCallback(valuePrefix){

            public void consume(String value) {
                if (StringUtil.containsAnyChar((String)value, (String)" ,:")) {
                    value = "\"" + value + "\"";
                }
                SearchPopupController.this.appendSearchText(value, this.prefix);
                SearchPopupController.this.handleAppendAttributeValue();
            }
        });
    }

    private boolean updatePopupOrCreate(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model, @Nullable String prefix, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(5);
        }
        if (model == null) {
            SearchPopupController.$$$reportNull$$$0(6);
        }
        if (this.myPopup != null && this.myPopup.type == type && this.myPopup.isValid()) {
            this.myPopup.model.replaceAll(model.getItems());
            this.myPopup.callback.prefix = prefix;
            this.myPopup.caretPosition = caretPosition;
            this.myPopup.update();
            return true;
        }
        this.createPopup(type, model, caretPosition);
        return false;
    }

    protected void createPopup(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(7);
        }
        if (model == null) {
            SearchPopupController.$$$reportNull$$$0(8);
        }
        this.hidePopup();
        this.myPopup = new SearchPopup(this.myTextField, this.mySearchPopupListener, type, model, caretPosition);
    }

    private void createAndShow(boolean async, @NotNull SearchPopupCallback callback2) {
        if (callback2 == null) {
            SearchPopupController.$$$reportNull$$$0(9);
        }
        ColoredListCellRenderer renderer2 = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.append((String)value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/plugins/newui/SearchPopupController$4", "customizeCellRenderer"));
            }
        };
        this.myPopup.createAndShow(callback2, renderer2, async);
    }

    private boolean noPrefixSearchValues(@NotNull CollectionListModel<Object> model, @Nullable String prefix) {
        if (model == null) {
            SearchPopupController.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)prefix)) {
            return false;
        }
        int index = 0;
        while (index < model.getSize()) {
            String attribute = (String)model.getElementAt(index);
            if (attribute.equals(prefix)) {
                this.hidePopup();
                return true;
            }
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)prefix)) {
                ++index;
                continue;
            }
            model.remove(index);
        }
        if (model.isEmpty()) {
            this.showPopupForQuery();
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract List<String> getAttributes();

    @Nullable
    protected abstract List<String> getValues(@NotNull String var1);

    protected abstract void showPopupForQuery();

    protected void handleAppendToQuery() {
    }

    protected void handleAppendAttributeValue() {
    }

    public boolean isPopupShow() {
        return this.myPopup != null && this.myPopup.isValid();
    }

    public void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide();
            this.myPopup = null;
        }
    }

    private void appendSearchText(@NotNull String value, @Nullable String prefix) {
        if (value == null) {
            SearchPopupController.$$$reportNull$$$0(11);
        }
        String text = this.myTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.myPopup != null) {
            this.myPopup.skipCaretEvent = true;
        }
        if (position < text.length()) {
            suffix = text.substring(position);
            text = text.substring(0, position);
        }
        if (prefix == null) {
            this.myTextField.setTextIgnoreEvents(text + value + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value, (String)prefix) || StringUtil.startsWithIgnoreCase((String)value, (String)("\"" + prefix))) {
            this.myTextField.setTextIgnoreEvents(text.substring(0, text.length() - prefix.length()) + value + suffix);
        } else {
            this.myTextField.setTextIgnoreEvents(text + value + suffix);
        }
        this.myTextField.getTextEditor().setCaretPosition(this.myTextField.getText().length() - suffix.length());
    }

    public boolean handleEnter(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(12);
        }
        if (this.myPopup != null && this.myPopup.list != null && this.myPopup.list.getSelectedIndex() != -1) {
            this.myPopup.list.dispatchEvent(event);
            return true;
        }
        this.handleEnter();
        return false;
    }

    protected void handleEnter() {
    }

    public boolean handleUpDown(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(13);
        }
        if (this.myPopup != null && this.myPopup.list != null) {
            if (event.getKeyCode() == 40 && this.myPopup.list.getSelectedIndex() == -1) {
                this.myPopup.list.setSelectedIndex(0);
                this.handlePopupListFirstSelection();
            } else {
                this.myPopup.list.dispatchEvent(event);
            }
        }
        return false;
    }

    protected void handlePopupListFirstSelection() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttributeInQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAttributeInQuery";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleShowAttributeValuesPopup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupOrCreate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndShow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "noPrefixSearchValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleEnter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleUpDown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

