/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.scopeChooser.FlattenPackagesAction;
import com.intellij.ide.util.scopeChooser.ShowFilesAction;
import com.intellij.ide.util.scopeChooser.ShowModuleGroupsAction;
import com.intellij.ide.util.scopeChooser.ShowModulesAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.CompoundPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeEditorPanel {
    private JPanel myButtonsPanel;
    private RawCommandLineEditor myPatternField;
    private JPanel myTreeToolbar;
    private final Tree myPackageTree;
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JLabel myMatchingCountLabel;
    private JPanel myLegendPanel;
    private final Project myProject;
    private final TreeExpansionMonitor myTreeExpansionMonitor;
    private final Marker myTreeMarker;
    private PackageSet myCurrentScope;
    private boolean myIsInUpdate;
    private String myErrorMessage;
    private Future<?> myUpdateAlarm;
    private JLabel myCaretPositionLabel;
    private int myCaretPosition;
    private JPanel myMatchingCountPanel;
    private JPanel myPositionPanel;
    private JLabel myRecursivelyIncluded;
    private JLabel myPartiallyIncluded;
    private PanelProgressIndicator myCurrentProgress;
    private NamedScopesHolder myHolder;

    public ScopeEditorPanel(final @NotNull Project project, @NotNull NamedScopesHolder holder) {
        if (project == null) {
            ScopeEditorPanel.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ScopeEditorPanel.$$$reportNull$$$0(1);
        }
        this.myCurrentScope = null;
        this.myIsInUpdate = false;
        this.$$$setupUI$$$();
        this.myUpdateAlarm = CompletableFuture.completedFuture(null);
        this.myCaretPosition = 0;
        this.myProject = project;
        this.myHolder = holder;
        this.myPackageTree = new Tree((TreeNode)new RootNode(project));
        this.myButtonsPanel.add(this.createActionsPanel());
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPackageTree), "Center");
        this.myTreeToolbar.setLayout(new BorderLayout());
        this.myTreeToolbar.add((Component)this.createTreeToolbar(), "West");
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)this.myPackageTree, this.myProject);
        this.myTreeMarker = new Marker(){

            @Override
            public boolean isMarked(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ScopeEditorPanel.this.myCurrentScope != null && (ScopeEditorPanel.this.myCurrentScope instanceof PackageSetBase ? ((PackageSetBase)ScopeEditorPanel.this.myCurrentScope).contains(file2, project, ScopeEditorPanel.this.myHolder) : ScopeEditorPanel.this.myCurrentScope.contains(PackageSetBase.getPsiFile((VirtualFile)file2, (Project)ScopeEditorPanel.this.myProject), ScopeEditorPanel.this.myHolder));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$1", "isMarked"));
            }
        };
        this.myPatternField.setDialogCaption("Pattern");
        this.myPatternField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.onTextChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$2", "textChanged"));
            }
        });
        this.myPatternField.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ScopeEditorPanel.this.myCaretPosition = e.getDot();
                ScopeEditorPanel.this.updateCaretPositionText();
            }
        });
        this.myPatternField.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ScopeEditorPanel.this.myErrorMessage != null) {
                    ScopeEditorPanel.this.myPositionPanel.setVisible(true);
                    ScopeEditorPanel.this.myPanel.revalidate();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ScopeEditorPanel.this.myPatternField.getEditorField().isExpanded()) {
                    ScopeEditorPanel.this.myPositionPanel.setVisible(false);
                    ScopeEditorPanel.this.myPanel.revalidate();
                }
            }
        });
        this.initTree(this.myPackageTree);
        new UiNotifyConnector((Component)this.myPanel, new Activatable(){

            public void showNotify() {
            }

            public void hideNotify() {
                ScopeEditorPanel.this.cancelCurrentProgress();
            }
        });
        this.myPartiallyIncluded.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(10, MyTreeCellRenderer.PARTIAL_INCLUDED)));
        this.myRecursivelyIncluded.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(10, MyTreeCellRenderer.WHOLE_INCLUDED)));
    }

    private void updateCaretPositionText() {
        if (this.myErrorMessage != null) {
            this.myCaretPositionLabel.setText(IdeBundle.message((String)"label.scope.editor.caret.position", (Object[])new Object[]{this.myCaretPosition + 1}));
        } else {
            this.myCaretPositionLabel.setText("");
        }
        this.myPositionPanel.setVisible(this.myErrorMessage != null);
        this.myCaretPositionLabel.setVisible(this.myErrorMessage != null);
        this.myPanel.revalidate();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JPanel getTreePanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myTreePanel, "Center");
        panel2.add((Component)this.myLegendPanel, "South");
        return panel2;
    }

    public JPanel getTreeToolbar() {
        return this.myTreeToolbar;
    }

    private void onTextChange() {
        if (!this.myIsInUpdate) {
            this.myUpdateAlarm.cancel(false);
            this.cancelCurrentProgress();
            String text = this.myPatternField.getText();
            this.myCurrentScope = new InvalidPackageSet(text);
            try {
                if (!StringUtil.isEmpty((String)text)) {
                    this.myCurrentScope = PackageSetFactory.getInstance().compile(text);
                }
                this.myErrorMessage = null;
            }
            catch (Exception e) {
                this.myErrorMessage = e.getMessage();
                this.showErrorMessage();
            }
            this.rebuild(false);
        } else if (!ScopeEditorPanel.invalidScopeInside(this.myCurrentScope)) {
            this.myErrorMessage = null;
        }
    }

    private void createUIComponents() {
        this.myPatternField = new RawCommandLineEditor(text -> Arrays.asList(text.split("\\|\\|")), strings -> StringUtil.join((Collection)strings, (String)"||"));
    }

    private static boolean invalidScopeInside(PackageSet currentScope) {
        if (currentScope instanceof InvalidPackageSet) {
            return true;
        }
        if (currentScope instanceof CompoundPackageSet) {
            return ContainerUtil.or((Object[])((CompoundPackageSet)currentScope).getSets(), s -> ScopeEditorPanel.invalidScopeInside(s));
        }
        if (currentScope instanceof ComplementPackageSet) {
            return ScopeEditorPanel.invalidScopeInside(((ComplementPackageSet)currentScope).getComplementarySet());
        }
        return false;
    }

    private void showErrorMessage() {
        this.myMatchingCountLabel.setText(StringUtil.capitalize((String)this.myErrorMessage));
        this.myMatchingCountLabel.setForeground((Color)JBColor.red);
        this.myMatchingCountLabel.setToolTipText(this.myErrorMessage);
    }

    private JComponent createActionsPanel() {
        final JButton include = new JButton(IdeBundle.message((String)"button.include", (Object[])new Object[0]));
        final JButton includeRec = new JButton(IdeBundle.message((String)"button.include.recursively", (Object[])new Object[0]));
        final JButton exclude = new JButton(IdeBundle.message((String)"button.exclude", (Object[])new Object[0]));
        final JButton excludeRec = new JButton(IdeBundle.message((String)"button.exclude.recursively", (Object[])new Object[0]));
        this.myPackageTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                boolean recursiveEnabled = ScopeEditorPanel.this.isButtonEnabled(true);
                includeRec.setEnabled(recursiveEnabled);
                excludeRec.setEnabled(recursiveEnabled);
                boolean nonRecursiveEnabled = ScopeEditorPanel.this.isButtonEnabled(false);
                include.setEnabled(nonRecursiveEnabled);
                exclude.setEnabled(nonRecursiveEnabled);
            }
        });
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        buttonsPanel.add(include);
        buttonsPanel.add(includeRec);
        buttonsPanel.add(exclude);
        buttonsPanel.add(excludeRec);
        include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.includeSelected(false);
            }
        });
        includeRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.includeSelected(true);
            }
        });
        exclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(false);
            }
        });
        excludeRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(true);
            }
        });
        return buttonsPanel;
    }

    boolean isButtonEnabled(boolean rec) {
        TreePath[] paths = this.myPackageTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, rec) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void excludeSelected(boolean recurse) {
        ArrayList<PackageSet> selected = this.getSelectedSets(recurse);
        if (selected == null || selected.isEmpty()) {
            return;
        }
        for (PackageSet set2 : selected) {
            Object[] objectArray;
            if (this.myCurrentScope == null) {
                this.myCurrentScope = new ComplementPackageSet(set2);
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? new ComplementPackageSet(set2) : IntersectionPackageSet.create((PackageSet[])new PackageSet[]{this.myCurrentScope, new ComplementPackageSet(set2)});
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set2, false, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            if (simplifiedScope == null) {
                this.myCurrentScope = new ComplementPackageSet(set2);
                continue;
            }
            if (simplifiedScope instanceof IntersectionPackageSet) {
                objectArray = ((IntersectionPackageSet)simplifiedScope).getSets();
            } else {
                PackageSet[] packageSetArray = new PackageSet[1];
                objectArray = packageSetArray;
                packageSetArray[0] = simplifiedScope;
            }
            Object[] sets = objectArray;
            this.myCurrentScope = IntersectionPackageSet.create((PackageSet[])((PackageSet[])ArrayUtil.append((Object[])sets, (Object)new ComplementPackageSet(set2))));
        }
        this.rebuild(true);
    }

    private void includeSelected(boolean recurse) {
        ArrayList<PackageSet> selected = this.getSelectedSets(recurse);
        if (selected == null || selected.isEmpty()) {
            return;
        }
        for (PackageSet set2 : selected) {
            Object[] objectArray;
            if (this.myCurrentScope == null) {
                this.myCurrentScope = set2;
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? set2 : UnionPackageSet.create((PackageSet[])new PackageSet[]{this.myCurrentScope, set2});
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set2, true, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            if (simplifiedScope == null) {
                this.myCurrentScope = set2;
                continue;
            }
            if (simplifiedScope instanceof UnionPackageSet) {
                objectArray = ((UnionPackageSet)simplifiedScope).getSets();
            } else {
                PackageSet[] packageSetArray = new PackageSet[1];
                objectArray = packageSetArray;
                packageSetArray[0] = simplifiedScope;
            }
            Object[] sets = objectArray;
            this.myCurrentScope = UnionPackageSet.create((PackageSet[])((PackageSet[])ArrayUtil.append((Object[])sets, (Object)set2)));
        }
        this.rebuild(true);
    }

    @Nullable
    static PackageSet processComplementaryScope(@NotNull PackageSet current, PackageSet added, boolean checkComplementSet, boolean[] append) {
        if (current == null) {
            ScopeEditorPanel.$$$reportNull$$$0(2);
        }
        String text = added.getText();
        if (current instanceof ComplementPackageSet && Comparing.strEqual((String)((ComplementPackageSet)current).getComplementarySet().getText(), (String)text)) {
            if (checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (Comparing.strEqual((String)current.getText(), (String)text)) {
            if (!checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (current instanceof UnionPackageSet) {
            Object[] sets = ((UnionPackageSet)current).getSets();
            PackageSet[] processed2 = (PackageSet[])ContainerUtil.mapNotNull((Object[])sets, s -> ScopeEditorPanel.processComplementaryScope(s, added, checkComplementSet, append), (Object[])new PackageSet[0]);
            return processed2.length == 0 ? null : UnionPackageSet.create((PackageSet[])processed2);
        }
        if (current instanceof IntersectionPackageSet) {
            Object[] sets = ((IntersectionPackageSet)current).getSets();
            PackageSet[] processed3 = (PackageSet[])ContainerUtil.mapNotNull((Object[])sets, s -> ScopeEditorPanel.processComplementaryScope(s, added, checkComplementSet, append), (Object[])new PackageSet[0]);
            return processed3.length == 0 ? null : IntersectionPackageSet.create((PackageSet[])processed3);
        }
        return current;
    }

    @Nullable
    private ArrayList<PackageSet> getSelectedSets(boolean recursively) {
        int[] rows = this.myPackageTree.getSelectionRows();
        if (rows == null) {
            return null;
        }
        ArrayList<PackageSet> result2 = new ArrayList<PackageSet>();
        for (int row2 : rows) {
            PackageDependenciesNode node = (PackageDependenciesNode)this.myPackageTree.getPathForRow(row2).getLastPathComponent();
            PackageSet set2 = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, recursively);
            if (set2 == null) continue;
            result2.add(set2);
        }
        return result2;
    }

    private JComponent createTreeToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        Runnable update = () -> this.rebuild(true);
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            group.add((AnAction)new FlattenPackagesAction(update));
        }
        List dialectProviders = PatternDialectProvider.EP_NAME.getExtensionList();
        for (PatternDialectProvider provider : dialectProviders) {
            for (AnAction action : provider.createActions(this.myProject, update)) {
                group.add(action);
            }
        }
        group.add((AnAction)new ShowFilesAction(update));
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length > 1) {
            group.add((AnAction)new ShowModulesAction(update));
            if (ModuleManager.getInstance((Project)this.myProject).hasModuleGroups()) {
                group.add((AnAction)new ShowModuleGroupsAction(update));
            }
            group.add((AnAction)this.createFlattenModulesAction(update));
        }
        group.add((AnAction)new FilterLegalsAction(update));
        if (dialectProviders.size() > 1) {
            group.add((AnAction)new ChooseScopeTypeAction(update));
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ScopeEditor", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    @NotNull
    private FlattenModulesToggleAction createFlattenModulesAction(Runnable update) {
        FlattenModulesToggleAction flattenModulesToggleAction = new FlattenModulesToggleAction(this.myProject, () -> DependencyUISettings.getInstance().UI_SHOW_MODULES, () -> !DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS, value -> {
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = value == false;
            update.run();
        });
        if (flattenModulesToggleAction == null) {
            ScopeEditorPanel.$$$reportNull$$$0(3);
        }
        return flattenModulesToggleAction;
    }

    private void rebuild(boolean updateText, @Nullable Runnable runnable2, boolean requestFocus, int delayMillis) {
        this.myUpdateAlarm.cancel(false);
        Runnable request = () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (updateText) {
                String text = this.myCurrentScope != null ? this.myCurrentScope.getText() : null;
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.myIsInUpdate = true;
                        this.myPatternField.setText(text);
                    }
                    finally {
                        this.myIsInUpdate = false;
                    }
                });
            }
            try {
                if (!this.myProject.isDisposed()) {
                    this.updateTreeModel(requestFocus);
                }
            }
            catch (ProcessCanceledException e) {
                return;
            }
            if (runnable2 != null) {
                runnable2.run();
            }
        });
        this.myUpdateAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(request, (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private void rebuild(boolean updateText) {
        this.rebuild(updateText, null, true, 300);
    }

    public void setHolder(NamedScopesHolder holder) {
        this.myHolder = holder;
    }

    private void initTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setLineStyleAngled();
        TreeUtil.installActions((JTree)tree);
        SmartExpander.installOn((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                ((PackageDependenciesNode)event.getPath().getLastPathComponent()).sortChildren();
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.include", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.includeSelected(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$12", "actionPerformed"));
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.include.recursively", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.includeSelected(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(ScopeEditorPanel.this.isButtonEnabled(true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$13";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.exclude", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.excludeSelected(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$14", "actionPerformed"));
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.exclude.recursively", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                ScopeEditorPanel.this.excludeSelected(true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(ScopeEditorPanel.this.isButtonEnabled(true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$15";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return actionGroup;
    }

    private void updateTreeModel(boolean requestFocus) throws ProcessCanceledException {
        PanelProgressIndicator progress = this.createProgressIndicator(requestFocus);
        progress.setBordersVisible(false);
        this.myCurrentProgress = progress;
        Runnable updateModel = () -> {
            ProcessCanceledException[] ex = new ProcessCanceledException[1];
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                try {
                    this.myTreeExpansionMonitor.freeze();
                    TreeModel model = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createTreeModel(this.myProject, this.myTreeMarker);
                    ((PackageDependenciesNode)model.getRoot()).sortChildren();
                    if (this.myErrorMessage == null) {
                        String message = IdeBundle.message((String)"label.scope.contains.files", (Object[])new Object[]{model.getMarkedFileCount(), model.getTotalFileCount()});
                        if ("file".equals(DependencyUISettings.getInstance().SCOPE_TYPE)) {
                            message = UIUtil.toHtml((String)(message + "<br/>(Non-project files are not shown)"));
                        }
                        this.myMatchingCountLabel.setText(message);
                        this.myMatchingCountLabel.setForeground(new JLabel().getForeground());
                    } else {
                        this.showErrorMessage();
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.myPackageTree.setModel((javax.swing.tree.TreeModel)model);
                        this.myTreeExpansionMonitor.restore();
                    });
                }
                catch (ProcessCanceledException e) {
                    ex[0] = e;
                }
                finally {
                    this.myCurrentProgress = null;
                    this.setToComponent(this.myMatchingCountLabel, requestFocus);
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        };
        ProgressManager.getInstance().runProcess(updateModel, (ProgressIndicator)progress);
    }

    private PanelProgressIndicator createProgressIndicator(boolean requestFocus) {
        return new MyPanelProgressIndicator(requestFocus);
    }

    public void cancelCurrentProgress() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    public void apply() throws ConfigurationException {
    }

    public PackageSet getCurrentScope() {
        return this.myCurrentScope;
    }

    public String getPatternText() {
        return this.myPatternField.getText();
    }

    public void reset(PackageSet packageSet, @Nullable Runnable runnable2) {
        this.myCurrentScope = packageSet;
        this.myPatternField.setText(this.myCurrentScope == null ? "" : this.myCurrentScope.getText());
        this.rebuild(false, runnable2, false, 0);
    }

    private void setToComponent(JComponent cmp, boolean requestFocus) {
        this.myMatchingCountPanel.removeAll();
        this.myMatchingCountPanel.add((Component)cmp, "Center");
        this.myMatchingCountPanel.revalidate();
        this.myMatchingCountPanel.repaint();
        if (requestFocus) {
            SwingUtilities.invokeLater(() -> this.myPatternField.getTextField().requestFocusInWindow());
        }
    }

    public void restoreCanceledProgress() {
        if (this.myIsInUpdate) {
            this.rebuild(false);
        }
    }

    public void clearCaches() {
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFlattenModulesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processComplementaryScope";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JLabel jLabel3;
        JPanel jPanel2;
        JLabel jLabel4;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel6 = new JPanel();
        jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 3, 1, 0, 3, 7, 3, new Dimension(-1, 150), null, null));
        this.myButtonsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 1, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 3, 0, 3, 1, 3, null, null, null));
        this.myTreeToolbar = jPanel4 = new JPanel();
        jPanel9.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 0, null, null, null));
        this.myMatchingCountPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMatchingCountLabel = jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setHorizontalTextPosition(4);
        jLabel4.setText("");
        jPanel3.add((Component)jLabel4, "Center");
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.scope.pattern"));
        jPanel8.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPositionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(false);
        jPanel8.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCaretPositionLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        ((Component)jLabel3).setVisible(false);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myPatternField;
        jPanel8.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLegendPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myRecursivelyIncluded = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("scope.editor.legend.recursively.included.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPartiallyIncluded = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("scope.editor.legend.partly.included.label"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    protected class MyPanelProgressIndicator
    extends PanelProgressIndicator {
        private final boolean myRequestFocus;

        public MyPanelProgressIndicator(final boolean requestFocus) {
            super((Consumer<? super JComponent>)new Consumer<JComponent>(){

                public void consume(JComponent component) {
                    ScopeEditorPanel.this.setToComponent(component, requestFocus);
                }
            });
            this.myRequestFocus = requestFocus;
        }

        @Override
        public void stop() {
            super.stop();
            ScopeEditorPanel.this.setToComponent(ScopeEditorPanel.this.myMatchingCountLabel, this.myRequestFocus);
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public String getText2() {
            return null;
        }
    }

    private final class FilterLegalsAction
    extends ToggleAction {
        private final Runnable myUpdate;

        FilterLegalsAction(Runnable update) {
            super(IdeBundle.message((String)"action.show.included.only", (Object[])new Object[0]), IdeBundle.message((String)"action.description.show.included.only", (Object[])new Object[0]), AllIcons.General.Filter);
            this.myUpdate = update;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(0);
            }
            return DependencyUISettings.getInstance().UI_FILTER_LEGALS;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_FILTER_LEGALS = flag;
            UIUtil.setEnabled((Component)ScopeEditorPanel.this.myLegendPanel, (!flag ? 1 : 0) != 0, (boolean)true);
            this.myUpdate.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$FilterLegalsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ChooseScopeTypeAction
    extends ComboBoxAction {
        private final Runnable myUpdate;

        ChooseScopeTypeAction(Runnable update) {
            this.myUpdate = update;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (final PatternDialectProvider provider : PatternDialectProvider.EP_NAME.getExtensionList()) {
                group.add(new AnAction(provider.getDisplayName()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DependencyUISettings.getInstance().SCOPE_TYPE = provider.getShortName();
                        myUpdate.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            PatternDialectProvider provider = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE);
            e.getPresentation().setText(provider.getDisplayName());
            e.getPresentation().setIcon(provider.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private static final Color WHOLE_INCLUDED = new JBColor(new Color(10, 119, 0), new Color(10863196));
        private static final Color PARTIAL_INCLUDED = new JBColor(new Color(0, 50, 160), DarculaColors.BLUE);

        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value instanceof PackageDependenciesNode) {
                PackageDependenciesNode node = (PackageDependenciesNode)value;
                this.setIcon(node.getIcon());
                this.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
                if (!(selected && hasFocus || !node.hasMarked() || DependencyUISettings.getInstance().UI_FILTER_LEGALS)) {
                    this.setForeground(node.hasUnmarked() ? PARTIAL_INCLUDED : WHOLE_INCLUDED);
                }
                this.append(node.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String locationString = node.getComment();
                if (!StringUtil.isEmpty((String)locationString)) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

