/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.startupWizard.StartupWizard;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.swing.JOptionPane;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

public class StartupUtil {
    public static final String NO_SPLASH = "nosplash";
    public static final String IDEA_CLASS_BEFORE_APPLICATION_PROPERTY = "idea.class.before.app";
    private static SocketLock ourSocketLock;

    private StartupUtil() {
    }

    public static synchronized void addExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        if (ourSocketLock != null) {
            ourSocketLock.setExternalInstanceListener(consumer);
        }
    }

    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    private static void runPreAppClass(Logger log2) {
        String classBeforeAppProperty = System.getProperty(IDEA_CLASS_BEFORE_APPLICATION_PROPERTY);
        if (classBeforeAppProperty != null) {
            try {
                Class<?> clazz = Class.forName(classBeforeAppProperty);
                Method invokeMethod = clazz.getDeclaredMethod("invoke", new Class[0]);
                invokeMethod.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                log2.error("Failed pre-app class init for class " + classBeforeAppProperty, (Throwable)ex);
            }
        }
    }

    static void prepareAndStart(String[] args, AppStarter appStarter) {
        ActivationResult result2;
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        boolean newConfigFolder = false;
        StartupUtil.checkHiDPISettings();
        if (!Main.isHeadless()) {
            AppUIUtil.updateFrameClass();
            boolean bl = newConfigFolder = !new File(PathManager.getConfigPath()).exists();
        }
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        System.setProperty("log4j.defaultInitOverride", "true");
        System.setProperty("com.jetbrains.suppressWindowRaise", "true");
        try {
            org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
            if (!root.getAllAppenders().hasMoreElements()) {
                root.setLevel(Level.WARN);
                root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!StartupUtil.checkSystemFolders()) {
            System.exit(5);
        }
        if ((result2 = StartupUtil.lockSystemFolders(args)) == ActivationResult.ACTIVATED) {
            System.exit(0);
        }
        if (result2 != ActivationResult.STARTED) {
            System.exit(6);
        }
        Logger.setFactory(LoggerFactory.class);
        Logger log2 = Logger.getInstance(Main.class);
        StartupUtil.startLogging(log2);
        StartupUtil.loadSystemLibraries(log2);
        StartupUtil.fixProcessEnvironment(log2);
        StartupUtil.runPreAppClass(log2);
        if (!Main.isHeadless()) {
            UIUtil.initDefaultLAF();
        }
        if (newConfigFolder) {
            appStarter.beforeImportConfigs();
            ConfigImportHelper.importConfigsTo(PathManager.getConfigPath(), log2);
        } else {
            StartupUtil.installPluginUpdates();
        }
        if (!Main.isHeadless()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
            AppUIUtil.registerBundledFonts();
            AppUIUtil.showUserAgreementAndConsentsIfNeeded();
        }
        appStarter.start(newConfigFolder);
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String message = "JDK classes seem to be not on " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            catch (LinkageError e) {
                String message = "Cannot load a JDK class: " + e.getMessage() + "\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.64bit.check")) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please use 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static synchronized boolean checkSystemFolders() {
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!StartupUtil.checkDirectory(configPath, "Config", "idea.config.path", true, false)) {
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!StartupUtil.checkDirectory(systemPath, "System", "idea.system.path", true, false)) {
            return false;
        }
        if (FileUtil.pathsEqual((String)configPath, (String)systemPath)) {
            String message = "Config and system paths seem to be equal.\n\nIf you have modified 'idea.config.path' or 'idea.system.path' properties,\nplease make sure they point to different directories, otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config or System Path", (String)message, (boolean)true);
            return false;
        }
        return StartupUtil.checkDirectory(PathManager.getLogPath(), "Log", "idea.log.path", false, false) && StartupUtil.checkDirectory(PathManager.getTempPath(), "Temp", "idea.system.path", false, SystemInfo.isXWindow);
    }

    private static boolean checkDirectory(String path, String kind, String property, boolean checkLock, boolean checkExec) {
        File directory = new File(path);
        if (!FileUtil.createDirectory((File)directory)) {
            String message = kind + " directory '" + path + "' is invalid.\n\nIf you have modified the '" + property + "' property, please make sure it is correct,\notherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid IDE Configuration", (String)message, (boolean)true);
            return false;
        }
        String details = null;
        File tempFile = new File(directory, "ij" + new Random().nextInt(Integer.MAX_VALUE) + ".tmp");
        OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
        if (checkLock) {
            try (FileChannel channel = FileChannel.open(tempFile.toPath(), options);
                 FileLock lock = channel.tryLock();){
                if (lock == null) {
                    details = "cannot exclusively lock temporary file";
                }
            }
            catch (IOException e) {
                details = "cannot create exclusive file lock (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ')';
            }
        } else if (checkExec) {
            try {
                Files.write(tempFile.toPath(), "#!/bin/sh\nexit 0".getBytes(StandardCharsets.UTF_8), options);
                if (!tempFile.setExecutable(true, true)) {
                    details = "cannot set executable permission";
                } else if (new ProcessBuilder(tempFile.getAbsolutePath()).start().waitFor() != 0) {
                    details = "cannot execute test script";
                }
            }
            catch (IOException | InterruptedException e) {
                details = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        FileUtil.delete((File)tempFile);
        if (details != null) {
            String message = kind + " path '" + path + "' cannot be used by the IDE.\n\nIf you have modified the '" + property + "' property, please make sure it is correct,\notherwise please re-install the IDE.\n\nReason: " + details;
            Main.showMessage((String)"Invalid IDE Configuration", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    @NotNull
    private static synchronized ActivationResult lockSystemFolders(String[] args) {
        SocketLock.ActivateStatus status;
        if (ourSocketLock != null) {
            throw new AssertionError();
        }
        ourSocketLock = new SocketLock(PathManager.getConfigPath(), PathManager.getSystemPath());
        try {
            status = ourSocketLock.lock(args);
        }
        catch (Exception e) {
            Main.showMessage((String)"Cannot Lock System Folders", (Throwable)e);
            ActivationResult activationResult = ActivationResult.FAILED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(0);
            }
            return activationResult;
        }
        if (status == SocketLock.ActivateStatus.NO_INSTANCE) {
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                Class<StartupUtil> clazz = StartupUtil.class;
                synchronized (StartupUtil.class) {
                    ourSocketLock.dispose();
                    ourSocketLock = null;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            });
            ActivationResult activationResult = ActivationResult.STARTED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(1);
            }
            return activationResult;
        }
        if (status == SocketLock.ActivateStatus.ACTIVATED) {
            System.out.println("Already running");
            ActivationResult activationResult = ActivationResult.ACTIVATED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(2);
            }
            return activationResult;
        }
        if (Main.isHeadless() || status == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
            String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
            Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
        }
        ActivationResult activationResult = ActivationResult.FAILED;
        if (activationResult == null) {
            StartupUtil.$$$reportNull$$$0(3);
        }
        return activationResult;
    }

    private static void fixProcessEnvironment(Logger log2) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log2.info("initializing environment");
        }
    }

    private static void loadSystemLibraries(Logger log2) {
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.mkdirs() && !ideTempDir.exists()) {
            throw new RuntimeException("Unable to create temp directory '" + ideTempDir + "'");
        }
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempDir.getPath());
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        JnaLoader.load((Logger)log2);
        if (SystemInfo.isWin2kOrNewer) {
            IdeaWin32.isAvailable();
        }
        if (SystemInfo.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempDir.getPath());
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempDir.getPath());
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", new File(PathManager.getLibPath(), "pty4j-native").getAbsolutePath());
        }
    }

    private static void startLogging(Logger log2) {
        String extDirs;
        ShutDownTracker.getInstance().registerShutdownTask(() -> log2.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        log2.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.US).format(appInfo.getBuildDate().getTime());
        log2.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log2.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log2.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log2.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log2.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : StringUtil.split((String)extDirs, (String)File.pathSeparator)) {
                Object[] content = new File(dir).list();
                if (content == null || content.length <= 0) continue;
                log2.info("ext: " + dir + ": " + Arrays.toString(content));
            }
        }
        log2.info("charsets: JNU=" + System.getProperty("sun.jnu.encoding") + " file=" + System.getProperty("file.encoding"));
    }

    private static void installPluginUpdates() {
        if (!Main.isCommandLine() && !ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            try {
                StartupActionScriptManager.executeActionScript();
            }
            catch (IOException e) {
                String message = "The IDE failed to install some plugins.\n\nMost probably, this happened because of a change in a serialization format.\nPlease try again, and if the problem persists, please report it\nto http://jb.gg/ide/critical-startup-errors\n\nThe cause: " + e.getMessage();
                Main.showMessage((String)"Plugin Installation Error", (String)message, (boolean)false);
            }
        }
    }

    static void runStartupWizard() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String stepsProviderName = appInfo.getCustomizeIDEWizardStepsProvider();
        if (stepsProviderName != null) {
            CustomizeIDEWizardStepsProvider provider;
            try {
                Class<?> providerClass = Class.forName(stepsProviderName);
                provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
            }
            catch (Throwable e) {
                Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
                return;
            }
            CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
            if (configProvider != null) {
                configProvider.beforeStartupWizard();
            }
            new CustomizeIDEWizardDialog(provider).show();
            PluginManagerCore.invalidatePlugins();
            if (configProvider != null) {
                configProvider.startupWizardFinished();
            }
            return;
        }
        List<ApplicationInfoEx.PluginChooserPage> pages = appInfo.getPluginChooserPages();
        if (!pages.isEmpty()) {
            new StartupWizard(pages).show();
            PluginManagerCore.invalidatePlugins();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/StartupUtil", "lockSystemFolders"));
    }

    private static enum ActivationResult {
        STARTED,
        ACTIVATED,
        FAILED;

    }

    @FunctionalInterface
    static interface AppStarter {
        public void start(boolean var1);

        default public void beforeImportConfigs() {
        }
    }
}

