/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.FieldAccessor;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.IconsLoadTime");
    private static final boolean IS_INTERNAL_MODE = Boolean.valueOf(System.getProperty("idea.is.internal"));
    private static final int STATS_LIMIT = 10000;
    private static final int FIXED_SCOPE = 100;
    private static final List<Integer> statsSVG = IS_INTERNAL_MODE ? Collections.synchronizedList(new LinkedList()) : null;
    private static final List<Integer> statsPNG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            IconsLoadTime.$$$reportNull$$$0(0);
        }
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, ImageLoader.ImageDesc.Type.IMG);
        IconsLoadTime.log(measureStartupLoad, ImageLoader.ImageDesc.Type.SVG);
    }

    private static void log(boolean measureStartupLoad, @NotNull ImageLoader.ImageDesc.Type type) {
        StatData data;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(1);
        }
        if ((data = IconsLoadTime.getStatData(measureStartupLoad, type)) != null) {
            LOG.info(data.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, @NotNull ImageLoader.ImageDesc.Type type) {
        List<Integer> stats;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(2);
        }
        if ((stats = IconsLoadTime.getStats(type)).isEmpty()) {
            return null;
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            int size = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size;
            int median = size % 2 == 0 ? stats.get(size / 2 - 1) + stats.get(size / 2) : stats.get(size / 2);
            return new StatData(type, measureStartupLoad, sum, average, median, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image measure(@NotNull ImageLoader.LoadFunction func, @NotNull ImageLoader.ImageDesc.Type type) throws IOException {
        List<Integer> stats;
        if (func == null) {
            IconsLoadTime.$$$reportNull$$$0(3);
        }
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(4);
        }
        boolean measure = (stats = IconsLoadTime.getStats(type)).size() < 10000;
        long t = measure ? System.nanoTime() : 0L;
        Image img = func.load(null, type);
        if (measure) {
            int size;
            List<Integer> list2 = stats;
            synchronized (list2) {
                stats.add((int)(System.nanoTime() - t));
                size = stats.size();
            }
            if (size == 100) {
                IconsLoadTime.log(false, type);
            }
        }
        return img;
    }

    @NotNull
    private static List<Integer> getStats(@NotNull ImageLoader.ImageDesc.Type type) {
        List<Integer> stats;
        if (type == null) {
            IconsLoadTime.$$$reportNull$$$0(5);
        }
        List<Integer> list2 = stats = type == ImageLoader.ImageDesc.Type.SVG ? statsSVG : statsPNG;
        if (stats == null) {
            stats = new ArrayList<Integer>();
        }
        List<Integer> list3 = stats;
        if (list3 == null) {
            IconsLoadTime.$$$reportNull$$$0(6);
        }
        return list3;
    }

    static {
        List<Object> list2 = statsPNG = IS_INTERNAL_MODE ? Collections.synchronizedList(new LinkedList()) : null;
        if (IS_INTERNAL_MODE) {
            new FieldAccessor(ImageLoader.class, "measureLoad").set(null, (func, type) -> IconsLoadTime.measure(Objects.requireNonNull(func), Objects.requireNonNull(type)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/IconsLoadTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/IconsLoadTime";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStatData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStats";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StartupLoadTime
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                StartupLoadTime.$$$reportNull$$$0(0);
            }
            if (IS_INTERNAL_MODE) {
                IconsLoadTime.log(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/IconsLoadTime$StartupLoadTime", "runActivity"));
        }
    }

    public static class StatData {
        public final ImageLoader.ImageDesc.Type type;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(@NotNull ImageLoader.ImageDesc.Type type, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            if (type == null) {
                StatData.$$$reportNull$$$0(0);
            }
            this.type = type;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return this.type + " load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + "; number of icons: " + this.count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/internal/IconsLoadTime$StatData", "<init>"));
        }
    }
}

