/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ActionsCollectorImpl
extends ActionsCollector
implements PersistentStateComponent<ActionsCollector.State> {
    private static final String GROUP = "actions";
    private static final String DEFAULT_ID = "third.party";
    private static final Set<String> ourCustomActionWhitelist = ContainerUtil.newHashSet((Object[])new String[]{"tooltip.actions.execute", "tooltip.actions.show.all", "tooltip.actions.show.description.gear", "tooltip.actions.show.description.shortcut", "tooltip.actions.show.description.morelink", "Ics.action.MergeSettings.text", "Ics.action.MergeSettings.text", "Ics.action.ResetToMySettings.text", "Reload Classes", "Progress Paused", "Progress Resumed", "DialogCancelAction", "DialogOkAction", "DoubleShortcut"});
    private final ActionsCollector.State myState = new ActionsCollector.State();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourCustomActionWhitelist.contains(actionId) ? actionId : DEFAULT_ID;
        FeatureUsageData data = new FeatureUsageData().addOS();
        if (event instanceof KeyEvent) {
            data.addInputEvent((KeyEvent)event);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, recorded, data);
    }

    public void record(@Nullable Project project, @Nullable AnAction action, @Nullable AnActionEvent event) {
        if (action == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action.getClass());
        FeatureUsageData data = new FeatureUsageData().addOS().addProject(project).addPluginInfo(info);
        if (event != null) {
            data.addInputEvent(event).addPlace(event.getPlace()).addData("context_menu", event.isFromContextMenu());
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, ActionsCollectorImpl.toReportedId(info, action, data), data);
    }

    @NotNull
    public static String toReportedId(@NotNull PluginInfo info, @NotNull AnAction action, @NotNull FeatureUsageData data) {
        if (info == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        if (action == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        if (data == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        if (action instanceof ActionWithDelegate) {
            String parent = ActionsCollectorImpl.getActionId(info, action, true);
            data.addData("parent", parent);
            Object delegate = ((ActionWithDelegate)action).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            String string = delegateInfo.isDevelopedByJetBrains() ? delegate.getClass().getName() : DEFAULT_ID;
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = ActionsCollectorImpl.getActionId(info, action, false);
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getActionId(@NotNull PluginInfo info, @NotNull AnAction action, boolean simpleName) {
        String actionId;
        if (info == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
        if (action == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(7);
        }
        if (!info.isDevelopedByJetBrains()) {
            if (DEFAULT_ID == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(8);
            }
            return DEFAULT_ID;
        }
        String string = actionId = action.isGlobal() ? ActionManager.getInstance().getId(action) : null;
        if (actionId != null) {
            String string2 = ConvertUsagesUtil.escapeDescriptorName(actionId);
            if (string2 == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(9);
            }
            return string2;
        }
        String string3 = simpleName ? action.getClass().getSimpleName() : action.getClass().getName();
        if (string3 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(10);
        }
        return string3;
    }

    @Nullable
    public ActionsCollector.State getState() {
        return this.myState;
    }

    public void loadState(@NotNull ActionsCollector.State state) {
        if (state == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedId";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toReportedId";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

