/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventGroup;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "session", "", "build", "bucket", "eventTime", "", "groupId", "groupVersion", "recorderVersion", "action", "Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/LogEventAction;)V", "getBucket", "()Ljava/lang/String;", "getBuild", "event", "getEvent", "()Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "group", "Lcom/intellij/internal/statistic/eventLog/LogEventGroup;", "getGroup", "()Lcom/intellij/internal/statistic/eventLog/LogEventGroup;", "getRecorderVersion", "getSession", "time", "getTime", "()J", "equals", "", "other", "hashCode", "", "shouldMerge", "next", "intellij.platform.ide.impl"})
public class LogEvent {
    @NotNull
    private final String recorderVersion;
    @NotNull
    private final String session;
    @NotNull
    private final String build;
    @NotNull
    private final String bucket;
    private final long time;
    @NotNull
    private final LogEventGroup group;
    @NotNull
    private final LogEventAction event;

    @NotNull
    public final String getRecorderVersion() {
        return this.recorderVersion;
    }

    @NotNull
    public final String getSession() {
        return this.session;
    }

    @NotNull
    public final String getBuild() {
        return this.build;
    }

    @NotNull
    public final String getBucket() {
        return this.bucket;
    }

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public final LogEventGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final LogEventAction getEvent() {
        return this.event;
    }

    public final boolean shouldMerge(@NotNull LogEvent next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (Intrinsics.areEqual((Object)this.session, (Object)next.session) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.bucket, (Object)next.bucket) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.build, (Object)next.build) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorderVersion, (Object)next.recorderVersion) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.group.getId(), (Object)next.group.getId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.group.getVersion(), (Object)next.group.getVersion()) ^ true) {
            return false;
        }
        return this.event.shouldMerge(next.event);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEvent");
        }
        LogEvent cfr_ignored_0 = (LogEvent)object2;
        if (Intrinsics.areEqual((Object)this.session, (Object)((LogEvent)other).session) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.bucket, (Object)((LogEvent)other).bucket) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.build, (Object)((LogEvent)other).build) ^ true) {
            return false;
        }
        if (this.time != ((LogEvent)other).time) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.group, (Object)((LogEvent)other).group) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorderVersion, (Object)((LogEvent)other).recorderVersion) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.event, (Object)((LogEvent)other).event) ^ true);
    }

    public int hashCode() {
        int result2 = this.session.hashCode();
        result2 = 31 * result2 + this.bucket.hashCode();
        result2 = 31 * result2 + this.build.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.time);
        result2 = 31 * result2 + this.group.hashCode();
        result2 = 31 * result2 + this.recorderVersion.hashCode();
        result2 = 31 * result2 + this.event.hashCode();
        return result2;
    }

    public LogEvent(@NotNull String session2, @NotNull String build2, @NotNull String bucket, long eventTime, @NotNull String groupId, @NotNull String groupVersion, @NotNull String recorderVersion, @NotNull LogEventAction action) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)groupVersion, (String)"groupVersion");
        Intrinsics.checkParameterIsNotNull((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.recorderVersion = LogEventsKt.access$escape(recorderVersion);
        this.session = LogEventsKt.access$escape(session2);
        this.build = LogEventsKt.access$escape(build2);
        this.bucket = LogEventsKt.access$escape(bucket);
        this.time = eventTime;
        this.group = new LogEventGroup(LogEventsKt.access$escape(groupId), LogEventsKt.access$escape(groupVersion));
        this.event = action;
    }
}

