/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUSWhitelist {
    private Map<String, List<VersionRange>> myGroups;

    public FUSWhitelist() {
    }

    private FUSWhitelist(@NotNull Map<String, List<VersionRange>> groups) {
        if (groups == null) {
            FUSWhitelist.$$$reportNull$$$0(0);
        }
        this.myGroups = groups;
    }

    @NotNull
    public static FUSWhitelist create(@NotNull Map<String, List<VersionRange>> groupsToVersion) {
        if (groupsToVersion == null) {
            FUSWhitelist.$$$reportNull$$$0(1);
        }
        FUSWhitelist fUSWhitelist = new FUSWhitelist(groupsToVersion);
        if (fUSWhitelist == null) {
            FUSWhitelist.$$$reportNull$$$0(2);
        }
        return fUSWhitelist;
    }

    @NotNull
    public static FUSWhitelist empty() {
        FUSWhitelist fUSWhitelist = new FUSWhitelist(Collections.emptyMap());
        if (fUSWhitelist == null) {
            FUSWhitelist.$$$reportNull$$$0(3);
        }
        return fUSWhitelist;
    }

    @XMap(propertyElementName="groups", keyAttributeName="id", entryTagName="group")
    public Map<String, List<VersionRange>> getGroups() {
        return this.myGroups;
    }

    public void setGroups(Map<String, List<VersionRange>> groups) {
        this.myGroups = groups;
    }

    public boolean accepts(@NotNull String groupId, @Nullable String version2) {
        int parsed;
        if (groupId == null) {
            FUSWhitelist.$$$reportNull$$$0(4);
        }
        if ((parsed = FUSWhitelist.tryToParse(version2, -1)) < 0) {
            return false;
        }
        return this.accepts(groupId, parsed);
    }

    public boolean accepts(@NotNull String groupId, int version2) {
        if (groupId == null) {
            FUSWhitelist.$$$reportNull$$$0(5);
        }
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        List<VersionRange> ranges = this.myGroups.get(groupId);
        return ranges.isEmpty() || ContainerUtil.find(ranges, range2 -> range2.contains(version2)) != null;
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value, int defaultValue) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FUSWhitelist whitelist = (FUSWhitelist)o;
        return Objects.equals(this.myGroups, whitelist.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupsToVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUSWhitelist";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="version")
    public static class VersionRange {
        private int myFrom;
        private int myTo;

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            VersionRange range2 = new VersionRange();
            range2.setFrom(from == null ? 0 : FUSWhitelist.tryToParse(from, Integer.MAX_VALUE));
            range2.setTo(to == null ? Integer.MAX_VALUE : FUSWhitelist.tryToParse(to, 0));
            VersionRange versionRange = range2;
            if (versionRange == null) {
                VersionRange.$$$reportNull$$$0(0);
            }
            return versionRange;
        }

        @Attribute(value="from")
        public int getFrom() {
            return this.myFrom;
        }

        public void setFrom(int from) {
            this.myFrom = from;
        }

        @Attribute(value="to")
        public int getTo() {
            return this.myTo;
        }

        public void setTo(int to) {
            this.myTo = to;
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range2 = (VersionRange)o;
            return this.myFrom == range2.myFrom && this.myTo == range2.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/FUSWhitelist$VersionRange", "create"));
        }
    }
}

