/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> BUNDLED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && descriptor.isBundled() && PluginManagerMain.isDevelopedByJetBrains(descriptor);
    };
    private static final Predicate<ScopeToolState> LISTED = state -> {
        IdeaPluginDescriptor descriptor = AbstractToolsUsagesCollector.getIdeaPluginDescriptor(state);
        return descriptor != null && !descriptor.isBundled() && StatisticsUtilKt.isSafeToReportFrom(descriptor);
    };
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();

    private static IdeaPluginDescriptor getIdeaPluginDescriptor(ScopeToolState state) {
        InspectionEP extension = state.getTool().getExtension();
        return extension != null ? (IdeaPluginDescriptor)ObjectUtils.tryCast((Object)extension.getPluginDescriptor(), IdeaPluginDescriptor.class) : null;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(0);
        }
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project).getCurrentProfile().getAllTools();
        Set<UsageDescriptor> set2 = this.filter(tools.stream()).map(ScopeToolState::getTool).map(tool -> new UsageDescriptor(tool.getID(), this.getInspectionToolData((InspectionToolWrapper)tool))).collect(Collectors.toSet());
        if (set2 == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    protected FeatureUsageData getInspectionToolData(InspectionToolWrapper tool) {
        FeatureUsageData data = new FeatureUsageData();
        String language = tool.getLanguage();
        if (StringUtil.isNotEmpty((String)language)) {
            data.addData("lang", language);
        }
        FeatureUsageData featureUsageData = data;
        if (featureUsageData == null) {
            AbstractToolsUsagesCollector.$$$reportNull$$$0(2);
        }
        return featureUsageData;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @NotNull
    protected abstract Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DisabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("disabled.listed.tools" == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "disabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(LISTED);
            if (stream == null) {
                DisabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DisabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("disabled.bundled.tools" == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "disabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(DISABLED).filter(BUNDLED);
            if (stream == null) {
                DisabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$DisabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledListedToolsUsagesCollector
    extends AbstractListedToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("enabled.listed.tools" == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "enabled.listed.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(LISTED);
            if (stream == null) {
                EnabledListedToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledListedToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnabledBundledToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("enabled.bundled.tools" == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return "enabled.bundled.tools";
        }

        @Override
        @NotNull
        protected Stream<ScopeToolState> filter(@NotNull Stream<ScopeToolState> tools) {
            if (tools == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(1);
            }
            Stream<ScopeToolState> stream = tools.filter(ENABLED).filter(BUNDLED);
            if (stream == null) {
                EnabledBundledToolsUsagesCollector.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$EnabledBundledToolsUsagesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class AbstractListedToolsUsagesCollector
    extends AbstractToolsUsagesCollector {
        protected AbstractListedToolsUsagesCollector() {
        }

        @Override
        @NotNull
        protected FeatureUsageData getInspectionToolData(InspectionToolWrapper tool) {
            FeatureUsageData data = super.getInspectionToolData(tool);
            PluginId pluginId = tool.getExtension().getPluginId();
            if (pluginId != null) {
                data.addData("plugin_id", pluginId.getIdString());
            }
            FeatureUsageData featureUsageData = data;
            if (featureUsageData == null) {
                AbstractListedToolsUsagesCollector.$$$reportNull$$$0(0);
            }
            return featureUsageData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/tools/AbstractToolsUsagesCollector$AbstractListedToolsUsagesCollector", "getInspectionToolData"));
        }
    }
}

