/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.async;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.async.AppUIExecutorEx;
import com.intellij.openapi.application.async.AppUIExecutorImpl;
import com.intellij.openapi.application.async.AsyncExecution;
import com.intellij.openapi.application.async.BaseAsyncExecutionSupport;
import com.intellij.openapi.application.async.ExpirableAsyncExecutionSupport;
import com.intellij.openapi.application.async.InSmartMode;
import com.intellij.openapi.application.async.RescheduleAttemptLimitAwareDispatcher;
import com.intellij.openapi.application.async.WithDocumentsCommitted;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B+\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\bH\u0014J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/application/async/AppUIExecutorImpl;", "Lcom/intellij/openapi/application/async/ExpirableAsyncExecutionSupport;", "Lcom/intellij/openapi/application/async/AppUIExecutorEx;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/intellij/openapi/application/ModalityState;)V", "dispatchers", "", "Lkotlinx/coroutines/CoroutineDispatcher;", "expirableHandles", "", "Lcom/intellij/openapi/application/async/ExpirableAsyncExecutionSupport$Expiration;", "(Lcom/intellij/openapi/application/ModalityState;[Lkotlinx/coroutines/CoroutineDispatcher;Ljava/util/Set;)V", "cloneWith", "expirationSet", "([Lkotlinx/coroutines/CoroutineDispatcher;Ljava/util/Set;)Lcom/intellij/openapi/application/async/AppUIExecutorEx;", "composeDispatchers", "dispatchLater", "", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "inSmartMode", "Lcom/intellij/openapi/application/AppUIExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "inTransaction", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "inUndoTransparentAction", "inWriteAction", "later", "withDocumentsCommitted", "intellij.platform.ide.impl"})
public final class AppUIExecutorImpl
extends ExpirableAsyncExecutionSupport<AppUIExecutorEx>
implements AppUIExecutorEx {
    private final ModalityState modality;

    @Override
    @NotNull
    protected CoroutineDispatcher composeDispatchers() {
        CoroutineDispatcher coroutineDispatcher = (CoroutineDispatcher)ArraysKt.singleOrNull((Object[])this.getDispatchers());
        if (coroutineDispatcher == null) {
            coroutineDispatcher = new RescheduleAttemptLimitAwareDispatcher(this.getDispatchers(), (Function1)new Function1<Runnable, Unit>(this){

                public final void invoke(@NotNull Runnable p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    ((AppUIExecutorImpl)this.receiver).dispatchLater(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(AppUIExecutorImpl.class);
                }

                public final String getName() {
                    return "dispatchLater";
                }

                public final String getSignature() {
                    return "dispatchLater(Ljava/lang/Runnable;)V";
                }
            }, 0, 4, null);
        }
        return coroutineDispatcher;
    }

    @Override
    protected void dispatchLater(@NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        ApplicationManager.getApplication().invokeLater(block, this.modality);
    }

    @Override
    @NotNull
    protected AppUIExecutorEx cloneWith(@NotNull CoroutineDispatcher[] dispatchers, @NotNull Set<? extends ExpirableAsyncExecutionSupport.Expiration> expirationSet) {
        Intrinsics.checkParameterIsNotNull((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkParameterIsNotNull(expirationSet, (String)"expirationSet");
        return new AppUIExecutorImpl(this.modality, dispatchers, expirationSet);
    }

    @NotNull
    public AppUIExecutor later() {
        int n;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
            n = ideEventQueue.getEventCount();
        } else {
            n = -1;
        }
        int edtEventCount = n;
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(this, edtEventCount){
            private volatile boolean usedOnce;
            final /* synthetic */ AppUIExecutorImpl this$0;
            final /* synthetic */ int $edtEventCount;

            public final boolean getUsedOnce() {
                return this.usedOnce;
            }

            public final void setUsedOnce(boolean bl) {
                this.usedOnce = bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isCorrectContext() {
                switch (this.$edtEventCount) {
                    case -1: {
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                        boolean bl = application.isDispatchThread();
                        return bl;
                    }
                    default: {
                        if (this.usedOnce) return true;
                        IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
                        if (this.$edtEventCount == ideEventQueue.getEventCount()) return false;
                        return true;
                    }
                }
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().invokeLater(new Runnable(this, runnable2){
                    final /* synthetic */ later.1 this$0;
                    final /* synthetic */ Runnable $runnable;

                    public final void run() {
                        this.this$0.setUsedOnce(true);
                        this.$runnable.run();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runnable = runnable2;
                    }
                }, AppUIExecutorImpl.access$getModality$p(this.this$0));
            }

            @NotNull
            public String toString() {
                return "later";
            }
            {
                this.this$0 = $outer;
                this.$edtEventCount = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public AppUIExecutor withDocumentsCommitted(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new WithDocumentsCommitted(project, this.modality), (Disposable)project);
    }

    @NotNull
    public AppUIExecutor inSmartMode(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new InSmartMode(project), (Disposable)project);
    }

    @NotNull
    public AppUIExecutor inTransaction(@NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
        TransactionId id = transactionGuard.getContextTransaction();
        return ((AppUIExecutorEx)this.withConstraint(new AsyncExecution.SimpleContextConstraint(id){
            final /* synthetic */ TransactionId $id;

            public boolean isCorrectContext() {
                TransactionGuard transactionGuard = TransactionGuard.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
                return transactionGuard.getContextTransaction() != null;
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), this.$id, runnable2);
            }

            @NotNull
            public String toString() {
                return "inTransaction";
            }
            {
                this.$id = $captured_local_variable$0;
            }
        })).expireWith(parentDisposable);
    }

    @Override
    @NotNull
    public AppUIExecutor inUndoTransparentAction() {
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(){

            public boolean isCorrectContext() {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
                return commandProcessor.isUndoTransparentActionInProgress();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                CommandProcessor.getInstance().runUndoTransparentAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inUndoTransparentAction";
            }
        });
    }

    @Override
    @NotNull
    public AppUIExecutor inWriteAction() {
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(){

            public boolean isCorrectContext() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isWriteAccessAllowed();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inWriteAction";
            }
        });
    }

    private AppUIExecutorImpl(ModalityState modality, CoroutineDispatcher[] dispatchers, Set<? extends ExpirableAsyncExecutionSupport.Expiration> expirableHandles) {
        super(dispatchers, expirableHandles);
        this.modality = modality;
    }

    public AppUIExecutorImpl(final @NotNull ModalityState modality) {
        Intrinsics.checkParameterIsNotNull((Object)modality, (String)"modality");
        this(modality, new CoroutineDispatcher[]{new BaseAsyncExecutionSupport.SimpleConstraintDispatcher(new AsyncExecution.SimpleContextConstraint(){

            @Override
            public boolean isCorrectContext() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isDispatchThread() && !ModalityState.current().dominates(modality);
            }

            @Override
            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().invokeLater(runnable2, modality);
            }

            @Override
            @NotNull
            public String toString() {
                return "onUiThread(" + modality + ')';
            }
        })}, SetsKt.emptySet());
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        AppUIExecutorEx.DefaultImpls.execute(this, command);
    }

    @Override
    @NotNull
    public CancellablePromise<?> submit(@NotNull Runnable task2) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        return AppUIExecutorEx.DefaultImpls.submit((AppUIExecutorEx)this, task2);
    }

    @Override
    @NotNull
    public <T> CancellablePromise<T> submit(@NotNull Callable<T> task2) {
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        return AppUIExecutorEx.DefaultImpls.submit((AppUIExecutorEx)this, task2);
    }

    public static final /* synthetic */ ModalityState access$getModality$p(AppUIExecutorImpl $this) {
        return $this.modality;
    }
}

