/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffTool;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import org.jetbrains.annotations.NotNull;

public class DiffUsageTriggerCollector {
    private static void trigger(@NotNull String feature) {
        if (feature == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        FUCounterUsageLogger.getInstance().logEvent("vcs.diff.trigger", feature);
    }

    public static void trigger(@NotNull String feature, @NotNull Enum value) {
        if (feature == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        if (value == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        DiffUsageTriggerCollector.trigger(feature + "." + value.name());
    }

    public static void trigger(@NotNull String feature, @NotNull DiffTool diffTool) {
        if (feature == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        if (diffTool == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        DiffUsageTriggerCollector.trigger(feature + "." + DiffUsageTriggerCollector.getDiffToolName(diffTool));
    }

    @NotNull
    private static String getDiffToolName(@NotNull DiffTool diffTool) {
        PluginInfo pluginInfo;
        if (diffTool == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        if ((pluginInfo = PluginInfoDetectorKt.getPluginInfo(diffTool.getClass())).isDevelopedByJetBrains()) {
            String string = diffTool.getName();
            if (string == null) {
                DiffUsageTriggerCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (pluginInfo.isSafeToReport()) {
            String string = "third.party." + pluginInfo.getId();
            if (string == null) {
                DiffUsageTriggerCollector.$$$reportNull$$$0(7);
            }
            return string;
        }
        if ("third.party.other" == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(8);
        }
        return "third.party.other";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffTool";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/DiffUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/DiffUsageTriggerCollector";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffToolName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDiffToolName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

