/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorLastActionTrackerImpl
implements AnActionListener,
EditorMouseListener,
Disposable,
EditorLastActionTracker,
BaseComponent {
    private final ActionManager myActionManager;
    private final EditorEventMulticaster myEditorEventMulticaster;
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    EditorLastActionTrackerImpl(ActionManager actionManager, EditorFactory editorFactory) {
        this.myActionManager = actionManager;
        this.myEditorEventMulticaster = editorFactory.getEventMulticaster();
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorImpl killedEditor = (EditorImpl)event.getEditor();
                if (EditorLastActionTrackerImpl.is(EditorLastActionTrackerImpl.this.myCurrentEditor, killedEditor)) {
                    EditorLastActionTrackerImpl.this.myCurrentEditor = null;
                }
                if (EditorLastActionTrackerImpl.is(EditorLastActionTrackerImpl.this.myLastEditor, killedEditor)) {
                    EditorLastActionTrackerImpl.this.myLastEditor = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorLastActionTrackerImpl$1", "editorReleased"));
            }
        }, (Disposable)this);
    }

    private static boolean is(Editor currentEditor, EditorImpl killedEditor) {
        return currentEditor == killedEditor || currentEditor instanceof EditorWindow && ((EditorWindow)currentEditor).getDelegate() == killedEditor;
    }

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(TOPIC, (Object)this);
        this.myEditorEventMulticaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(1);
        }
        if (event == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(2);
        }
        this.myCurrentEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (this.myCurrentEditor != this.myLastEditor) {
            this.resetLastAction();
        }
    }

    public void afterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(4);
        }
        if (event == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(5);
        }
        this.myLastActionId = this.getActionId(action);
        this.myLastEditor = this.myCurrentEditor;
        this.myCurrentEditor = null;
    }

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(6);
        }
        this.resetLastAction();
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(7);
        }
        this.resetLastAction();
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(8);
        }
        this.resetLastAction();
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorLastActionTrackerImpl.$$$reportNull$$$0(9);
        }
        this.resetLastAction();
    }

    private String getActionId(AnAction action) {
        return action instanceof ActionStub ? ((ActionStub)action).getId() : this.myActionManager.getId(action);
    }

    private void resetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLastActionTrackerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEditorTyping";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mousePressed";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseReleased";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

