/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorProviderManager", storages={@Storage(value="fileEditorProviderManager.xml", roamingType=RoamingType.DISABLED)})
public final class FileEditorProviderManagerImpl
extends FileEditorProviderManager
implements PersistentStateComponent<FileEditorProviderManagerImpl> {
    private final Map<String, String> mySelectedProviders = new HashMap<String, String>();

    @Override
    @NotNull
    public FileEditorProvider[] getProviders(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<FileEditorProvider> sharedProviders = new ArrayList<FileEditorProvider>();
        boolean doNotShowTextEditor = false;
        for (FileEditorProvider provider2 : FileEditorProvider.EP_FILE_EDITOR_PROVIDER.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> {
                if (DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)provider2)) {
                    return false;
                }
                return provider2.accept(project, file2);
            })).booleanValue()) continue;
            sharedProviders.add(provider2);
            doNotShowTextEditor |= provider2.getPolicy() == FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        }
        if (doNotShowTextEditor) {
            ContainerUtil.retainAll(sharedProviders, provider -> !(provider instanceof TextEditorProvider));
        }
        sharedProviders.sort(MyComparator.ourInstance);
        FileEditorProvider[] fileEditorProviderArray = sharedProviders.toArray(new FileEditorProvider[0]);
        if (fileEditorProviderArray == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(2);
        }
        return fileEditorProviderArray;
    }

    @Override
    @Nullable
    public FileEditorProvider getProvider(@NotNull String editorTypeId) {
        if (editorTypeId == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(3);
        }
        for (FileEditorProvider provider : FileEditorProvider.EP_FILE_EDITOR_PROVIDER.getExtensionList()) {
            if (!provider.getEditorTypeId().equals(editorTypeId)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public FileEditorProviderManagerImpl getState() {
        FileEditorProviderManagerImpl fileEditorProviderManagerImpl = this;
        if (fileEditorProviderManagerImpl == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(4);
        }
        return fileEditorProviderManagerImpl;
    }

    public void loadState(@NotNull FileEditorProviderManagerImpl state) {
        if (state == null) {
            FileEditorProviderManagerImpl.$$$reportNull$$$0(5);
        }
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(state.mySelectedProviders);
    }

    void providerSelected(EditorComposite composite) {
        if (!(composite instanceof EditorWithProviderComposite)) {
            return;
        }
        FileEditorProvider[] providers = ((EditorWithProviderComposite)composite).getProviders();
        if (providers.length < 2) {
            return;
        }
        this.mySelectedProviders.put(FileEditorProviderManagerImpl.computeKey(providers), ((FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond()).getEditorTypeId());
    }

    private static String computeKey(FileEditorProvider[] providers) {
        return StringUtil.join((Collection)ContainerUtil.map((Object[])providers, FileEditorProvider::getEditorTypeId), (String)",");
    }

    @Nullable
    FileEditorProvider getSelectedFileEditorProvider(EditorHistoryManager editorHistoryManager, VirtualFile file2, FileEditorProvider[] providers) {
        FileEditorProvider provider = editorHistoryManager.getSelectedProvider(file2);
        if (provider != null || providers.length < 2) {
            return provider;
        }
        String id = this.mySelectedProviders.get(FileEditorProviderManagerImpl.computeKey(providers));
        return id == null ? null : this.getProvider(id);
    }

    @MapAnnotation
    public Map<String, String> getSelectedProviders() {
        return this.mySelectedProviders;
    }

    public void setSelectedProviders(Map<String, String> selectedProviders) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(selectedProviders);
    }

    public void clearSelectedProviders() {
        this.mySelectedProviders.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTypeId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyComparator
    implements Comparator<FileEditorProvider> {
        public static final MyComparator ourInstance = new MyComparator();

        private MyComparator() {
        }

        private static double getWeight(FileEditorProvider provider) {
            return provider instanceof WeighedFileEditorProvider ? ((WeighedFileEditorProvider)provider).getWeight() : Double.MAX_VALUE;
        }

        @Override
        public int compare(FileEditorProvider provider1, FileEditorProvider provider2) {
            int i2;
            int i1 = provider1.getPolicy().ordinal();
            if (i1 != (i2 = provider2.getPolicy().ordinal())) {
                return i1 - i2;
            }
            double value = MyComparator.getWeight(provider1) - MyComparator.getWeight(provider2);
            return value > 0.0 ? 1 : (value < 0.0 ? -1 : 0);
        }
    }
}

