/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.ui.MessageType;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSelector
extends SimpleSchemesPanel<KeymapScheme> {
    private KeymapSchemeManager manager;
    private final Consumer<? super Keymap> consumer;
    private String messageReplacement;
    private boolean messageShown;
    private boolean internal;

    KeymapSelector(Consumer<? super Keymap> consumer) {
        super(0);
        this.consumer = consumer;
    }

    @NotNull
    public KeymapSchemeManager getManager() {
        if (this.manager == null) {
            this.manager = new KeymapSchemeManager(this);
        }
        KeymapSchemeManager keymapSchemeManager = this.manager;
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(0);
        }
        return keymapSchemeManager;
    }

    @Override
    @NotNull
    public SchemesModel<KeymapScheme> getModel() {
        KeymapSchemeManager keymapSchemeManager = this.getManager();
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(1);
        }
        return keymapSchemeManager;
    }

    @Override
    @Nullable
    protected String getComboBoxLabel() {
        return null;
    }

    @Override
    @NotNull
    protected String getSchemeTypeName() {
        if ("Keymap" == null) {
            KeymapSelector.$$$reportNull$$$0(2);
        }
        return "Keymap";
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<KeymapScheme> createSchemeActions() {
        KeymapSchemeManager keymapSchemeManager = this.getManager();
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(3);
        }
        return keymapSchemeManager;
    }

    @Override
    protected int getIndent(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSelector.$$$reportNull$$$0(4);
        }
        return scheme2.isMutable() ? 1 : 0;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    public void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        if (messageType == null) {
            KeymapSelector.$$$reportNull$$$0(5);
        }
        this.messageShown = true;
        super.showMessage(message, messageType);
    }

    @Override
    public void clearMessage() {
        this.messageShown = false;
        super.showMessage(this.messageReplacement, MessageType.INFO);
    }

    void notifyConsumer(KeymapScheme scheme2) {
        if (this.internal) {
            return;
        }
        Keymap keymap = scheme2 == null ? null : scheme2.getParent();
        String string = this.messageReplacement = keymap == null ? null : KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.messageShown) {
            this.clearMessage();
        }
        this.consumer.accept(scheme2 == null ? null : scheme2.getCurrent());
    }

    void selectKeymap(KeymapScheme scheme2, boolean reset) {
        try {
            this.internal = true;
            if (reset) {
                this.resetSchemes(this.getManager().getSchemes());
            }
            if (scheme2 != null) {
                this.selectScheme(scheme2);
            }
        }
        finally {
            this.internal = false;
            this.notifyConsumer((KeymapScheme)this.getSelectedScheme());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSchemeActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapSelector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

