/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable parentDisposable) {
        if (progress == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$1", "beforeWriteActionStart"));
            }
        }, parentDisposable);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(2);
        }
        return progressIndicator;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task2) {
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(3);
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task2);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(4);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(5);
        }
        CompletableFuture<?> completableFuture = ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
        if (completableFuture == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull Executor executor, @NotNull ReadTask task2) {
        if (executor == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(7);
        }
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(8);
        }
        CompletableFuture<?> completableFuture = ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), executor, task2);
        if (completableFuture == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(10);
        }
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), progressIndicator == null ? new ProgressIndicatorBase() : progressIndicator);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(11);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    public static boolean runWithWriteActionPriority(@NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        ApplicationEx application;
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(12);
        }
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(13);
        }
        if ((application = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        if (ProgressIndicatorUtils.isWriting(application)) {
            ProgressIndicatorUtils.cancelProcess(progressIndicator);
            return false;
        }
        ApplicationListener listener2 = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressIndicatorUtils.cancelProcess(progressIndicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "beforeWriteActionStart"));
            }
        };
        Ref wasCancelled = new Ref();
        ProgressManager.getInstance().runProcess(() -> {
            application.addApplicationListener(listener2);
            try {
                if (ProgressIndicatorUtils.isWriting(application)) {
                    ProgressIndicatorUtils.cancelProcess(progressIndicator);
                    wasCancelled.set((Object)Boolean.TRUE);
                    return;
                }
                action.run();
            }
            catch (ProcessCanceledException ignore) {
                wasCancelled.set((Object)Boolean.TRUE);
            }
            finally {
                application.removeApplicationListener(listener2);
            }
        }, progressIndicator);
        return wasCancelled.get() != Boolean.TRUE;
    }

    private static void cancelProcess(ProgressIndicator progressIndicator) {
        if (!progressIndicator.isCanceled()) {
            progressIndicator.cancel();
        }
    }

    private static boolean isWriting(ApplicationEx application) {
        return application.isWriteActionPending() || application.isWriteActionInProgress();
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(14);
        }
        if (executor == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(15);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(16);
        }
        final CompletableFuture future2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (application.isDisposed() || progressIndicator.isCanceled() || future2.isCancelled()) {
                future2.complete(null);
                return;
            }
            final ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!progressIndicator.isCanceled()) {
                        progressIndicator.cancel();
                        readTask.onCanceled(progressIndicator);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$3", "beforeWriteActionStart"));
                }
            };
            application.addApplicationListener(listener2);
            future2.whenComplete((__, ___) -> application.removeApplicationListener(listener2));
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else if (!future2.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future2.isCancelled()) {
                                        return;
                                    }
                                    application.removeApplicationListener(listener2);
                                    try {
                                        if (!progressIndicator.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                });
            }
            catch (Throwable e) {
                future2.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        CompletableFuture completableFuture = future2;
        if (completableFuture == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask task2) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(18);
        }
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(19);
        }
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task2.runBackgroundProcess(progressIndicator);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator);
    }

    public static void yieldToPendingWriteActions() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            throw new IllegalStateException("Mustn't be called from within read action");
        }
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Mustn't be called from EDT");
        }
        application.invokeAndWait(EmptyRunnable.INSTANCE, ModalityState.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T withTimeout(long timeoutMs, @NotNull Computable<T> computable) {
        if (computable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(20);
        }
        ProgressManager.checkCanceled();
        ProgressIndicatorBase progress = new ProgressIndicatorBase();
        ScheduledFuture<?> cancelProgress = AppExecutorUtil.getAppScheduledExecutorService().schedule(progress::cancel, timeoutMs, TimeUnit.MILLISECONDS);
        try {
            void computable2;
            Object object = ProgressManager.getInstance().runProcess((Computable)computable2, (ProgressIndicator)progress);
            return (T)object;
        }
        catch (ProcessCanceledException e) {
            T t = null;
            return t;
        }
        finally {
            cancelProgress.cancel(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readTask";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forceWriteActionPriority";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithWriteActionPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forceWriteActionPriority";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithWriteActionPriority";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWithWriteActionPriority";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

