/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.ImmutableSyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            SyntheticLibrary.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set2 = Collections.emptySet();
        if (set2 == null) {
            SyntheticLibrary.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return null;
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(2);
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(3);
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(4);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(5);
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), excludedRoots, excludeCondition);
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(6);
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots, @NotNull Collection<VirtualFile> binaryRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(7);
        }
        if (binaryRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(8);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(9);
        }
        ImmutableSyntheticLibrary immutableSyntheticLibrary = new ImmutableSyntheticLibrary(sourceRoots, binaryRoots, excludedRoots, excludeCondition);
        if (immutableSyntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(10);
        }
        return immutableSyntheticLibrary;
    }

    @NotNull
    public final Collection<VirtualFile> getAllRoots() {
        Collection<VirtualFile> collection = this.getRoots(true, true);
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getRoots(boolean includeSources, boolean includeBinaries) {
        if (includeSources && includeBinaries) {
            Collection<VirtualFile> sourceRoots = this.getSourceRoots();
            Collection<VirtualFile> binaryRoots = this.getBinaryRoots();
            if (binaryRoots.isEmpty()) {
                Collection<VirtualFile> collection = sourceRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(12);
                }
                return collection;
            }
            if (sourceRoots.isEmpty()) {
                Collection<VirtualFile> collection = binaryRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(13);
                }
                return collection;
            }
            Set set2 = ContainerUtil.union(sourceRoots, binaryRoots);
            if (set2 == null) {
                SyntheticLibrary.$$$reportNull$$$0(14);
            }
            return set2;
        }
        if (includeSources) {
            Collection<VirtualFile> collection = this.getSourceRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(15);
            }
            return collection;
        }
        if (includeBinaries) {
            Collection<VirtualFile> collection = this.getBinaryRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(16);
            }
            return collection;
        }
        Set<VirtualFile> set3 = Collections.emptySet();
        if (set3 == null) {
            SyntheticLibrary.$$$reportNull$$$0(17);
        }
        return set3;
    }

    public final boolean contains(@NotNull VirtualFile file2, boolean includeSources, boolean includeBinaries) {
        Set<VirtualFile> roots;
        if (file2 == null) {
            SyntheticLibrary.$$$reportNull$$$0(18);
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, roots = SyntheticLibrary.asSet(this.getRoots(includeSources, includeBinaries))) && !VfsUtilCore.isUnder((VirtualFile)file2, this.getExcludedRoots());
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            SyntheticLibrary.$$$reportNull$$$0(19);
        }
        return this.contains(file2, true, true);
    }

    @NotNull
    private static <T extends VirtualFile> Set<T> asSet(@NotNull Collection<T> collection) {
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(20);
        }
        Set set2 = collection instanceof Set ? (Set)collection : ContainerUtil.newTroveSet(collection);
        if (set2 == null) {
            SyntheticLibrary.$$$reportNull$$$0(21);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newImmutableLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "asSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newImmutableLibrary";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

