/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPatchBaseVersionProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider");
    private static final Pattern ourTsPattern = Pattern.compile("\\(date ([0-9]+)\\)");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myVersionId;
    private final Pattern myRevisionPattern;
    private final AbstractVcs myVcs;

    public DefaultPatchBaseVersionProvider(Project project, VirtualFile file2, String versionId) {
        String vcsPattern;
        this.myProject = project;
        this.myFile = file2;
        this.myVersionId = versionId;
        this.myVcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(this.myFile);
        if (this.myVcs != null && (vcsPattern = this.myVcs.getRevisionPattern()) != null) {
            this.myRevisionPattern = Pattern.compile("\\(revision (" + vcsPattern + ")\\)");
            return;
        }
        this.myRevisionPattern = null;
    }

    public void getBaseVersionContent(FilePath filePath, Processor<? super String> processor2) throws VcsException {
        VcsHistorySession historySession;
        Matcher matcher;
        if (this.myVcs == null) {
            return;
        }
        VcsHistoryProvider historyProvider = this.myVcs.getVcsHistoryProvider();
        if (historyProvider == null) {
            return;
        }
        VcsRevisionNumber revision = null;
        if (this.myRevisionPattern != null && (matcher = this.myRevisionPattern.matcher(this.myVersionId)).find()) {
            VcsRevisionNumber finalRevision = revision = this.myVcs.parseRevisionNumber(matcher.group(1), filePath);
            try {
                boolean loadedExactRevision;
                if (finalRevision != null && (loadedExactRevision = ((Boolean)DefaultPatchBaseVersionProvider.computeInBackgroundTask(this.myProject, VcsBundle.message((String)"progress.text2.loading.revision", (Object[])new Object[]{finalRevision.asString()}), true, () -> {
                    if (historyProvider instanceof VcsBaseRevisionAdviser) {
                        VcsBaseRevisionAdviser revisionAdviser = (VcsBaseRevisionAdviser)historyProvider;
                        return revisionAdviser.getBaseVersionContent(filePath, processor2, finalRevision.asString());
                    }
                    DiffProvider diffProvider = this.myVcs.getDiffProvider();
                    if (diffProvider == null || filePath.getVirtualFile() == null) {
                        return false;
                    }
                    ContentRevision fileContent = diffProvider.createFileContent(finalRevision, filePath.getVirtualFile());
                    return fileContent != null && !processor2.process((Object)fileContent.getContent());
                })).booleanValue())) {
                    return;
                }
            }
            catch (ProcessCanceledException pce) {
                return;
            }
        }
        Date versionDate = null;
        if (revision == null) {
            try {
                Matcher tsMatcher = ourTsPattern.matcher(this.myVersionId);
                if (tsMatcher.find()) {
                    Long fromTsPattern = this.getFromTsPattern();
                    if (fromTsPattern == null) {
                        return;
                    }
                    versionDate = new Date(fromTsPattern);
                } else {
                    versionDate = new Date(this.myVersionId);
                }
            }
            catch (IllegalArgumentException ex) {
                return;
            }
        }
        try {
            historySession = (VcsHistorySession)DefaultPatchBaseVersionProvider.computeInBackgroundTask(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true, () -> historyProvider.createSessionFor(filePath));
        }
        catch (ProcessCanceledException e) {
            return;
        }
        if (historySession == null) {
            return;
        }
        List list2 = historySession.getRevisionList();
        if (list2 == null) {
            return;
        }
        for (VcsFileRevision fileRevision : list2) {
            boolean found;
            if (revision != null) {
                found = fileRevision.getRevisionNumber().compareTo((Object)revision) <= 0;
            } else {
                Date date = fileRevision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)fileRevision).getAuthorDate() : fileRevision.getRevisionDate();
                boolean bl = found = date != null && (date.before(versionDate) || date.equals(versionDate));
            }
            if (!found) continue;
            try {
                CharSequence content = LoadTextUtil.getTextByBinaryPresentation(fileRevision.loadContent(), this.myFile, false, false);
                processor2.process((Object)content.toString());
                break;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public boolean canProvideContent() {
        if (this.myVcs == null) {
            return false;
        }
        if (this.myRevisionPattern != null && this.myRevisionPattern.matcher(this.myVersionId).matches()) {
            return true;
        }
        if (ourTsPattern.matcher(this.myVersionId).matches()) {
            return true;
        }
        try {
            Date.parse(this.myVersionId);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    public boolean hasVcs() {
        return this.myVcs != null;
    }

    private Long getFromTsPattern() {
        String trimmed = this.myVersionId.trim();
        String startPattern = "(date";
        int start2 = trimmed.indexOf("(date");
        if (start2 >= 0) {
            String number = trimmed.substring("(date".length() + start2);
            number = number.endsWith(")") ? number.substring(0, number.length() - 1) : number;
            try {
                return Long.parseLong(number.trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static <T, E extends Exception> T computeInBackgroundTask(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled, final @NotNull ThrowableComputable<T, E> computable) throws E {
        if (title == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(0);
        }
        if (computable == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(1);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, E>(project, title, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) throws Exception {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return computable.compute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider$1", "compute"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "computable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider";
        objectArray[2] = "computeInBackgroundTask";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

