/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.BinaryPatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchWriter {
    public static void writePatches(@NotNull Project project, @NotNull String fileName2, @NotNull String basePath, @NotNull List<? extends FilePatch> patches2, @Nullable CommitContext commitContext, @NotNull Charset charset) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(0);
        }
        if (fileName2 == null) {
            PatchWriter.$$$reportNull$$$0(1);
        }
        if (basePath == null) {
            PatchWriter.$$$reportNull$$$0(2);
        }
        if (patches2 == null) {
            PatchWriter.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            PatchWriter.$$$reportNull$$$0(4);
        }
        PatchWriter.writePatches(project, fileName2, basePath, patches2, commitContext, charset, false);
    }

    public static void writePatches(@NotNull Project project, @NotNull String fileName2, @Nullable String basePath, @NotNull List<? extends FilePatch> patches2, @Nullable CommitContext commitContext, @NotNull Charset charset, boolean includeBinaries) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(5);
        }
        if (fileName2 == null) {
            PatchWriter.$$$reportNull$$$0(6);
        }
        if (patches2 == null) {
            PatchWriter.$$$reportNull$$$0(7);
        }
        if (charset == null) {
            PatchWriter.$$$reportNull$$$0(8);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName2), charset);){
            PatchWriter.write(project, writer, basePath, patches2, commitContext, includeBinaries);
        }
    }

    private static void write(@NotNull Project project, @NotNull Writer writer, @Nullable String basePath, @NotNull List<? extends FilePatch> patches2, @Nullable CommitContext commitContext, boolean includeBinaries) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(9);
        }
        if (writer == null) {
            PatchWriter.$$$reportNull$$$0(10);
        }
        if (patches2 == null) {
            PatchWriter.$$$reportNull$$$0(11);
        }
        String lineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
        UnifiedDiffWriter.write((Project)project, (String)basePath, patches2, (Writer)writer, (String)lineSeparator, (PatchEP[])((PatchEP[])PatchEP.EP_NAME.getExtensions((AreaInstance)project)), (CommitContext)commitContext);
        if (includeBinaries) {
            BinaryPatchWriter.writeBinaries(basePath, ContainerUtil.findAll(patches2, BinaryFilePatch.class), writer);
        }
    }

    public static void writeAsPatchToClipboard(@NotNull Project project, @NotNull List<? extends FilePatch> patches2, @NotNull String basePath, @Nullable CommitContext commitContext) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(12);
        }
        if (patches2 == null) {
            PatchWriter.$$$reportNull$$$0(13);
        }
        if (basePath == null) {
            PatchWriter.$$$reportNull$$$0(14);
        }
        StringWriter writer = new StringWriter();
        PatchWriter.write(project, writer, basePath, patches2, commitContext, true);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(writer.toString()));
    }

    @NotNull
    public static VirtualFile calculateBaseForWritingPatch(@NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        boolean multiVcs;
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(15);
        }
        if (changes2 == null) {
            PatchWriter.$$$reportNull$$$0(16);
        }
        File commonAncestor = ChangesUtil.findCommonAncestor(changes2);
        boolean bl = multiVcs = ChangesUtil.getAffectedVcses(changes2, (Project)project).size() != 1;
        if (multiVcs || commonAncestor == null) {
            VirtualFile virtualFile = project.getBaseDir();
            if (virtualFile == null) {
                PatchWriter.$$$reportNull$$$0(17);
            }
            return virtualFile;
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)VcsUtil.getFilePath((File)commonAncestor));
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)vcsRoot, (Object)project.getBaseDir());
        if (virtualFile == null) {
            PatchWriter.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/PatchWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/PatchWriter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBaseForWritingPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writePatches";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeAsPatchToClipboard";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateBaseForWritingPatch";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

