/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShelvedChangeList
implements JDOMExternalizable,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList");
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ATTRIBUTE_DELETED_CHANGELIST = "deleted";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public String PATH;
    public String DESCRIPTION;
    public Date DATE;
    private List<ShelvedChange> myChanges;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    private boolean myToDelete;
    private boolean myIsDeleted;
    private String mySchemeName;

    public ShelvedChangeList() {
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles) {
        this(path, description, binaryFiles, System.currentTimeMillis());
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles, long time) {
        this.PATH = FileUtil.toSystemIndependentName((String)path);
        this.DESCRIPTION = description;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
        this.mySchemeName = this.DESCRIPTION;
    }

    static ShelvedChangeList copy(@NotNull ShelvedChangeList list2) {
        if (list2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(0);
        }
        ShelvedChangeList copied = new ShelvedChangeList();
        copied.PATH = list2.PATH;
        copied.DESCRIPTION = list2.DESCRIPTION;
        copied.DATE = list2.DATE;
        copied.myBinaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file2 : list2.getBinaryFiles()) {
            copied.myBinaryFiles.add(new ShelvedBinaryFile(file2.BEFORE_PATH, file2.AFTER_PATH, file2.SHELVED_PATH));
        }
        copied.mySchemeName = list2.DESCRIPTION;
        copied.myRecycled = list2.isRecycled();
        copied.myToDelete = list2.isMarkedToDelete();
        copied.myIsDeleted = list2.isDeleted();
        return copied;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.PATH = FileUtil.toSystemIndependentName((String)this.PATH);
        this.mySchemeName = element.getAttributeValue(NAME_ATTRIBUTE);
        this.DATE = new Date(Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE)));
        this.myRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        this.myToDelete = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        this.myIsDeleted = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_DELETED_CHANGELIST));
        List children2 = element.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children2.size());
        for (Element child2 : children2) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child2);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(1);
        }
        ShelvedChangeList.writeExternal(element, this);
    }

    private static void writeExternal(@NotNull Element element, @NotNull ShelvedChangeList shelvedChangeList) throws WriteExternalException {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(2);
        }
        if (shelvedChangeList == null) {
            ShelvedChangeList.$$$reportNull$$$0(3);
        }
        DefaultJDOMExternalizer.writeExternal((Object)shelvedChangeList, (Element)element);
        element.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.DATE.getTime()));
        element.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isMarkedToDelete()));
        }
        if (shelvedChangeList.isDeleted()) {
            element.setAttribute(ATTRIBUTE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isDeleted()));
        }
        for (ShelvedBinaryFile file2 : shelvedChangeList.getBinaryFiles()) {
            Element child2 = new Element(ELEMENT_BINARY);
            file2.writeExternal(child2);
            element.addContent(child2);
        }
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public List<ShelvedChange> getChanges(Project project) {
        if (this.myChanges == null) {
            try {
                this.myChanges = new ArrayList<ShelvedChange>();
                List<? extends FilePatch> list2 = ShelveChangesManager.loadPatchesWithoutContent(project, this.PATH, null);
                for (FilePatch filePatch : list2) {
                    FileStatus status = filePatch.isNewFile() ? FileStatus.ADDED : (filePatch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
                    this.myChanges.add(new ShelvedChange(this.PATH, filePatch.getBeforeName(), filePatch.getAfterName(), status));
                }
            }
            catch (Exception e) {
                LOG.error("Failed to parse the file patch: [" + this.PATH + "]", (Throwable)e);
            }
        }
        return this.myChanges;
    }

    public void clearLoadedChanges() {
        this.myChanges = null;
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            ShelvedChangeList.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setName(@NotNull String newName) {
        if (newName == null) {
            ShelvedChangeList.$$$reportNull$$$0(5);
        }
        this.mySchemeName = newName;
    }

    public boolean isValid() {
        return new File(this.PATH).exists();
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void setDeleted(boolean isDeleted) {
        this.myIsDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    public void updateDate() {
        this.DATE = new Date(System.currentTimeMillis());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

