/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PartiallyExcludedFilesStateHolder<T>
implements Disposable {
    @NotNull
    protected final MergingUpdateQueue myUpdateQueue;
    private final Set<T> myIncludedElements;
    private final Map<T, ExclusionState> myTrackerExclusionStates;
    @NotNull
    private String myChangelistId;

    public PartiallyExcludedFilesStateHolder(@NotNull Project project, @NotNull String changelistId) {
        if (project == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(0);
        }
        if (changelistId == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(1);
        }
        this.myUpdateQueue = new MergingUpdateQueue(PartiallyExcludedFilesStateHolder.class.getName(), 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.myIncludedElements = new THashSet();
        this.myTrackerExclusionStates = new HashMap<T, ExclusionState>();
        this.myChangelistId = changelistId;
        MyTrackerListener trackerListener = new MyTrackerListener();
        MyTrackerManagerListener trackerManagerListener = new MyTrackerManagerListener(trackerListener, this);
        trackerManagerListener.install(project);
    }

    public void dispose() {
    }

    @NotNull
    protected abstract Stream<? extends T> getTrackableElementsStream();

    @Nullable
    protected abstract T findElementFor(@NotNull PartialLocalLineStatusTracker var1);

    @Nullable
    protected abstract PartialLocalLineStatusTracker findTrackerFor(@NotNull T var1);

    @NotNull
    private Stream<Pair<T, PartialLocalLineStatusTracker>> getTrackersStream() {
        Stream<Pair<T, PartialLocalLineStatusTracker>> stream = this.getTrackableElementsStream().map(element -> {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker != null) {
                return Pair.create((Object)element, (Object)tracker);
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(2);
        }
        return stream;
    }

    public void setChangelistId(@NotNull String changelistId) {
        if (changelistId == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(3);
        }
        this.myChangelistId = changelistId;
        this.updateExclusionStates();
    }

    public void updateExclusionStates() {
        this.myTrackerExclusionStates.clear();
        this.getTrackersStream().forEach(pair -> {
            Object element = pair.first;
            PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
            ExclusionState state = tracker.getExcludedFromCommitState(this.myChangelistId);
            if (state != ExclusionState.NO_CHANGES) {
                this.myTrackerExclusionStates.put(element, state);
            }
        });
    }

    @NotNull
    public ExclusionState getExclusionState(@NotNull T element) {
        ExclusionState exclusionState;
        if (element == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(4);
        }
        if ((exclusionState = this.myTrackerExclusionStates.get(element)) != null) {
            ExclusionState exclusionState2 = exclusionState;
            if (exclusionState2 == null) {
                PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(5);
            }
            return exclusionState2;
        }
        ExclusionState exclusionState3 = this.myIncludedElements.contains(element) ? ExclusionState.ALL_INCLUDED : ExclusionState.ALL_EXCLUDED;
        if (exclusionState3 == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(6);
        }
        return exclusionState3;
    }

    private void scheduleExclusionStatesUpdate() {
        this.myUpdateQueue.queue(new Update("updateExcludedFromCommit"){

            public void run() {
                PartiallyExcludedFilesStateHolder.this.updateExclusionStates();
            }
        });
    }

    public boolean isIncluded(@NotNull T element) {
        ExclusionState trackerState;
        if (element == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(7);
        }
        return (trackerState = this.getExclusionState(element)) != ExclusionState.ALL_EXCLUDED;
    }

    @NotNull
    public Set<T> getIncludedSet() {
        HashSet<T> set2 = new HashSet<T>(this.myIncludedElements);
        for (Map.Entry<T, ExclusionState> entry : this.myTrackerExclusionStates.entrySet()) {
            T element = entry.getKey();
            ExclusionState trackerState = entry.getValue();
            if (trackerState == ExclusionState.ALL_EXCLUDED) {
                set2.remove(element);
                continue;
            }
            set2.add(element);
        }
        HashSet<T> hashSet = set2;
        if (hashSet == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public void setIncludedElements(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(9);
        }
        HashSet set2 = new HashSet(elements);
        this.getTrackersStream().forEach(pair -> {
            Object element = pair.first;
            PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
            tracker.setExcludedFromCommit(!set2.contains(element));
        });
        this.myIncludedElements.clear();
        this.myIncludedElements.addAll(elements);
        this.updateExclusionStates();
    }

    public void includeElements(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(10);
        }
        for (T element : elements) {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker == null) continue;
            tracker.setExcludedFromCommit(false);
        }
        this.myIncludedElements.addAll(elements);
        this.updateExclusionStates();
    }

    public void excludeElements(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(11);
        }
        for (T element : elements) {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker == null) continue;
            tracker.setExcludedFromCommit(true);
        }
        this.myIncludedElements.removeAll(elements);
        this.updateExclusionStates();
    }

    public void toggleElements(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            PartiallyExcludedFilesStateHolder.$$$reportNull$$$0(12);
        }
        boolean hasExcluded = false;
        for (T element : elements) {
            ExclusionState exclusionState = this.getExclusionState(element);
            if (exclusionState == ExclusionState.ALL_INCLUDED) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeElements(elements);
        } else {
            this.excludeElements(elements);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistId";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackersStream";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExclusionState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChangelistId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExclusionState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "excludeElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toggleElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTrackerManagerListener
    extends LineStatusTrackerManager.ListenerAdapter {
        @NotNull
        private final PartialLocalLineStatusTracker.Listener myTrackerListener;
        @NotNull
        private final Disposable myDisposable;

        MyTrackerManagerListener(@NotNull PartialLocalLineStatusTracker.Listener listener2, Disposable disposable) {
            if (listener2 == null) {
                MyTrackerManagerListener.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyTrackerManagerListener.$$$reportNull$$$0(1);
            }
            this.myTrackerListener = listener2;
            this.myDisposable = disposable;
        }

        public void install(@NotNull Project project) {
            if (project == null) {
                MyTrackerManagerListener.$$$reportNull$$$0(2);
            }
            LineStatusTrackerManager.getInstanceImpl(project).addTrackerListener(this, this.myDisposable);
            for (LineStatusTracker<?> tracker : LineStatusTrackerManager.getInstanceImpl(project).getTrackers()) {
                if (!(tracker instanceof PartialLocalLineStatusTracker)) continue;
                PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)tracker;
                partialTracker.addListener(this.myTrackerListener, this.myDisposable);
            }
        }

        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            if (tracker == null) {
                MyTrackerManagerListener.$$$reportNull$$$0(3);
            }
            if (tracker instanceof PartialLocalLineStatusTracker) {
                PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)tracker;
                Object element = PartiallyExcludedFilesStateHolder.this.findElementFor(partialTracker);
                if (element != null) {
                    partialTracker.setExcludedFromCommit(!PartiallyExcludedFilesStateHolder.this.myIncludedElements.contains(element));
                }
                partialTracker.addListener(this.myTrackerListener, this.myDisposable);
            }
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            PartialLocalLineStatusTracker partialTracker;
            Object element;
            if (tracker == null) {
                MyTrackerManagerListener.$$$reportNull$$$0(4);
            }
            if (tracker instanceof PartialLocalLineStatusTracker && (element = PartiallyExcludedFilesStateHolder.this.findElementFor(partialTracker = (PartialLocalLineStatusTracker)tracker)) != null) {
                PartiallyExcludedFilesStateHolder.this.myTrackerExclusionStates.remove(element);
                ExclusionState exclusionState = partialTracker.getExcludedFromCommitState(PartiallyExcludedFilesStateHolder.this.myChangelistId);
                if (exclusionState != ExclusionState.NO_CHANGES) {
                    if (exclusionState != ExclusionState.ALL_EXCLUDED) {
                        PartiallyExcludedFilesStateHolder.this.myIncludedElements.add(element);
                    } else {
                        PartiallyExcludedFilesStateHolder.this.myIncludedElements.remove(element);
                    }
                }
                PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder$MyTrackerManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTrackerAdded";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTrackerRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        private MyTrackerListener() {
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(0);
            }
            PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(1);
            }
            PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tracker";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder$MyTrackerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onExcludedFromCommitChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChangeListMarkerChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

