/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.diff.Block;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.IntPair;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsSelectionHistoryDialog
extends FrameWrapper
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.impl.VcsHistoryDialog");
    private static final VcsRevisionNumber LOCAL_REVISION_NUMBER = new VcsRevisionNumber(){

        public String asString() {
            return "Local Changes";
        }

        public int compareTo(@NotNull VcsRevisionNumber vcsRevisionNumber) {
            if (vcsRevisionNumber == null) {
                1.$$$reportNull$$$0(0);
            }
            return 0;
        }

        public String toString() {
            return this.asString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRevisionNumber", "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$1", "compareTo"));
        }
    };
    private static final float DIFF_SPLITTER_PROPORTION = 0.5f;
    private static final float COMMENTS_SPLITTER_PROPORTION = 0.8f;
    private static final String DIFF_SPLITTER_PROPORTION_KEY = "file.history.selection.diff.splitter.proportion";
    private static final String COMMENTS_SPLITTER_PROPORTION_KEY = "file.history.selection.comments.splitter.proportion";
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final AbstractVcs myActiveVcs;
    @NonNls
    private final String myHelpId;
    private final List<VcsFileRevision> myRevisions;
    private final CurrentRevision myLocalRevision;
    private final ListTableModel<VcsFileRevision> myListModel;
    private final TableView<VcsFileRevision> myList;
    private final Splitter mySplitter;
    private final DiffRequestPanel myDiffPanel;
    private final JCheckBox myChangesOnlyCheckBox;
    private final JLabel myStatusLabel;
    private final AnimatedIcon myStatusSpinner;
    private final JEditorPane myComments;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final BlockLoader myBlockLoader;
    private boolean myIsDuringUpdate;
    private boolean myIsDisposed;

    public VcsSelectionHistoryDialog(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Document document, @NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull VcsHistorySession session2, @NotNull AbstractVcs vcs, int selectionStart, int selectionEnd, @NotNull String title) {
        if (project == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(1);
        }
        if (document == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(2);
        }
        if (vcsHistoryProvider == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(3);
        }
        if (session2 == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(5);
        }
        if (title == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(6);
        }
        super(project);
        this.myRevisions = new ArrayList<VcsFileRevision>();
        this.myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
        this.myStatusLabel = new JBLabel();
        this.myStatusSpinner = new AsyncProcessIcon("VcsSelectionHistoryDialog");
        this.myIsDuringUpdate = false;
        this.myIsDisposed = false;
        this.myProject = project;
        this.myFile = file2;
        this.myActiveVcs = vcs;
        this.myHelpId = (String)ObjectUtils.notNull((Object)vcsHistoryProvider.getHelpId(), (Object)"reference.dialogs.vcs.selection.history");
        this.myComments = new JEditorPane("text/html", "");
        this.myComments.setPreferredSize((Dimension)new JBDimension(150, 100));
        this.myComments.setEditable(false);
        this.myComments.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JRootPane rootPane = ((RootPaneContainer)((Object)this.getFrame())).getRootPane();
        final VcsDependentHistoryComponents components = vcsHistoryProvider.getUICustomization(session2, (JComponent)rootPane);
        Object[] defaultColumns = new ColumnInfo[]{new FileHistoryPanelImpl.RevisionColumnInfo(null), new FileHistoryPanelImpl.DateColumnInfo(), new FileHistoryPanelImpl.AuthorColumnInfo(), new FileHistoryPanelImpl.MessageColumnInfo(project)};
        Object[] additionalColumns = (ColumnInfo[])ObjectUtils.notNull((Object)components.getColumns(), (Object)ColumnInfo.EMPTY_ARRAY);
        this.myListModel = new ListTableModel((ColumnInfo[])ArrayUtil.mergeArrays((Object[])defaultColumns, (Object[])additionalColumns));
        this.myListModel.setSortable(false);
        this.myList = new TableView(this.myListModel);
        new TableLinkMouseListener().installOn((Component)this.myList);
        this.myList.getEmptyText().setText(VcsBundle.message((String)"history.empty", (Object[])new Object[0]));
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, this.getFrame());
        this.myUpdateQueue = new MergingUpdateQueue("VcsSelectionHistoryDialog", 300, true, this.myList, (Disposable)this);
        this.myLocalRevision = new CurrentRevision(file2, LOCAL_REVISION_NUMBER);
        this.myRevisions.add((VcsFileRevision)this.myLocalRevision);
        this.myRevisions.addAll(session2.getRevisionList());
        this.mySplitter = new JBSplitter(true, DIFF_SPLITTER_PROPORTION_KEY, 0.5f);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel(components.getDetailsComponent()));
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() == 1 && !VcsSelectionHistoryDialog.this.myList.isEmpty()) {
                    revision = (VcsFileRevision)VcsSelectionHistoryDialog.this.myList.getItems().get(VcsSelectionHistoryDialog.this.myList.getSelectedRow());
                    String message = IssueLinkHtmlRenderer.formatTextIntoHtml(VcsSelectionHistoryDialog.this.myProject, revision.getCommitMessage());
                    VcsSelectionHistoryDialog.this.myComments.setText(message);
                    VcsSelectionHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsSelectionHistoryDialog.this.myComments.setText("");
                }
                if (components.getRevisionListener() != null) {
                    components.getRevisionListener().consume((Object)revision);
                }
                VcsSelectionHistoryDialog.this.updateDiff();
            }
        };
        this.myList.getSelectionModel().addListSelectionListener(selectionListener);
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangesOnlyCheckBox.setSelected(configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF);
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = VcsSelectionHistoryDialog.this.myChangesOnlyCheckBox.isSelected();
                VcsSelectionHistoryDialog.this.updateRevisionsList();
            }
        });
        DefaultActionGroup popupActions = new DefaultActionGroup();
        popupActions.add((AnAction)new MyDiffAction());
        popupActions.add((AnAction)new MyDiffAfterWithLocalAction());
        popupActions.add((AnAction)ShowAllAffectedGenericAction.getInstance());
        popupActions.add(ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"));
        PopupHandler.installPopupHandler(this.myList, (ActionGroup)popupActions, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        for (AnAction action : popupActions.getChildren(null)) {
            action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)this.mySplitter);
        }
        this.setTitle(title);
        this.setComponent((JComponent)this.mySplitter);
        this.setPreferredFocusedComponent((JComponent)this.myList);
        this.setDimensionKey("VCS.FileHistoryDialog");
        this.closeOnEsc();
        this.myBlockLoader = new BlockLoader(this.myRevisions, this.myFile, document, selectionStart, selectionEnd){

            @Override
            protected void notifyError(@NotNull VcsException e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                SwingUtilities.invokeLater(() -> {
                    VcsSelectionHistoryDialog dialog2 = VcsSelectionHistoryDialog.this;
                    if (dialog2.isDisposed() || !dialog2.getFrame().isShowing()) {
                        return;
                    }
                    PopupUtil.showBalloonForComponent((Component)VcsSelectionHistoryDialog.this.mySplitter, (String)VcsSelectionHistoryDialog.canNoLoadMessage(e), (MessageType)MessageType.ERROR, (boolean)true, (Disposable)VcsSelectionHistoryDialog.this.myProject);
                });
            }

            @Override
            protected void notifyUpdate() {
                VcsSelectionHistoryDialog.this.myUpdateQueue.queue(new Update(this){

                    public void run() {
                        VcsSelectionHistoryDialog.this.updateStatusPanel();
                        VcsSelectionHistoryDialog.this.updateRevisionsList();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$4", "notifyError"));
            }
        };
        this.myBlockLoader.start(this);
        this.updateRevisionsList();
        if (this.myList.getRowCount() != 0) {
            this.myList.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @NotNull
    private static String canNoLoadMessage(@Nullable VcsException e) {
        String string = "Can not load revision contents" + (e != null ? ": " + e.getMessage() : "");
        if (string == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevisionsList() {
        if (this.myIsDuringUpdate) {
            return;
        }
        try {
            this.myIsDuringUpdate = true;
            List<VcsFileRevision> newItems = this.myChangesOnlyCheckBox.isSelected() ? this.filteredRevisions() : this.myRevisions;
            IntPair range2 = this.getSelectedRevisionsRange();
            List<VcsFileRevision> oldSelection = this.myRevisions.subList(range2.val1, range2.val2);
            this.myListModel.setItems(newItems);
            this.myList.setSelection(oldSelection);
            if (this.myList.getSelectedRowCount() == 0) {
                int index = this.getNearestVisibleRevision((VcsFileRevision)ContainerUtil.getFirstItem(oldSelection));
                if (this.myList.getRowCount() != 0) {
                    this.myList.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        }
        finally {
            this.myIsDuringUpdate = false;
        }
        this.updateDiff();
    }

    private void updateStatusPanel() {
        BlockData data = this.myBlockLoader.getLoadedData();
        if (data.isLoading()) {
            VcsFileRevision revision = data.getCurrentLoadingRevision();
            String loadingString = revision != null ? String.format("Loading revision <tt>%s</tt>...", VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber())) : "Loading...";
            this.myStatusLabel.setText(String.format("<html>%s (%s/%s)</html>", loadingString, data.myBlocks.size(), this.myRevisions.size()));
            this.myStatusSpinner.resume();
            this.myStatusSpinner.setVisible(true);
        } else {
            this.myStatusLabel.setText("");
            this.myStatusSpinner.suspend();
            this.myStatusSpinner.setVisible(false);
        }
    }

    @NotNull
    private IntPair getSelectedRevisionsRange() {
        List selection = this.myList.getSelectedObjects();
        if (selection.isEmpty()) {
            IntPair intPair = new IntPair(0, 0);
            if (intPair == null) {
                VcsSelectionHistoryDialog.$$$reportNull$$$0(8);
            }
            return intPair;
        }
        int startIndex = this.myRevisions.indexOf(ContainerUtil.getFirstItem((List)selection));
        int endIndex = this.myRevisions.indexOf(ContainerUtil.getLastItem((List)selection));
        IntPair intPair = new IntPair(startIndex, endIndex + 1);
        if (intPair == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(9);
        }
        return intPair;
    }

    private int getNearestVisibleRevision(@Nullable VcsFileRevision anchor2) {
        int anchorIndex = this.myRevisions.indexOf(anchor2);
        if (anchorIndex == -1) {
            return 0;
        }
        for (int i = anchorIndex - 1; i > 0; --i) {
            int index = this.myListModel.indexOf((Object)this.myRevisions.get(i));
            if (index == -1) continue;
            return index;
        }
        return 0;
    }

    private List<VcsFileRevision> filteredRevisions() {
        int initialCommit;
        Block initialCommitBlock;
        ArrayList<VcsFileRevision> result2 = new ArrayList<VcsFileRevision>();
        BlockData data = this.myBlockLoader.getLoadedData();
        for (int i = 1; i < this.myRevisions.size(); ++i) {
            Block block1 = data.getBlock(i - 1);
            Block block2 = data.getBlock(i);
            if (block1 == null || block2 == null) break;
            if (!block1.getLines().equals(block2.getLines())) {
                result2.add(this.myRevisions.get(i - 1));
            }
            if (block2 == EMPTY_BLOCK) break;
        }
        if ((initialCommitBlock = data.getBlock(initialCommit = this.myRevisions.size() - 1)) != null && initialCommitBlock != EMPTY_BLOCK) {
            result2.add(this.myRevisions.get(initialCommit));
        }
        return result2;
    }

    private void updateDiff() {
        if (this.myIsDisposed || this.myIsDuringUpdate) {
            return;
        }
        if (this.myList.getSelectedRowCount() == 0) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        int count = this.myRevisions.size();
        IntPair range2 = this.getSelectedRevisionsRange();
        int revIndex1 = range2.val2;
        int revIndex2 = range2.val1;
        if (revIndex1 == count && revIndex2 == count) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        BlockData blockData = this.myBlockLoader.getLoadedData();
        DiffContent content1 = this.createDiffContent(revIndex1, blockData);
        DiffContent content2 = this.createDiffContent(revIndex2, blockData);
        String title1 = this.createDiffContentTitle(revIndex1);
        String title2 = this.createDiffContentTitle(revIndex2);
        if (content1 != null && content2 != null) {
            this.myDiffPanel.setRequest((DiffRequest)new SimpleDiffRequest(null, content1, content2, title1, title2), (Object)new IntPair(revIndex1, revIndex2));
            return;
        }
        if (blockData.isLoading()) {
            this.myDiffPanel.setRequest((DiffRequest)new LoadingDiffRequest());
        } else {
            this.myDiffPanel.setRequest((DiffRequest)new MessageDiffRequest(VcsSelectionHistoryDialog.canNoLoadMessage(blockData.getException())));
        }
    }

    @Nullable
    private String createDiffContentTitle(int index) {
        if (index >= this.myRevisions.size()) {
            return null;
        }
        return VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{this.myRevisions.get(index).getRevisionNumber()});
    }

    @Nullable
    private DiffContent createDiffContent(int index, @NotNull BlockData data) {
        if (data == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(10);
        }
        if (index >= this.myRevisions.size()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        Block block = data.getBlock(index);
        if (block == null) {
            return null;
        }
        if (block == EMPTY_BLOCK) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(block.getBlockContent(), this.myFile.getFileType());
        documentContent.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value -> value + block.getStart());
        return documentContent;
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
        super.dispose();
    }

    private JComponent createBottomPanel(JComponent addComp) {
        JBSplitter splitter = new JBSplitter(true, COMMENTS_SPLITTER_PROPORTION_KEY, 0.8f);
        splitter.setDividerWidth(4);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        JPanel statusPanel = new JPanel(new FlowLayout());
        statusPanel.add((Component)this.myStatusSpinner);
        statusPanel.add(this.myStatusLabel);
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.add((Component)this.myChangesOnlyCheckBox, "West");
        separatorPanel.add((Component)statusPanel, "East");
        tablePanel.add((Component)separatorPanel, "North");
        splitter.setFirstComponent((JComponent)tablePanel);
        splitter.setSecondComponent(this.createComments(addComp));
        return splitter;
    }

    private JComponent createComments(JComponent addComp) {
        JPanel panel2 = new JPanel(new BorderLayout(4, 4));
        panel2.add((Component)new JLabel("Commit Message:"), "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComments), "Center");
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent((JComponent)panel2);
        splitter.setSecondComponent(addComp);
        return splitter;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(11);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            VcsFileRevision selectedObject = (VcsFileRevision)this.myList.getSelectedObject();
            return selectedObject instanceof CurrentRevision ? null : selectedObject;
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            List revisions = ContainerUtil.filter((Collection)this.myList.getSelectedObjects(), (Condition)Conditions.notEqualTo((Object)this.myLocalRevision));
            return revisions.toArray(new VcsFileRevision[0]);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myActiveVcs.getKeyInstanceMethod();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    @NotNull
    private DiffFromHistoryHandler getDiffHandler() {
        VcsHistoryProvider historyProvider = this.myActiveVcs.getVcsHistoryProvider();
        DiffFromHistoryHandler handler2 = historyProvider != null ? historyProvider.getHistoryDiffHandler() : null;
        Object object = handler2 != null ? handler2 : new StandardDiffFromHistoryHandler();
        if (object == null) {
            VcsSelectionHistoryDialog.$$$reportNull$$$0(12);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "canNoLoadMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRevisionsRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlockData {
        private final boolean myIsLoading;
        @NotNull
        private final List<? extends Block> myBlocks;
        @Nullable
        private final VcsException myException;
        @Nullable
        private final VcsFileRevision myCurrentLoadingRevision;

        BlockData(boolean isLoading, @NotNull List<? extends Block> blocks, @Nullable VcsException exception, @Nullable VcsFileRevision currentLoadingRevision) {
            if (blocks == null) {
                BlockData.$$$reportNull$$$0(0);
            }
            this.myIsLoading = isLoading;
            this.myBlocks = blocks;
            this.myException = exception;
            this.myCurrentLoadingRevision = currentLoadingRevision;
        }

        public boolean isLoading() {
            return this.myIsLoading;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public VcsFileRevision getCurrentLoadingRevision() {
            return this.myCurrentLoadingRevision;
        }

        @Nullable
        public Block getBlock(int index) {
            if (this.myBlocks.size() <= index) {
                return null;
            }
            return this.myBlocks.get(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockData", "<init>"));
        }
    }

    private static abstract class BlockLoader {
        @NotNull
        private final Object LOCK;
        @NotNull
        private final List<? extends VcsFileRevision> myRevisions;
        @NotNull
        private final Charset myCharset;
        @NotNull
        private final List<Block> myBlocks;
        @Nullable
        private VcsException myException;
        private boolean myIsLoading;
        private VcsFileRevision myCurrentLoadingRevision;

        BlockLoader(@NotNull List<? extends VcsFileRevision> revisions, @NotNull VirtualFile file2, @NotNull Document document, int selectionStart, int selectionEnd) {
            if (revisions == null) {
                BlockLoader.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                BlockLoader.$$$reportNull$$$0(1);
            }
            if (document == null) {
                BlockLoader.$$$reportNull$$$0(2);
            }
            this.LOCK = new Object();
            this.myBlocks = new ArrayList<Block>();
            this.myIsLoading = true;
            this.myRevisions = revisions;
            this.myCharset = file2.getCharset();
            String[] lastContent = Block.tokenize(document.getText());
            this.myBlocks.add(new Block(lastContent, selectionStart, selectionEnd + 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public BlockData getLoadedData() {
            Object object = this.LOCK;
            // MONITORENTER : object
            BlockData blockData = new BlockData(this.myIsLoading, new ArrayList<Block>(this.myBlocks), this.myException, this.myCurrentLoadingRevision);
            // MONITOREXIT : object
            if (blockData != null) return blockData;
            BlockLoader.$$$reportNull$$$0(3);
            return blockData;
        }

        public void start(@NotNull Disposable disposable) {
            if (disposable == null) {
                BlockLoader.$$$reportNull$$$0(4);
            }
            BackgroundTaskUtil.executeOnPooledThread(disposable, () -> {
                try {
                    for (int index = 1; index < this.myRevisions.size(); ++index) {
                        ProgressManager.checkCanceled();
                        Block block = this.myBlocks.get(index - 1);
                        VcsFileRevision revision = this.myRevisions.get(index);
                        Object object = this.LOCK;
                        synchronized (object) {
                            this.myCurrentLoadingRevision = revision;
                        }
                        this.notifyUpdate();
                        Block previousBlock = this.createBlock(block, revision);
                        Object object2 = this.LOCK;
                        synchronized (object2) {
                            this.myBlocks.add(previousBlock);
                        }
                        this.notifyUpdate();
                    }
                }
                catch (VcsException e) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myException = e;
                    }
                    this.notifyError(e);
                }
                finally {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myIsLoading = false;
                        this.myCurrentLoadingRevision = null;
                    }
                    this.notifyUpdate();
                }
            });
        }

        protected abstract void notifyError(@NotNull VcsException var1);

        protected abstract void notifyUpdate();

        @NotNull
        private Block createBlock(@NotNull Block block, @NotNull VcsFileRevision revision) throws VcsException {
            if (block == null) {
                BlockLoader.$$$reportNull$$$0(5);
            }
            if (revision == null) {
                BlockLoader.$$$reportNull$$$0(6);
            }
            if (block == EMPTY_BLOCK) {
                Block block2 = EMPTY_BLOCK;
                if (block2 == null) {
                    BlockLoader.$$$reportNull$$$0(7);
                }
                return block2;
            }
            String revisionContent = this.loadContents(revision);
            Block newBlock = block.createPreviousBlock(revisionContent);
            Block block3 = newBlock.getStart() != newBlock.getEnd() ? newBlock : EMPTY_BLOCK;
            if (block3 == null) {
                BlockLoader.$$$reportNull$$$0(8);
            }
            return block3;
        }

        @NotNull
        private String loadContents(@NotNull VcsFileRevision revision) throws VcsException {
            String string;
            block3: {
                if (revision == null) {
                    BlockLoader.$$$reportNull$$$0(9);
                }
                try {
                    byte[] bytes = revision.loadContent();
                    string = new String(bytes, this.myCharset);
                    if (string != null) break block3;
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
                BlockLoader.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockLoader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$BlockLoader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoadedData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBlock";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadContents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createBlock";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "loadContents";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDiffAfterWithLocalAction
    extends DumbAwareAction {
        MyDiffAfterWithLocalAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.ShowDiffWithLocal");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAfterWithLocalAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() == 1 && VcsSelectionHistoryDialog.this.myList.getSelectedObject() != VcsSelectionHistoryDialog.this.myLocalRevision);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VcsFileRevision revision;
            if (e == null) {
                MyDiffAfterWithLocalAction.$$$reportNull$$$0(1);
            }
            if ((revision = (VcsFileRevision)VcsSelectionHistoryDialog.this.myList.getSelectedObject()) == null) {
                return;
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)VcsSelectionHistoryDialog.this.myFile);
            VcsSelectionHistoryDialog.this.getDiffHandler().showDiffForTwo(VcsSelectionHistoryDialog.this.myProject, filePath, revision, (VcsFileRevision)VcsSelectionHistoryDialog.this.myLocalRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$MyDiffAfterWithLocalAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDiffAction
    extends DumbAwareAction {
        MyDiffAction() {
            super(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]), VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]), AllIcons.Actions.Diff);
            this.setShortcutSet(CommonShortcuts.getDiff());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() > 1 || VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() == 1 && VcsSelectionHistoryDialog.this.myList.getSelectedObject() != VcsSelectionHistoryDialog.this.myLocalRevision);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(1);
            }
            IntPair range2 = VcsSelectionHistoryDialog.this.getSelectedRevisionsRange();
            VcsFileRevision beforeRevision = range2.val2 < VcsSelectionHistoryDialog.this.myRevisions.size() ? (VcsFileRevision)VcsSelectionHistoryDialog.this.myRevisions.get(range2.val2) : VcsFileRevision.NULL;
            VcsFileRevision afterRevision = (VcsFileRevision)VcsSelectionHistoryDialog.this.myRevisions.get(range2.val1);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)VcsSelectionHistoryDialog.this.myFile);
            if (range2.val2 - range2.val1 > 1) {
                VcsSelectionHistoryDialog.this.getDiffHandler().showDiffForTwo(VcsSelectionHistoryDialog.this.myProject, filePath, beforeRevision, afterRevision);
            } else {
                VcsSelectionHistoryDialog.this.getDiffHandler().showDiffForOne(e, VcsSelectionHistoryDialog.this.myProject, filePath, beforeRevision, afterRevision);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/history/impl/VcsSelectionHistoryDialog$MyDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

