/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.titleLabel;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.customFrameDecorations.titleLabel.SelectedEditorFilePath;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006*\u0001\u0014\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0006\u0010#\u001a\u00020\u000bJ\b\u0010$\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/titleLabel/SelectedEditorFilePath;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "clippedProjectName", "", "clippedText", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "inited", "", "label", "Ljavax/swing/JLabel;", "value", "path", "setPath", "(Ljava/lang/String;)V", "projectName", "resizedListener", "com/intellij/openapi/wm/impl/customFrameDecorations/titleLabel/SelectedEditorFilePath$resizedListener$1", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/titleLabel/SelectedEditorFilePath$resizedListener$1;", "changeProject", "", "project", "Lcom/intellij/openapi/project/Project;", "dsp", "clipString", "component", "Ljavax/swing/JComponent;", "string", "maxWidth", "", "getView", "init", "isClipped", "update", "Companion", "intellij.platform.ide.impl"})
public class SelectedEditorFilePath {
    private String clippedText;
    private String clippedProjectName;
    private final JLabel label;
    private boolean inited;
    private final resizedListener.1 resizedListener;
    private String projectName;
    private String path;
    @NotNull
    private final Disposable disposable;
    public static final char fileSeparatorChar = '/';
    @NotNull
    public static final String ellipsisSymbol = "\u2026";
    @NotNull
    public static final String delimiterSymbol = " - ";
    public static final Companion Companion = new Companion(null);

    public final boolean isClipped() {
        return StringsKt.equals$default((String)this.clippedText, (String)this.path, (boolean)false, (int)2, null);
    }

    @NotNull
    public JComponent getView() {
        if (!this.inited) {
            this.init();
        }
        return this.label;
    }

    private final void setPath(String value) {
        if (Intrinsics.areEqual((Object)value, (Object)this.path)) {
            return;
        }
        this.path = value;
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    private final void init() {
        void subscriptionDisposable;
        this.inited = true;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(this.disposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(this, (Ref.ObjectRef)subscriptionDisposable){
            final /* synthetic */ SelectedEditorFilePath this$0;
            final /* synthetic */ Ref.ObjectRef $subscriptionDisposable;

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if ((Disposable)this.$subscriptionDisposable.element != null) {
                    Disposable disposable = (Disposable)this.$subscriptionDisposable.element;
                    if (disposable == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!Disposer.isDisposed((Disposable)disposable)) {
                        Disposable disposable2 = (Disposable)this.$subscriptionDisposable.element;
                        if (disposable2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Disposer.dispose((Disposable)disposable2);
                    }
                }
                Disposable disposable = Disposer.newDisposable();
                Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
                Disposable dsp = disposable;
                Disposer.register((Disposable)this.this$0.getDisposable(), (Disposable)dsp);
                this.$subscriptionDisposable.element = dsp;
                this.this$0.changeProject(project, dsp);
            }
            {
                this.this$0 = $outer;
                this.$subscriptionDisposable = $captured_local_variable$1;
            }
        });
        this.getView().addComponentListener(this.resizedListener);
        Disposer.register((Disposable)this.disposable, (Disposable)new Disposable(this){
            final /* synthetic */ SelectedEditorFilePath this$0;

            public final void dispose() {
                this.this$0.getView().removeComponentListener(SelectedEditorFilePath.access$getResizedListener$p(this.this$0));
            }
            {
                this.this$0 = selectedEditorFilePath;
            }
        });
    }

    protected void changeProject(@NotNull Project project, @NotNull Disposable dsp) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dsp, (String)"dsp");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        this.projectName = string;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Function0<Unit> updatePath$ = new Function0<Unit>(this, fileEditorManager){
            final /* synthetic */ SelectedEditorFilePath this$0;
            final /* synthetic */ FileEditorManager $fileEditorManager;

            public final void invoke() {
                Object object;
                if (this.$fileEditorManager instanceof FileEditorManagerEx) {
                    object = ((FileEditorManagerEx)this.$fileEditorManager).getCurrentFile();
                    if (object == null || (object = object.getCanonicalPath()) == null) {
                        object = "";
                    }
                } else {
                    object = this.$fileEditorManager;
                    if (object == null || (object = object.getSelectedEditor()) == null || (object = object.getFile()) == null || (object = object.getCanonicalPath()) == null) {
                        object = "";
                    }
                }
                SelectedEditorFilePath.access$setPath$p(this.this$0, (String)object);
            }
            {
                this.this$0 = selectedEditorFilePath;
                this.$fileEditorManager = fileEditorManager;
                super(0);
            }
        };
        project.getMessageBus().connect(dsp).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(updatePath$){
            final /* synthetic */ changeProject.1 $updatePath$1;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                this.$updatePath$1.invoke();
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                this.$updatePath$1.invoke();
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$updatePath$1.invoke();
            }
            {
                this.$updatePath$1 = $captured_local_variable$0;
            }
        });
        this.update();
    }

    private final void update() {
        String string;
        String string2;
        FontMetrics fm;
        String string3 = this.path;
        SelectedEditorFilePath selectedEditorFilePath = this;
        String it = string3;
        boolean bl = false;
        FontMetrics pnfm = fm = this.label.getFontMetrics(this.label.getFont());
        Insets insets = this.label.getInsets(null);
        int width = this.label.getWidth() - (insets.right + insets.left);
        int pnWidth = SwingUtilities2.stringWidth(this.label, pnfm, this.projectName);
        int textWidth = SwingUtilities2.stringWidth(this.label, fm, this.path);
        int symbolWidth = SwingUtilities2.stringWidth(this.label, fm, ellipsisSymbol);
        int delimiterWidth = SwingUtilities2.stringWidth(this.label, fm, delimiterSymbol);
        if (pnWidth > width) {
            this.getView().setToolTipText(this.path);
            this.clippedProjectName = "";
            string2 = "";
        } else if (pnWidth == width || pnWidth + symbolWidth + delimiterWidth >= width) {
            this.label.setToolTipText(this.path);
            this.clippedProjectName = this.projectName;
            string2 = "";
        } else if (textWidth > width - pnWidth - delimiterWidth) {
            this.getView().setToolTipText(this.path);
            this.clippedProjectName = this.projectName;
            String clipString = this.clipString(this.label, this.path, width - pnWidth - delimiterWidth);
            CharSequence charSequence = clipString;
            string2 = charSequence.length() == 0 ? "" : delimiterSymbol + clipString;
        } else {
            this.getView().setToolTipText(null);
            this.clippedProjectName = this.projectName;
            CharSequence charSequence = this.path;
            string2 = charSequence.length() == 0 ? "" : delimiterSymbol + this.path;
        }
        selectedEditorFilePath.clippedText = string = string2;
        this.label.setText(this.clippedProjectName + this.clippedText);
    }

    /*
     * WARNING - void declaration
     */
    private final String clipString(JComponent component, String string, int maxWidth) {
        FontMetrics fm = component.getFontMetrics(component.getFont());
        int symbolWidth = SwingUtilities2.stringWidth(component, fm, ellipsisSymbol);
        if (symbolWidth < maxWidth) {
            int availTextWidth = maxWidth - symbolWidth;
            List separate = StringsKt.split$default((CharSequence)string, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            String str = "";
            int stringWidth = 0;
            int n = CollectionsKt.getLastIndex((List)separate);
            int n2 = 1;
            while (n >= n2) {
                void i;
                if ((stringWidth += SwingUtilities2.stringWidth(component, fm, (String)separate.get((int)i) + '/')) <= availTextWidth) {
                    char c = '/';
                    String string2 = (String)separate.get((int)i);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = String.valueOf(c) + string2;
                    str = stringBuilder.append(string3).append(str).toString();
                }
                --i;
            }
            CharSequence charSequence = str;
            return charSequence.length() == 0 ? "" : ellipsisSymbol + str;
        }
        return "";
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    public SelectedEditorFilePath(@NotNull Disposable disposable) {
        JLabel jLabel;
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.disposable = disposable;
        this.clippedProjectName = "";
        JLabel jLabel2 = new JLabel();
        SelectedEditorFilePath selectedEditorFilePath = this;
        JLabel $receiver = jLabel2;
        boolean bl = false;
        $receiver.setEnabled(false);
        selectedEditorFilePath.label = jLabel = jLabel2;
        this.resizedListener = new ComponentAdapter(this){
            final /* synthetic */ SelectedEditorFilePath this$0;

            public void componentResized(@Nullable ComponentEvent e) {
                SelectedEditorFilePath.access$update(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.projectName = "";
        this.path = "";
    }

    public static final /* synthetic */ resizedListener.1 access$getResizedListener$p(SelectedEditorFilePath $this) {
        return $this.resizedListener;
    }

    public static final /* synthetic */ String access$getPath$p(SelectedEditorFilePath $this) {
        return $this.path;
    }

    public static final /* synthetic */ void access$setPath$p(SelectedEditorFilePath $this, String string) {
        $this.setPath(string);
    }

    public static final /* synthetic */ void access$update(SelectedEditorFilePath $this) {
        $this.update();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/titleLabel/SelectedEditorFilePath$Companion;", "", "()V", "delimiterSymbol", "", "ellipsisSymbol", "fileSeparatorChar", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

