/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformIdTableBuilding {
    public static final Key<EditorHighlighter> EDITOR_HIGHLIGHTER = new Key("Editor");
    private static final TokenSet ABSTRACT_FILE_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    private PlatformIdTableBuilding() {
    }

    @Nullable
    public static DataIndexer<TodoIndexEntry, Integer, FileContent> getTodoIndexer(FileType fileType, VirtualFile virtualFile) {
        DataIndexer extIndexer;
        if (fileType instanceof SubstitutedFileType && !((SubstitutedFileType)fileType).isSameFileType()) {
            SubstitutedFileType sft = (SubstitutedFileType)fileType;
            extIndexer = new CompositeTodoIndexer(PlatformIdTableBuilding.getTodoIndexer(sft.getOriginalFileType(), virtualFile), PlatformIdTableBuilding.getTodoIndexer(sft.getFileType(), virtualFile));
        } else {
            extIndexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
        }
        if (extIndexer != null) {
            return extIndexer;
        }
        if (fileType instanceof LanguageFileType) {
            TokenSet commentTokens;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet tokenSet = commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            if (commentTokens != null) {
                return new TokenSetTodoIndexer(commentTokens, virtualFile);
            }
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new TokenSetTodoIndexer(ABSTRACT_FILE_COMMENT_TOKENS, virtualFile);
        }
        return null;
    }

    public static boolean checkCanUseCachedEditorHighlighter(CharSequence chars, EditorHighlighter editorHighlighter) {
        assert (editorHighlighter instanceof LexerEditorHighlighter);
        boolean b = ((LexerEditorHighlighter)editorHighlighter).checkContentIsEqualTo(chars);
        if (!b) {
            Logger logger = Logger.getInstance((String)IdTableBuilding.class.getName());
            logger.warn("Unexpected mismatch of editor highlighter content with indexing content");
        }
        return b;
    }

    public static boolean isTodoIndexerRegistered(@NotNull FileType fileType) {
        if (fileType == null) {
            PlatformIdTableBuilding.$$$reportNull$$$0(0);
        }
        return TodoIndexers.INSTANCE.forFileType(fileType) != null || fileType instanceof InternalFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding", "isTodoIndexerRegistered"));
    }

    private static class TokenSetTodoIndexer
    extends VersionedTodoIndexer {
        @NotNull
        private final TokenSet myCommentTokens;
        private final VirtualFile myFile;

        TokenSetTodoIndexer(@NotNull TokenSet commentTokens, @NotNull VirtualFile file2) {
            if (commentTokens == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(1);
            }
            this.myCommentTokens = commentTokens;
            this.myFile = file2;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(2);
            }
            if (IndexPatternUtil.getIndexPatternCount() > 0) {
                EditorHighlighter highlighter;
                CharSequence chars = inputData.getContentAsText();
                OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
                EditorHighlighter editorHighlighter = (EditorHighlighter)inputData.getUserData(EDITOR_HIGHLIGHTER);
                if (editorHighlighter != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(chars, editorHighlighter)) {
                    highlighter = editorHighlighter;
                } else {
                    highlighter = HighlighterFactory.createHighlighter((Project)inputData.getProject(), (VirtualFile)this.myFile);
                    highlighter.setText(chars);
                }
                int documentLength = chars.length();
                BaseFilterLexer.TodoScanningState todoScanningState = null;
                HighlighterIterator iterator = highlighter.createIterator(0);
                while (!iterator.atEnd()) {
                    IElementType token = iterator.getTokenType();
                    if (this.myCommentTokens.contains(token) || CacheUtil.isInComments(token)) {
                        int start2 = iterator.getStart();
                        if (start2 >= documentLength) break;
                        int end = iterator.getEnd();
                        todoScanningState = BaseFilterLexer.advanceTodoItemsCount(chars.subSequence(start2, Math.min(end, documentLength)), occurrenceConsumer, todoScanningState);
                        if (end > documentLength) break;
                    }
                    iterator.advance();
                }
                HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
                for (IndexPattern pattern : IndexPatternUtil.getIndexPatterns()) {
                    int count = occurrenceConsumer.getOccurrenceCount(pattern);
                    if (count <= 0) continue;
                    map2.put(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), count);
                }
                HashMap<TodoIndexEntry, Integer> hashMap = map2;
                if (hashMap == null) {
                    TokenSetTodoIndexer.$$$reportNull$$$0(3);
                }
                return hashMap;
            }
            Map<TodoIndexEntry, Integer> map3 = Collections.emptyMap();
            if (map3 == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(4);
            }
            return map3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTokens";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CompositeTodoIndexer
    extends VersionedTodoIndexer {
        private final DataIndexer<TodoIndexEntry, Integer, FileContent>[] indexers;

        @SafeVarargs
        CompositeTodoIndexer(DataIndexer<TodoIndexEntry, Integer, FileContent> ... indexers) {
            if (indexers == null) {
                CompositeTodoIndexer.$$$reportNull$$$0(0);
            }
            this.indexers = indexers;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                CompositeTodoIndexer.$$$reportNull$$$0(1);
            }
            THashMap result2 = ContainerUtil.newTroveMap();
            for (DataIndexer<TodoIndexEntry, Integer, FileContent> indexer : this.indexers) {
                if (indexer == null) continue;
                for (Map.Entry entry : indexer.map((Object)inputData).entrySet()) {
                    TodoIndexEntry key = (TodoIndexEntry)entry.getKey();
                    if (result2.containsKey(key)) {
                        result2.put(key, (Integer)result2.get(key) + (Integer)entry.getValue());
                        continue;
                    }
                    result2.put(key, entry.getValue());
                }
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                CompositeTodoIndexer.$$$reportNull$$$0(2);
            }
            return tHashMap;
        }

        @Override
        public int getVersion() {
            int version2 = super.getVersion();
            for (DataIndexer<TodoIndexEntry, Integer, FileContent> dataIndexer : this.indexers) {
                version2 += dataIndexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)dataIndexer).getVersion() : 255;
            }
            return version2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$CompositeTodoIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$CompositeTodoIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

