/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeImpl");
    private final int myHC;
    private volatile VolatileState myVolatileState;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
        this.myHC = ourHC++;
    }

    protected XmlAttributeImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            XmlAttributeImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myHC = ourHC++;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child2) {
        if (child2 == null) {
            XmlAttributeImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child2.getTreeParent() == this);
        IElementType i = child2.getElementType();
        if (i == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
    }

    public void setValue(@NotNull String valueText) throws IncorrectOperationException {
        if (valueText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(2);
        }
        final ASTNode value = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = this.createAttribute(valueText, StringUtil.defaultIfEmpty((String)this.getName(), (String)"a"));
        final ASTNode newValue = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                XmlAttributeImpl att = XmlAttributeImpl.this;
                if (value != null) {
                    if (newValue != null) {
                        att.replaceChild(value, newValue.copyElement());
                    } else {
                        att.removeChild(value);
                    }
                } else if (newValue != null) {
                    att.addChild(newValue.getTreePrev().copyElement());
                    att.addChild(newValue.copyElement());
                }
                return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlAttributeImpl.this.getParent(), XmlAttributeImpl.this.getName(), newValue != null ? newValue.getText() : null);
            }
        });
    }

    @NotNull
    protected XmlAttribute createAttribute(@NotNull String valueText, String name) {
        if (valueText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(3);
        }
        XmlAttribute xmlAttribute = XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(name, valueText, (PsiElement)this);
        if (xmlAttribute == null) {
            XmlAttributeImpl.$$$reportNull$$$0(4);
        }
        return xmlAttribute;
    }

    public XmlElement getNameElement() {
        return (XmlElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
    }

    @NotNull
    public String getNamespace() {
        String name = this.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.isEmpty()) {
            if ("" == null) {
                XmlAttributeImpl.$$$reportNull$$$0(5);
            }
            return "";
        }
        String string = this.getParent().getNamespaceByPrefix(prefixByQualifiedName);
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        String string = XmlUtil.findLocalNameByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeImpl.$$$reportNull$$$0(9);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    protected void appendChildToDisplayValue(@NotNull StringBuilder buffer, @NotNull ASTNode child2) {
        if (buffer == null) {
            XmlAttributeImpl.$$$reportNull$$$0(10);
        }
        if (child2 == null) {
            XmlAttributeImpl.$$$reportNull$$$0(11);
        }
        buffer.append(child2.getChars());
    }

    @Nullable
    public String getDisplayValue() {
        VolatileState state = this.getFreshState();
        return state == null ? null : state.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        if (physicalIndex < 0 || physicalIndex > state.myValueTextRange.getLength()) {
            return -1;
        }
        if (state.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(state.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - state.myGapDisplayStarts[gapIndex];
        return Math.max(state.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    public int displayToPhysical(int displayIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        String displayValue = state.myDisplayText;
        if (displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        int[] gapDisplayStarts = state.myGapDisplayStarts;
        if (gapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(gapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - gapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    @NotNull
    public TextRange getValueTextRange() {
        VolatileState state = this.getFreshState();
        TextRange textRange = state == null ? TextRange.EMPTY_RANGE : state.myValueTextRange;
        if (textRange == null) {
            XmlAttributeImpl.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myVolatileState = null;
    }

    @Override
    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @NotNull
    public PsiElement setName(final @NotNull String nameText) throws IncorrectOperationException {
        ASTNode name;
        if (nameText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(14);
        }
        final String oldName = (name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this)) == null ? "" : name.getText();
        final String oldValue = (String)ObjectUtils.notNull((Object)this.getValue(), (Object)"");
        final PomModel model = PomManager.getModel((Project)this.getProject());
        final XmlAttribute attribute = this.createAttribute(oldValue, nameText);
        final ASTNode newName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        final Ref replaced = Ref.create((Object)this);
        model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)this.getParent(), (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                PsiFile file2 = XmlAttributeImpl.this.getContainingFile();
                XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, file2 instanceof XmlFile ? (XmlFile)file2 : null);
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), oldName, null));
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), nameText, oldValue));
                event.registerChangeSet(model.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
                if (!oldValue.isEmpty() && XmlAttributeImpl.this.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this.getTreeParent(), XmlAttributeImpl.this, attribute.getNode());
                    replaced.set((Object)attribute);
                } else if (name != null && newName != null) {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this, name, newName);
                }
                return event;
            }
        });
        PsiElement psiElement = (PsiElement)replaced.get();
        if (psiElement == null) {
            XmlAttributeImpl.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(16);
        }
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlAttributeImpl.$$$reportNull$$$0(17);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        PsiReference[] refs;
        XmlElement nameElement;
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(18);
        }
        if (hints.offsetInElement != null && ((nameElement = this.getNameElement()) == null || hints.offsetInElement > nameElement.getStartOffsetInParent() + nameElement.getTextLength())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                XmlAttributeImpl.$$$reportNull$$$0(19);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (this.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.getLocalName();
            String prefix = XmlUtil.findPrefixByQualifiedName(this.getName());
            TextRange range2 = prefix.isEmpty() ? TextRange.from((int)this.getName().length(), (int)0) : TextRange.from((int)(prefix.length() + 1), (int)localName.length());
            refs[0] = new SchemaPrefixReference(this, range2, localName, null);
        } else {
            String prefix = this.getNamespacePrefix();
            if (!prefix.isEmpty() && !this.getLocalName().isEmpty()) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                refs[0] = new SchemaPrefixReference(this, TextRange.from((int)0, (int)prefix.length()), prefix, null);
                refs[1] = new XmlAttributeReference(this);
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new XmlAttributeReference(this);
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        if (refs == null) {
            XmlAttributeImpl.$$$reportNull$$$0(20);
        }
        return refs;
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getDescriptorImpl(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.externalResourceModificationTracker()}));
    }

    @NotNull
    private ModificationTracker externalResourceModificationTracker() {
        Project project = this.getProject();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        ModificationTracker modificationTracker = () -> manager.getModificationCount(project);
        if (modificationTracker == null) {
            XmlAttributeImpl.$$$reportNull$$$0(21);
        }
        return modificationTracker;
    }

    @Nullable
    private XmlAttributeDescriptor getDescriptorImpl() {
        XmlTag tag = this.getParent();
        if (tag == null) {
            return null;
        }
        XmlElementDescriptor descr = tag.getDescriptor();
        if (descr == null) {
            return null;
        }
        XmlAttributeDescriptor attributeDescr = descr.getAttributeDescriptor((XmlAttribute)this);
        return attributeDescr == null ? descr.getAttributeDescriptor(this.getName(), tag) : attributeDescr;
    }

    @NotNull
    public String getRealLocalName() {
        String name = this.getLocalName();
        String string = name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private VolatileState getFreshState() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VolatileState state = this.myVolatileState;
        if (state == null) {
            state = this.recalculate();
        }
        return state;
    }

    @Nullable
    private VolatileState recalculate() {
        VolatileState volatileState;
        XmlAttributeValue value = this.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child2 = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value.getTextLength());
        if (child2 != null && child2.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child2.getTextLength(), valueTextRange.getEndOffset());
            child2 = child2.getTreeNext();
        }
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        StringBuilder buffer = new StringBuilder(this.getTextLength());
        while (child2 != null) {
            int start2 = buffer.length();
            IElementType elementType = child2.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child2.getTextRange().getStartOffset() - value.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child2.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlAttributeImpl.getEntityValue((XmlEntityRef)child2));
            } else {
                this.appendChildToDisplayValue(buffer, child2);
            }
            int end = buffer.length();
            int originalLength = child2.getTextLength();
            if (end - start2 != originalLength) {
                gapsStarts.add(start2);
                gapsShifts.add(originalLength - (end - start2));
            }
            child2 = child2.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i = 0; i < gapDisplayStarts.length; ++i) {
            gapDisplayStarts[i] = gapsStarts.get(i);
            gapPhysicalStarts[i] = gapDisplayStarts[i] + (currentGapsSum += gapsShifts.get(i));
        }
        this.myVolatileState = volatileState = new VolatileState(buffer.toString(), gapDisplayStarts, gapPhysicalStarts, valueTextRange);
        return volatileState;
    }

    @NotNull
    private static String getEntityValue(@NotNull XmlEntityRef entityRef) {
        XmlAttributeValue valueElement;
        XmlEntityDecl decl;
        if (entityRef == null) {
            XmlAttributeImpl.$$$reportNull$$$0(23);
        }
        if ((decl = entityRef.resolve(entityRef.getContainingFile())) != null && (valueElement = decl.getValueElement()) != null) {
            String string = valueElement.getValue();
            if (string == null) {
                XmlAttributeImpl.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = entityRef.getText();
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameText";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttribute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "externalResourceModificationTracker";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealLocalName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAttribute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendChildToDisplayValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getEntityValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VolatileState {
        @NotNull
        private final String myDisplayText;
        @NotNull
        private final int[] myGapDisplayStarts;
        @NotNull
        private final int[] myGapPhysicalStarts;
        @NotNull
        private final TextRange myValueTextRange;

        private VolatileState(@NotNull String displayText, @NotNull int[] gapDisplayStarts, @NotNull int[] gapPhysicalStarts, @NotNull TextRange valueTextRange) {
            if (displayText == null) {
                VolatileState.$$$reportNull$$$0(0);
            }
            if (gapDisplayStarts == null) {
                VolatileState.$$$reportNull$$$0(1);
            }
            if (gapPhysicalStarts == null) {
                VolatileState.$$$reportNull$$$0(2);
            }
            if (valueTextRange == null) {
                VolatileState.$$$reportNull$$$0(3);
            }
            this.myDisplayText = displayText;
            this.myGapDisplayStarts = gapDisplayStarts;
            this.myGapPhysicalStarts = gapPhysicalStarts;
            this.myValueTextRange = valueTextRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gapDisplayStarts";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gapPhysicalStarts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueTextRange";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl$VolatileState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

