/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.util.ui.EmptyIcon;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemScrubber
extends TBItem
implements NSTLibrary.ScrubberDelegate {
    private final int myWidth;
    private final NSTLibrary.ScrubberCacheUpdater myUpdater;
    private List<ItemData> myItems;
    private int myNativeItemsCount;

    TBItemScrubber(@NotNull String uid, @Nullable ItemListener listener2, int scrubWidth) {
        if (uid == null) {
            TBItemScrubber.$$$reportNull$$$0(0);
        }
        super(uid, listener2);
        this.myWidth = scrubWidth;
        this.myUpdater = () -> {
            if (this.myItems == null || this.myItems.isEmpty()) {
                return 0;
            }
            if (this.myNativeItemsCount >= this.myItems.size()) {
                return 0;
            }
            int chunkSize = 25;
            int newItemsCount = Math.min(25, this.myItems.size() - this.myNativeItemsCount);
            NST.appendScrubberItems(this.myNativePeer, this.myItems, this.myNativeItemsCount, newItemsCount);
            this.myNativeItemsCount += newItemsCount;
            return newItemsCount;
        };
    }

    TBItemScrubber addItem(Icon icon, String text, Runnable action) {
        Runnable nativeAction;
        if (this.myItems == null) {
            this.myItems = new ArrayList<ItemData>();
        }
        Runnable runnable2 = nativeAction = action == null && this.myListener == null ? null : () -> {
            if (action != null) {
                action.run();
            }
            if (this.myListener != null) {
                this.myListener.onItemEvent(this, 0);
            }
        };
        if (icon instanceof EmptyIcon) {
            icon = null;
        } else if (icon != null) {
            icon = IconLoader.getDarkIcon((Icon)icon, (boolean)true);
        }
        this.myItems.add(new ItemData(icon, text, nativeAction));
        this.updateNativePeer();
        return this;
    }

    @Override
    protected void _updateNativePeer() {
        Logger.getInstance(TBItemScrubber.class).error("_updateNativePeer of scrubber masn't be called");
    }

    @Override
    protected ID _createNativePeer() {
        this.myNativeItemsCount = this.myItems == null || this.myItems.isEmpty() ? 0 : Math.min(30, this.myItems.size());
        return NST.createScrubber(this.myUid, this.myWidth, this, this.myUpdater, this.myItems, this.myNativeItemsCount);
    }

    @Override
    public void execute(int itemIndex) {
        if (this.myItems == null || this.myItems.isEmpty() || itemIndex < 0 || itemIndex >= this.myItems.size()) {
            return;
        }
        ItemData id = this.myItems.get(itemIndex);
        if (id != null && id.myAction != null) {
            id.myAction.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uid", "com/intellij/ui/mac/touchbar/TBItemScrubber", "<init>"));
    }

    static class ItemData {
        private byte[] myTextBytes;
        final Icon myIcon;
        final String myText;
        final Runnable myAction;
        final float fMulX;

        ItemData(Icon icon, String text, Runnable action) {
            this.myIcon = icon;
            this.myText = text;
            this.myAction = action;
            Application app = ApplicationManager.getApplication();
            this.fMulX = this.myIcon == null ? 1.0f : (app != null && UISettings.getInstance().getPresentationMode() ? 40.0f / (float)this.myIcon.getIconHeight() : (this.myIcon.getIconHeight() < 24 ? 2.5f : 44.0f / (float)this.myIcon.getIconHeight()));
        }

        byte[] getTextBytes() {
            if (this.myTextBytes == null && this.myText != null) {
                try {
                    this.myTextBytes = this.myText.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return this.myTextBytes;
        }
    }
}

